#ifndef __PROP_SCREENSAVER_H__
#define __PROP_SCREENSAVER_H__

#include "screensaver.h"
#include <gtk/gtk.h>

struct SelectInfo;

struct ConfigScreenSaver {

     // list of known screensavers
     GHashTable *ssavers;

     // current(selected) screensaver mode
     ScreenSaverMode *curMode;

     // some important widgets
     GtkWidget *vbox, *monitor, *mlist, *sw;

     ConfigScreenSaver (GtkWidget *);

     // global screensaver parameters
     GtkWidget *lock;
     GtkWidget *waitMin;
     GtkWidget *nice;

     GtkWidget *settings_frame ();
     GtkWidget *modes_frame ();
     void add_screensaver (ScreenSaver *ss);

     static void select_mode (GtkWidget *, GdkEventButton *,SelectInfo *si);
     static void test_mode (GtkWidget *, ConfigScreenSaver *th);
     static void setup_mode (GtkWidget *, ConfigScreenSaver *th);
     void setup_screensavers ();
};

#endif
