/*
 * GNOME time/date display module.
 * (C) 1997 The Free Software Foundation
 *
 * Author: Miguel de Icaza
 *
 * Feel free to implement new look and feels :-)
 */

#include <stdio.h>
#include <libintl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include "gnome.h"
#include "../applet.h"
#include <time.h>

/* Computer clock widgets */
GtkWidget *cc_vbox;
GtkWidget *cc_day;
GtkWidget *cc_hour;

/* Main clock container */
GtkWidget *cc;

int clock_timeout;

int
clock_timeout_callback (void *data)
{
	static char date [20], hour [20];
	time_t current_time;
	char *strtime;
	
	time (&current_time);
	strtime = ctime (&current_time);

	if (strncmp (date, strtime, 10)){
		strncpy (date, strtime, 10);
		gtk_label_set (GTK_LABEL (cc_day), date);
	}
	strtime += 11;
	if (strncmp (hour, strtime, 5)){
		strncpy (hour, strtime, 5);
		gtk_label_set (GTK_LABEL (cc_hour), hour);
	}
	return 1;
}

GtkWidget *
create_computer_clock_widget (GtkWidget *window)
{
	cc_vbox = gtk_vbox_new (FALSE, FALSE);
	cc_day  = gtk_label_new ("");
	cc_hour = gtk_label_new ("");
	gtk_widget_show (cc_vbox);
	gtk_widget_show (cc_day);
	gtk_widget_show (cc_hour);
	
	gtk_box_pack_start_defaults (GTK_BOX(cc_vbox), cc_day);
	gtk_box_pack_start_defaults (GTK_BOX(cc_vbox), cc_hour);

	clock_timeout_callback (0);
	return cc_vbox;
}

GtkWidget *
create_analog_clock (GtkWidget *window)
{
	return 0;
}

void
clock_destroy (GtkWidget *widget, void *data)
{
	gtk_timeout_remove (clock_timeout);
}

GtkWidget *
create_clock_widget (GtkWidget *window)
{
	GtkWidget *widget;
	GtkWidget *align;
	
	cc = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME(cc), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show (cc);

	align = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
	gtk_container_border_width (GTK_CONTAINER(align), 4);
	gtk_widget_show (align);
	
	clock_timeout = gtk_timeout_add (3000, clock_timeout_callback, 0);

	/* choose style here */
	widget = create_computer_clock_widget (window);
	
	gtk_container_add (GTK_CONTAINER(cc), align);
	gtk_container_add (GTK_CONTAINER(align), widget);

	gtk_signal_connect (GTK_OBJECT(cc), "destroy", (GtkSignalFunc) clock_destroy, 0);
	return cc;
}

char *
query (void)
{
	return "Clock";
}

void *
clock_callback (AppletCommand *cmd)
{
	/* nothing yet */
	return 0;
}

void
init (PanelCallback callback, Panel *panel, char *params, int xpos, int ypos)
{
	PanelCommand cmd;
	GtkWidget *clock;

	clock = create_clock_widget (panel->window);
	cmd.cmd = PANEL_CMD_REGISTER_TOY;
	cmd.params.register_toy.applet   = clock;
	cmd.params.register_toy.callback = clock_callback;
	cmd.params.register_toy.id       = query();
	cmd.params.register_toy.params   = params;
	cmd.params.register_toy.xpos     = xpos;
	cmd.params.register_toy.ypos     = ypos;
	cmd.params.register_toy.flags    = APPLET_HAS_PROPERTIES;

	(*callback) (&cmd);
}
