#include <string.h>
#include "applet.h"
#include "panel.h"

static void
load_default_applets(void)
{
	applets_init_applet("Menu", ".", 0, 0);
	applets_init_applet("Mail check", "", 550, 0);
	applets_init_applet("Clock", "", 700, 0);
}


static void
init_user_applets(void)
{
	void *iterator;
	char *key;
	char *realkey;
	char *value;
	char *applet_name;
	char *applet_params;
	int   xpos, ypos;

	iterator = gnome_config_init_iterator("/panel/Applets");

	if (!iterator)
		load_default_applets();
	
	while (iterator) {
		iterator = gnome_config_iterator_next(iterator, &key, &value);
		realkey = strchr(key, ',') + 1; /* Skip over number-for-unique-keys hack and go to applet id */
		applet_params = strchr(realkey, ','); /* Everything after first comma is parameters to the applet */
		if (applet_params)
			*applet_params++ = '\0'; /* Terminate string at comma and skip over it */
		else
			applet_params = "";

		applet_name = realkey;

		if (sscanf(value, "%d%d", &xpos, &ypos) != 2) {
			fprintf(stderr, "init_user_applets: using position (0, 0) for applet "
				"without specified position\n");

			xpos = ypos = 0;
		}
		applets_init_applet(applet_name, applet_params, xpos, ypos);
		g_free (key);
		g_free (value);
	}
}


int
main(int argc, char **argv)
{
	gnome_init(&argc, &argv);

	panel_init();
	applets_init();
	init_user_applets();

	gtk_widget_show(the_panel->window);
	
	gtk_main();
	return 0;
}
