#ifndef PANEL_H
#define PANEL_H

#include "gnome.h"

BEGIN_GNOME_DECLS


/* Panel types */

typedef enum {
	PANEL_POS_TOP,
	PANEL_POS_BOTTOM,
	PANEL_POS_LEFT,
	PANEL_POS_RIGHT
} PanelPos;

typedef enum {
	PANEL_HIDDEN,
	PANEL_SHOWN
} PanelState;

typedef enum {
	PANEL_STAYS_PUT,
	PANEL_GETS_HIDDEN
} PanelMode;

typedef struct {
	GtkWidget  *window;
	GtkWidget  *fixed;
	PanelPos    pos;
	PanelState  state;
	PanelMode   mode;
	int         step_size;
	int         delay;
	gint        enter_notify_id;
	gint        leave_notify_id;
	GtkWidget  *applet_being_dragged;
	gint        applet_drag_click_x;
	gint        applet_drag_click_y;
	gint        applet_drag_orig_x;
	gint        applet_drag_orig_y;
} Panel;


/* Applet types */

typedef enum {
	APPLET_HAS_PROPERTIES = 1L << 0
} AppletFlags;


/* Applet command types */

typedef enum {
	APPLET_CMD_PROPERTIES,
	APPLET_CMD_TOOLTIPS
} AppletCommandType;

typedef struct {
	AppletCommandType cmd;

	Panel     *panel;
	GtkWidget *applet;
	
	union {
		int tool_tips;
	} params;
} AppletCommand;

typedef gpointer (*AppletCallback) (AppletCommand *cmd);


/* Panel command types */

typedef enum {
	PANEL_CMD_REGISTER_TOY,
	PANEL_CMD_QUIT,
	PANEL_CMD_NEW_APPLET,
	PANEL_CMD_GET_APPLET_TYPES
} PanelCommandType;

typedef struct {
	PanelCommandType cmd;

	union {
		/* Register toy parameters */
		struct {
			GtkWidget      *applet;
			AppletCallback  callback;
			char           *id;
			char           *params;
			int           	xpos;
			int           	ypos;
			long          	flags;
		} register_toy;

		/* New Applet parameters: applet name, arguments to applet */
		struct {
			char           *applet;
			char           *params;
		} new_applet;
	} params;
} PanelCommand;

typedef gpointer (*PanelCallback) (PanelCommand *cmd);


extern Panel *the_panel;


void panel_init(void);

gpointer panel_command (PanelCommand *cmd);

END_GNOME_DECLS

#endif
