#ifndef __ORBIT_DEBUG_H__
#define __ORBIT_DEBUG_H__

/*
 * Flip this switch to dump 
 * general debug messages.
 */
#undef DEBUG

/*
 * Flip this switch to get a nice trace
 * of method invocations.
 */
#undef TRACE_DEBUG

/*
 * Define this to get microsecond time stamps on
 * each method invocation, a-la strace -ttt
 */
#undef TRACE_TIMING

/*
 * Flip this switch if you want tyeplib
 * related warnings.
 */
#undef TYPE_DEBUG

/*
 * Define this one to get object profile hashing
 * and other object related debug.
 */
#undef OBJECT_DEBUG


#ifndef DEBUG

static inline void dprintf (const char *format, ...) { };
#define dump_arg(a,b)

#else /* DEBUG */

#include <stdio.h>

#define dprintf(...) fprintf(stderr, __VA_ARGS__)

static inline void
dump_arg (const ORBit_IArg *a, CORBA_TypeCode tc)
{
	fprintf (stderr, " '%s' : kind - %d, %c%c",
		 a->name, tc->kind, 
		 a->flags & (ORBit_I_ARG_IN | ORBit_I_ARG_INOUT) ? 'i' : ' ',
		 a->flags & (ORBit_I_ARG_OUT | ORBit_I_ARG_INOUT) ? 'o' : ' ');
}

#endif /* DEBUG */



#ifndef TRACE_DEBUG

static inline void tprintf (const char *format, ...) { };
#define tprintf_trace_value(a,b)
#define tprintf_header(obj,md)
#define tprintf_timestamp()
#define tprintf_end_method()

#else /* TRACE_DEBUG */

#include <stdio.h>

void     ORBit_trace_objref     (const CORBA_Object   obj);
void     ORBit_trace_any        (const CORBA_any     *any);
void     ORBit_trace_typecode   (const CORBA_TypeCode tc);
void     ORBit_trace_value      (gconstpointer       *val,
				 CORBA_TypeCode       tc);
void     ORBit_trace_header     (CORBA_Object         object,
				 ORBit_IMethod       *m_data);
void     ORBit_trace_end_method (void);
void     ORBit_trace_profiles   (CORBA_Object obj);

#define tprintf(...) fprintf(stderr, __VA_ARGS__)
#define tprintf_header(obj,md) ORBit_trace_header(obj,md)
#define tprintf_trace_value(a,b) \
		ORBit_trace_value ((gconstpointer *)(a), (b))
#define tprintf_end_method() \
		ORBit_trace_end_method ()


#ifdef TRACE_TIMING
#  define tprintf_timestamp() \
		ORBit_trace_timestamp ()
void     ORBit_trace_timestamp (void);
#else
#  define tprintf_timestamp()
#endif

#endif /* TRACE_DEBUG */

#endif /* __ORBIT_DEBUG_H__ */
