/*
 *  Copyright (C) 2002 Christophe Fergeau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GUL_NOTEBOOK_H
#define GUL_NOTEBOOK_H

#include <glib.h>
#include <gtk/gtknotebook.h>

G_BEGIN_DECLS

typedef struct GulNotebookClass GulNotebookClass;

#define GUL_NOTEBOOK_TYPE             (gul_notebook_get_type ())
#define GUL_NOTEBOOK(obj)             (GTK_CHECK_CAST ((obj), GUL_NOTEBOOK_TYPE, GulNotebook))
#define GUL_NOTEBOOK_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), GUL_NOTEBOOK_TYPE, GulNotebookClass))
#define IS_GUL_NOTEBOOK(obj)          (GTK_CHECK_TYPE ((obj), GUL_NOTEBOOK_TYPE))
#define IS_GUL_NOTEBOOK_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), GUL_NOTEBOOK))

typedef struct GulNotebook GulNotebook;
typedef struct GulNotebookPrivate GulNotebookPrivate;

typedef enum
{
	GUL_NOTEBOOK_TAB_LOAD_ACTIVATED,
	GUL_NOTEBOOK_TAB_LOAD_STARTED,
	GUL_NOTEBOOK_TAB_LOAD_COMPLETED
} GulNotebookPageLoadStatus;

struct GulNotebook 
{
	GtkNotebook parent;
        GulNotebookPrivate *priv;
};

struct GulNotebookClass
{
        GtkNotebookClass parent_class;
};

GType 		gul_notebook_get_type 		(void);

GtkWidget      *gul_notebook_new 		(void);

void		gul_notebook_insert_page	(GulNotebook *nb,
						 GtkWidget *child,
						 int position,
						 gboolean jump_to);

void		gul_notebook_remove_page	(GulNotebook *nb,
						 GtkWidget *child);

void		gul_notebook_set_page_status 	(GulNotebook *nb,
			      			 GtkWidget *child,
			      			 GulNotebookPageLoadStatus status);

void		gul_notebook_set_page_title 	(GulNotebook *nb,
			      			 GtkWidget *child,
			      			 const char *title);
 
G_END_DECLS;

#endif /* GUL_NOTEBOOK_H */
