#ifndef __GST_VIDEO_WIDGET_H__
#define __GST_VIDEO_WIDGET_H__

#include <config.h>

#include <gst/gst.h>
#include <gtk/gtkaspectframe.h>

#define GST_TYPE_VIDEO_WIDGET          (gst_video_widget_get_type ())
#define GST_VIDEO_WIDGET(obj)          (GTK_CHECK_CAST ((obj), GST_TYPE_VIDEO_WIDGET, GstVideoWidget))
#define GST_VIDEO_WIDGET_CLASS(klass)  (GTK_CHECK_CLASS_CAST ((klass), GST_TYPE_VIDEO_WIDGET, GstVideoWidgetClass))
#define GST_IS_VIDEO_WIDGET(obj)       (GTK_CHECK_TYPE ((obj), GST_TYPE_VIDEO_WIDGET))
#define GST_IS_VIDEO_WIDGET_CLASS(obj) (GTK_CHECK_CLASS_TYPE ((klass), GST_TYPE_VIDEO_WIDGET))

typedef struct _GstVideoWidget GstVideoWidget;
typedef struct _GstVideoWidgetClass GstVideoWidgetClass;


typedef struct _GstVideoWidgetPrivate GstVideoWidgetPrivate;

struct _GstVideoWidget {
	GtkAspectFrame parent;

	GtkWidget  *video_socket;
	gint xembed_xid;
	gint source_width;
	gint source_height;
	gfloat scale_factor;
	gboolean scale;
};
	

#define GST_VIDEO_WIDGET_STATE(play)         ((play)->state)
#define GST_VIDEO_WIDGET_MEDIA_TYPE(play)    ((play)->flags)
#define GST_VIDEO_WIDGET_IS_AUDIO_TYPE(play) ((play)->flags & GST_VIDEO_WIDGET_TYPE_AUDIO)
#define GST_VIDEO_WIDGET_IS_VIDEO_TYPE(play) ((play)->flags & GST_VIDEO_WIDGET_TYPE_VIDEO)

struct _GstVideoWidgetClass {
	GtkAspectFrameClass parent_class;
};


GtkType 	gst_video_widget_get_type		(void);

/* setup the player */
GtkWidget*	gst_video_widget_new			(void);

/* set display stuff */
void		gst_video_widget_set_source_size	(GstVideoWidget *vw, gint width, gint height);
void		gst_video_widget_reset_socket		(GstVideoWidget *vw);
void		gst_video_widget_set_xembed_xid		(GstVideoWidget *vw, gint xid);
gint            gst_video_widget_get_source_width       (GstVideoWidget *play);
gint            gst_video_widget_get_source_height      (GstVideoWidget *play);


#endif /* __GST_VIDEO_WIDGET_H__ */
