; AisleRiot - thirteen.scm
; Copyright (C) 1999, 2003 Rosanna Yuen <rwsy@mit.edu>
;
; This game is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2, or (at your option)
; any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA

(define (new-game)
  (initialize-playing-area)  
  (set-ace-low)
  (make-standard-deck)
  (shuffle-deck)

  (add-normal-slot DECK)
  (add-normal-slot '())
  (set! HORIZPOS (- HORIZPOS (/ 2 3)))
  (add-extended-slot '() right)

  (add-carriage-return-slot)

  (add-blank-slot)
  (add-blank-slot)
  (add-blank-slot)
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (set! HORIZPOS (+ HORIZPOS 0.5))
  (add-blank-slot)
  (add-blank-slot)
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (add-blank-slot)
  (add-blank-slot)
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (set! HORIZPOS (+ HORIZPOS 0.5))
  (add-blank-slot)
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (add-blank-slot)
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (set! HORIZPOS (+ HORIZPOS 0.5))
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (deal-cards 0 '( 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23))
  (deal-cards-face-up 0 '(24 25 26 27 28 29 30))

  (give-status-message)

  (list 7 4)
)

(define (give-status-message)
  (set-statusbar-message (get-stock-no-string)))

(define (get-stock-no-string)
  (string-append (_"Stock left:") " " 
		 (number->string (length (get-cards 0)))))

(define (button-pressed slot-id card-list)
  (and (not (empty-slot? slot-id))
       (is-visible? (car card-list))
       (= (length card-list) 1)
       (not (= (get-value (car card-list)) king))))

(define (check-for-flips slot-id)
  (cond ((= slot-id 30)
	 (if (empty-slot? 29)
	     (flip-top-card 23)
	     ))
	((= slot-id 29)
	 (begin
	   (if (empty-slot? 30)
	       (flip-top-card 23)
	       )
	   (if (empty-slot? 28)
	       (flip-top-card 22)
	       )))
	((= slot-id 28)
	 (begin
	   (if (empty-slot? 29)
	       (flip-top-card 22)
	       )
	   (if (empty-slot? 27)
	       (flip-top-card 21)
	       )))
	((= slot-id 27)
	 (begin
	   (if (empty-slot? 28)
	       (flip-top-card 21)
	       )
	   (if (empty-slot? 26)
	       (flip-top-card 20)
	       )))
	((= slot-id 26)
	 (begin
	   (if (empty-slot? 27)
	       (flip-top-card 20)
	       )
	   (if (empty-slot? 25)
	       (flip-top-card 19)
	       )))
	((= slot-id 25)
	 (begin
	   (if (empty-slot? 26)
	       (flip-top-card 19)
	       )
	   (if (empty-slot? 24)
	       (flip-top-card 18)
	       )))
	((= slot-id 24)
	 (if (empty-slot? 25)
	     (flip-top-card 18)
	     ))
	((= slot-id 23)
	 (if (empty-slot? 22)
	     (flip-top-card 17)
	     ))
	((= slot-id 22)
	 (begin
	   (if (empty-slot? 23)
	       (flip-top-card 17)
	       )
	   (if (empty-slot? 21)
	       (flip-top-card 16)
	       )))
	((= slot-id 21)
	 (begin
	   (if (empty-slot? 22)
	       (flip-top-card 16)
	       )
	   (if (empty-slot? 20)
	       (flip-top-card 15)
	       )))
	((= slot-id 20)
	 (begin
	   (if (empty-slot? 21)
	       (flip-top-card 15)
	       )
	   (if (empty-slot? 19)
	       (flip-top-card 14)
	       )))
	((= slot-id 19)
	 (begin
	   (if (empty-slot? 20)
	       (flip-top-card 14)
	       )
	   (if (empty-slot? 18)
	       (flip-top-card 13)
	       )))
	((= slot-id 18)
	 (if (empty-slot? 19)
	     (flip-top-card 13)
	     ))
	((= slot-id 17)
	 (if (empty-slot? 16)
	     (flip-top-card 12)
	     ))
	((= slot-id 16)
	 (begin
	   (if (empty-slot? 17)
	       (flip-top-card 12)
	       )
	   (if (empty-slot? 15)
	       (flip-top-card 11)
	       )))
	((= slot-id 15)
	 (begin
	   (if (empty-slot? 16)
	       (flip-top-card 11)
	       )
	   (if (empty-slot? 14)
	       (flip-top-card 10)
	       )))
	((= slot-id 14)
	 (begin
	   (if (empty-slot? 15)
	       (flip-top-card 10)
	       )
	   (if (empty-slot? 13)
	       (flip-top-card 9)
	       )))
	((= slot-id 13)
	 (if (empty-slot? 14)
	     (flip-top-card 9)
	     ))
	((= slot-id 12)
	 (if (empty-slot? 11)
	     (flip-top-card 8)
	     ))
	((= slot-id 11)
	 (begin
	   (if (empty-slot? 12)
	       (flip-top-card 8)
	       )
	   (if (empty-slot? 10)
	       (flip-top-card 7)
	       )))
	((= slot-id 10)
	 (begin
	   (if (empty-slot? 11)
	       (flip-top-card 7)
	       )
	   (if (empty-slot? 9)
	       (flip-top-card 6)
	       )))
	((= slot-id 9)
	 (if (empty-slot? 10)
	     (flip-top-card 6)
	     ))
	((= slot-id 8)
	 (if (empty-slot? 7)
	     (flip-top-card 5)
	     ))
	((= slot-id 7)
	 (begin
	   (if (empty-slot? 8)
	       (flip-top-card 5)
	       )
	   (if (empty-slot? 6)
	       (flip-top-card 4)
	       )))
	((= slot-id 6)
	 (if (empty-slot? 7)
	     (flip-top-card 4)
	     ))
	((= slot-id 5)
	 (if (empty-slot? 4)
	     (flip-top-card 3)
	     ))
	((= slot-id 4)
	 (if (empty-slot? 5)
	     (flip-top-card 3)
	     ))
	))

(define (check-double-flips start-slot end-slot)
  (if (= 1 (- (max start-slot end-slot) (min start-slot end-slot)))
      (let ((smaller (min start-slot end-slot)))
	(cond ((= smaller 29)
	       (flip-top-card 23))
	      ((= smaller 28)
	       (flip-top-card 22))
	      ((= smaller 27)
	       (flip-top-card 21))
	      ((= smaller 26)
	       (flip-top-card 20))
	      ((= smaller 25)
	       (flip-top-card 19))
	      ((= smaller 24)
	       (flip-top-card 18))
	      ((= smaller 22)
	       (flip-top-card 17))
	      ((= smaller 21)
	       (flip-top-card 16))
	      ((= smaller 20)
	       (flip-top-card 15))
	      ((= smaller 19)
	       (flip-top-card 14))
	      ((= smaller 18)
	       (flip-top-card 13))
	      ((= smaller 16)
	       (flip-top-card 12))
	      ((= smaller 15)
	       (flip-top-card 11))
	      ((= smaller 14)
	       (flip-top-card 10))
	      ((= smaller 13)
	       (flip-top-card 9))
	      ((= smaller 11)
	       (flip-top-card 8))
	      ((= smaller 10)
	       (flip-top-card 7))
	      ((= smaller 9)
	       (flip-top-card 6))
	      ((= smaller 7)
	       (flip-top-card 5))
	      ((= smaller 6)
	       (flip-top-card 4))
	      ((= smaller 4)
	       (flip-top-card 3))
	      (#t #t)))))

(define (droppable? start-slot card-list end-slot)
  (and (not (empty-slot? end-slot))
       (is-visible? (get-top-card end-slot))
       (= 13 (+ (get-value (car card-list))
		(get-value (get-top-card end-slot))))))

(define (button-released start-slot card-list end-slot)
  (and (droppable? start-slot card-list end-slot)
       (remove-card end-slot)
       (check-for-flips start-slot)
       (check-for-flips end-slot)
       (check-double-flips start-slot end-slot)
       (if (or (= start-slot 1)
	       (= end-slot 1))
	   (if (not (empty-slot? 2))
	       (begin
		 (let ((new-contents (get-cards 2)))
		   (let ((moving-back (car (reverse new-contents))))
		     (set-cards! 1 (list moving-back)))
		   (set-cards! 2 (reverse (cdr (reverse new-contents))))))))
       (add-to-score! 2)))

(define (button-clicked slot-id)
  (if (= slot-id 0)
      (if (not (empty-slot? 0))
	  (begin
	    (if (not (empty-slot? 1))
		(begin
		  (let ((new-contents (get-cards 2)))
		    (set-cards! 2 (reverse 
				   (cons (make-visible (make-card 
							(get-value (get-top-card 1))
							(get-suit (get-top-card 1))))
					 (reverse new-contents)))))
		  (remove-card 1)))
	    (deal-cards-face-up 0 '(1)))
	  #f)
      (and (not (empty-slot? slot-id))
	   (is-visible? (get-top-card slot-id))
	   (= (get-value (get-top-card slot-id))
	      king)
	   (remove-card slot-id)
	   (check-for-flips slot-id)
	   (if (= slot-id 1)
	       (if (not (empty-slot? 2))
		   (begin
		     (let ((new-contents (get-cards 2)))
		       (let ((moving-back (car (reverse new-contents))))
			 (set-cards! 1 (list moving-back)))
		       (set-cards! 2 (reverse (cdr (reverse new-contents))))))))
	   (add-to-score! 1))))

(define (button-double-clicked slot-id)
  #f)

(define (game-continuable)
  (give-status-message)
  (and (not (game-won))
       (get-hint)))

(define (game-won)
  (and (empty-slot? 3)
       (empty-slot? 1)
       (empty-slot? 0)))

(define (check-move slot1 slot2)
  (if (or (empty-slot? slot1)
	  (not (is-visible? (get-top-card slot1))))
      (if (< slot1 29)
	  (check-move (+ 1 slot1) (+ 2 slot1))
	  #f)
      (if (= king (get-value (get-top-card slot1)))
	  (list 2 (get-name (get-top-card slot1)) (_"itself"))
	  (if (or (empty-slot? slot2)
		  (not (is-visible? (get-top-card slot2)))
		  (not (= 13 (+ (get-value (get-top-card slot1))
				(get-value (get-top-card slot2))))))
	      (if (< slot2 30)
		  (check-move slot1 (+ 1 slot2))
		  (if (< slot1 29)
		      (check-move (+ 1 slot1) (+ 2 slot1))
		      #f))
	      (list 1 
		    (get-name (get-top-card slot1)) 
		    (get-name (get-top-card slot2)))))))

(define (dealable?)
  (if (not (empty-slot? 0))
      (list 0 (_"Deal a card"))
      #f))

(define (get-hint)
  (or (check-move 1 2)  
      (dealable?)))

(define (get-options) 
  #f)

(define (apply-options options) 
  #f)

(define (timeout) 
  #f)

(set-features droppable-feature)

(set-lambda new-game button-pressed button-released button-clicked
button-double-clicked game-continuable game-won get-hint get-options
apply-options timeout droppable?)
