/* Encoding stuff */

/*
 * Copyright (C) 2002 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef TERMINAL_ENCODING_H
#define TERMINAL_ENCODING_H

#include <gconf/gconf-client.h>
#include <gtk/gtkwindow.h>

typedef enum
{
  TERMINAL_ENCODING_CURRENT_LOCALE,

  TERMINAL_ENCODING_ISO_8859_1,
  TERMINAL_ENCODING_ISO_8859_2,
  TERMINAL_ENCODING_ISO_8859_3,
  TERMINAL_ENCODING_ISO_8859_4,
  TERMINAL_ENCODING_ISO_8859_5,
  TERMINAL_ENCODING_ISO_8859_6,
  TERMINAL_ENCODING_ISO_8859_7,
  TERMINAL_ENCODING_ISO_8859_8,
  TERMINAL_ENCODING_ISO_8859_8_I,
  TERMINAL_ENCODING_ISO_8859_9,
  TERMINAL_ENCODING_ISO_8859_10,
  TERMINAL_ENCODING_ISO_8859_13,
  TERMINAL_ENCODING_ISO_8859_14,
  TERMINAL_ENCODING_ISO_8859_15,
  TERMINAL_ENCODING_ISO_8859_16,

  TERMINAL_ENCODING_UTF_7,
  TERMINAL_ENCODING_UTF_8,
  TERMINAL_ENCODING_UTF_16,
  TERMINAL_ENCODING_UCS_2,
  TERMINAL_ENCODING_UCS_4,

  TERMINAL_ENCODING_ARMSCII_8,
  TERMINAL_ENCODING_BIG5,
  TERMINAL_ENCODING_BIG5_HKSCS,
  TERMINAL_ENCODING_CP_866,

  TERMINAL_ENCODING_EUC_JP,
  TERMINAL_ENCODING_EUC_KR,
  TERMINAL_ENCODING_EUC_TW,

  TERMINAL_ENCODING_GB18030,
  TERMINAL_ENCODING_GB2312,
  TERMINAL_ENCODING_GBK,
  TERMINAL_ENCODING_GEOSTD8,
  TERMINAL_ENCODING_HZ,

  TERMINAL_ENCODING_IBM_850,
  TERMINAL_ENCODING_IBM_852,
  TERMINAL_ENCODING_IBM_855,
  TERMINAL_ENCODING_IBM_857,
  TERMINAL_ENCODING_IBM_862,
  TERMINAL_ENCODING_IBM_864,

  TERMINAL_ENCODING_ISO_2022_JP,
  TERMINAL_ENCODING_ISO_2022_KR,
  TERMINAL_ENCODING_ISO_IR_111,
  TERMINAL_ENCODING_JOHAB,
  TERMINAL_ENCODING_KOI8_R,
  TERMINAL_ENCODING_KOI8_U,

  TERMINAL_ENCODING_MAC_ARABIC,
  TERMINAL_ENCODING_MAC_CE,
  TERMINAL_ENCODING_MAC_CROATIAN,
  TERMINAL_ENCODING_MAC_CYRILLIC,
  TERMINAL_ENCODING_MAC_DEVANAGARI,
  TERMINAL_ENCODING_MAC_FARSI,
  TERMINAL_ENCODING_MAC_GREEK,
  TERMINAL_ENCODING_MAC_GUJARATI,
  TERMINAL_ENCODING_MAC_GURMUKHI,
  TERMINAL_ENCODING_MAC_HEBREW,
  TERMINAL_ENCODING_MAC_ICELANDIC,
  TERMINAL_ENCODING_MAC_ROMAN,
  TERMINAL_ENCODING_MAC_ROMANIAN,
  TERMINAL_ENCODING_MAC_TURKISH,
  TERMINAL_ENCODING_MAC_UKRAINIAN,
  
  TERMINAL_ENCODING_SHIFT_JIS,
  TERMINAL_ENCODING_TCVN,
  TERMINAL_ENCODING_TIS_620,
  TERMINAL_ENCODING_UHC,
  TERMINAL_ENCODING_VISCII,

  TERMINAL_ENCODING_WINDOWS_1250,
  TERMINAL_ENCODING_WINDOWS_1251,
  TERMINAL_ENCODING_WINDOWS_1252,
  TERMINAL_ENCODING_WINDOWS_1253,
  TERMINAL_ENCODING_WINDOWS_1254,
  TERMINAL_ENCODING_WINDOWS_1255,
  TERMINAL_ENCODING_WINDOWS_1256,
  TERMINAL_ENCODING_WINDOWS_1257,
  TERMINAL_ENCODING_WINDOWS_1258,

  TERMINAL_ENCODING_LAST
  
} TerminalEncodingIndex;

typedef struct
{
  int      index;
  gboolean valid;
  char    *charset;
  char    *name;
} TerminalEncoding;

void terminal_encoding_init (GConfClient *conf);

GtkWidget* terminal_encoding_dialog_new (GtkWindow *transient_parent);

GSList* terminal_get_active_encodings (void);

void terminal_encoding_free (TerminalEncoding *encoding);

char* terminal_encoding_get_name (const char *charset);

#endif /* TERMINAL_ENCODING_H */
