#include <libgnomeprintui/gnome-print-page-selector.h>

#include <libgnomeprint/gnome-print-config.h>

#include <gtk/gtkwindow.h>
#include <gtk/gtkmain.h>

int
main (int argc, char **argv)
{
	GnomePrintConfig *config;
	GtkWidget *d, *ps;

	gtk_init (&argc, &argv);

	config = gnome_print_config_default ();
	g_message ("Initial configuration:");
	gnome_print_config_dump (config);

	d = g_object_new (GTK_TYPE_WINDOW, NULL);
	ps = g_object_new (GNOME_TYPE_PRINT_PAGE_SELECTOR, "config", config,
			"current", 15, NULL);
	gtk_widget_show (ps);
	gtk_container_add (GTK_CONTAINER (d), ps);
	g_signal_connect (G_OBJECT (d), "delete-event",
			G_CALLBACK (gtk_main_quit), NULL);
	gtk_widget_show (d);
	gtk_main ();

	g_message ("Final configuration:");
	gnome_print_config_dump (config);
	g_object_unref (G_OBJECT (config));

	return 0;
}
