
#include <pthread.h>
#include <unistd.h>
#include <cstdio>
#include <cstdlib>
#include <cassert>
#include <cstring>

#include <libelf.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/wait.h>

#include <glib.h>
#include <glib/gstdio.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>


#include "client/linux/handler/exception_handler.h"

using namespace google_breakpad;

extern "C" int gtk_module_init (int *argc, char** argv[]);
static bool    run_bug_buddy   (const gchar *appname, pid_t pid, const gchar *minidump_path);


static gchar *bugbuddy;

// Callback when minidump written.
static bool MinidumpCallback(const char *dump_path,
                             const char *minidump_id,
                             void *context,
                             bool succeeded) {
  gchar *appname;
  gchar *minidump_file;

	
  printf("%s is dumped\n", minidump_id);
  appname = g_get_prgname ();
  minidump_file = g_build_filename (dump_path, minidump_id, ".dmp", NULL);
  run_bug_buddy (appname, 0, minidump_file);

  g_unlink (minidump_file);
  g_free (minidump_file);
  _exit(0);
}

static bool
elf_has_debug_symbols (char *filename)
{
       int fd;
       Elf *elf;
       Elf_Scn* section = 0;
       int number = 0;

       if (elf_version(EV_CURRENT) == EV_NONE ) {
               fprintf(stderr, "Elf library out of date!n");
		return false;
       }

       fd = open(filename, O_RDONLY);

       if ((elf = elf_begin(fd, ELF_C_READ, NULL)) == NULL){
               close (fd);
               return false;
       }  
       while ((section = elf_nextscn(elf, section)) != 0) {
               char *name = 0;
               Elf32_Shdr *shdr;
               if ((shdr = elf32_getshdr (section)) != 0) {
                       if (shdr->sh_type == SHT_SYMTAB) {
                               return true;
                       }
               }
       }
       /* no symtab */
       return false;
}



static bool
release_grabs (void)
{
        /* Make sure we release grabs */
        gdk_pointer_ungrab(GDK_CURRENT_TIME);
        gdk_keyboard_ungrab(GDK_CURRENT_TIME);
        XUngrabServer (GDK_DISPLAY ());

        gdk_flush();

	return true;
}

static bool
run_bug_buddy (const gchar *appname, pid_t pid, const gchar *minidump_path)
{
	gchar *exec_str;
	gboolean res;
	GError *error = NULL;

	if (pid != 0) 
		exec_str = g_strdup_printf("bug-buddy "
				   	"--appname=\"%s\" "
				  	 "--pid=%d",
				   	appname,(int) pid);
	else if (minidump_path != NULL)
		exec_str = g_strdup_printf("bug-buddy "
				   	"--appname=\"%s\" "
				  	 "--minidump=%s",
				   	appname, minidump_path);
	else
		return false;


	res = g_spawn_command_line_sync (exec_str, NULL, NULL,
					 NULL, &error);
	g_free(exec_str);
	if (!res) {
		g_warning("Couldn't run bug-buddy\n");
		return false;
	}

	return true;
}

static bool
run_gdb (const gchar *appname, pid_t pid)
{
	gchar *exec_str;
	gchar *title;
	gboolean res;
	GError *error = NULL;

	title = g_strdup_printf ("Debugging %s", appname);

	exec_str = g_strdup_printf("gnome-terminal "
				 "--title=\"%s\" "
				 "--disable-factory "
				 "--command=\"gdb %s %d\"",
				title, appname, (int)pid);
				g_free (title);
	res = g_spawn_command_line_sync (exec_str, NULL, NULL,
					 NULL, &error);
	g_free(exec_str);
	if (!res) {
		g_warning("Couldn't run debugger\n");
		return false;
	}

	return true;
}

static bool
check_if_gdb (void *callback_context)
{
	char mypath[255];
	gchar *gdb;
	bool has_debug_symbols;
	char *filename;
	gchar *appname;
	pid_t pid;
	gboolean res;

	release_grabs ();

	if (g_getenv ("GNOME_DISABLE_CRASH_DIALOG"))
		_exit(0);

	appname = g_get_prgname ();
	pid = getpid ();
	gdb = g_find_program_in_path ("gdb");

	if (gdb && g_getenv("GNOME_HACKER")) {
		res = run_gdb (appname, pid);
		if (!res)
			_exit (1);
		_exit(0);
	}
	
	memset(mypath, 0, sizeof(mypath));
	readlink ("/proc/self/exe", mypath, sizeof(mypath));
	has_debug_symbols = elf_has_debug_symbols (mypath);


	if (bugbuddy && gdb && has_debug_symbols) {
		res = run_bug_buddy (appname, pid, NULL);
		if (!res)
			_exit (1);
		_exit(0);
	}

	return true;
}
		
int
gtk_module_init (int *argc, char** argv[])
{
	bugbuddy = g_find_program_in_path ("bug-buddy");
	
	if (bugbuddy && !g_getenv ("GNOME_DISABLE_CRASH_DIALOG")) {
  		static ExceptionHandler handler("/tmp", check_if_gdb,
						MinidumpCallback, NULL, true);
	}
  
}
