/*
 * Copyright (C) 2001, 2002 Anders Carlsson <andersca@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>

#include <gnome.h>
#include <gconf/gconf.h>

#include "gconf-editor-application.h"
#include "gconf-stock-icons.h"
#include "gconf-editor-window.h"


gint
main (gint argc, gchar **argv)
{
	
	GnomeProgram *program;
	GOptionContext *context;
	GtkWidget *window;

	static gchar **remaining_args = NULL;
	gchar *initial_key = NULL;
		
	const GOptionEntry entries[] = 
	{
	  { G_OPTION_REMAINING, '\0', 0, G_OPTION_ARG_STRING_ARRAY, &remaining_args, NULL, N_("[KEY]") },
	  { NULL }
	};

	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	context = g_option_context_new (N_("- Directly edit your entire configuration database"));

	g_option_context_set_translation_domain (context, GETTEXT_PACKAGE);

	g_option_context_add_main_entries (context, entries, GETTEXT_PACKAGE);

	program = gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
									argc, argv,
									GNOME_PARAM_GOPTION_CONTEXT, context,								
									GNOME_PARAM_APP_DATADIR, DATADIR,
									GNOME_PARAM_NONE);

	/* Register our stock icons */
        gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (), ICONDIR);
	gconf_stock_icons_register ();

        gtk_window_set_default_icon_name ("gconf-editor");

	window = gconf_editor_application_create_editor_window (GCONF_EDITOR_WINDOW_TYPE_NORMAL);
	gtk_widget_show_now (window);

	/* get the key specified on the command line if any. Ignore the rest */
	initial_key = remaining_args != NULL ? remaining_args[0] : NULL;

	if (initial_key != NULL)
		gconf_editor_window_go_to (GCONF_EDITOR_WINDOW (window),initial_key);
	
	gtk_main ();

	gnome_accelerators_sync();
	
	g_object_unref(program);

	g_strfreev (remaining_args);

	return 0;
}
