/* 
 *  Copyright (C) 2002  Ricardo Fernndezs Pascual <ric@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "bookmarks-icon-provider.h"
#include "galeon-marshal.h"

static void		gb_icon_provider_base_init		(gpointer g_class);

GType
gb_icon_provider_get_type (void)
{
	static GType icon_provider_type = 0;
	
	if (! icon_provider_type)
	{
		static const GTypeInfo icon_provider_info =
			{
				sizeof (GbIconProviderIface),			/* class_size */
				gb_icon_provider_base_init,			/* base_init */
				NULL,						/* base_finalize */
				NULL,
				NULL,						/* class_finalize */
				NULL,						/* class_data */
				0,
				0,						/* n_preallocs */
				NULL
			};
		
		icon_provider_type = g_type_register_static 
			(G_TYPE_INTERFACE, "GbIconProvider", &icon_provider_info, 0);
		g_type_interface_add_prerequisite (icon_provider_type, G_TYPE_OBJECT);
	}
	
	return icon_provider_type;
}

static void
gb_icon_provider_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;
	
	if (! initialized)
	{
		/* no signals for now, nothing to do */
		
		initialized = TRUE;
	}
}


GdkPixbuf *
gb_icon_provider_get_icon (GbIconProvider *ip, GbBookmark *b)
{
	return (* GB_ICON_PROVIDER_GET_IFACE (ip)->get_icon) (ip, b);
}


