/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mozilla-embed-shell.h"
#include "mozilla-embed.h"
#include "js-console.h"
#include "JSConsoleService.h"
#include "GaleonWrapper.h"

#include "nsIDOMWindow.h"
#include "nsCOMPtr.h"
#include "nsXPComFactory.h"

NS_IMPL_ISUPPORTS1(JSConsoleService, nsIJSConsoleService)


JSConsoleService::JSConsoleService()  
{
	NS_INIT_ISUPPORTS();
}

JSConsoleService::~JSConsoleService()
{
}

void
js_console_evaluate_cb (JavascriptConsole *dialog, char *command, gpointer data)
{
	GaleonEmbed *embed;
	GaleonWrapper *wrapper;
	
	embed = galeon_embed_dialog_get_embed (GALEON_EMBED_DIALOG(dialog));

	wrapper = (GaleonWrapper *) mozilla_embed_get_galeon_wrapper (MOZILLA_EMBED(embed));
	g_return_if_fail (wrapper != NULL);

	wrapper->EvaluateJS (command);
}

NS_IMETHODIMP
JSConsoleService::Open ( nsIDOMWindow *inParent )               
{
	galeon_dialog_show (GALEON_DIALOG(mozilla_js_console));
	
	g_signal_connect (G_OBJECT(mozilla_js_console),
			  "evaluate",
			  G_CALLBACK(js_console_evaluate_cb),
			  NULL);
	
	return NS_OK;
}

NS_DEF_FACTORY (JSConsoleService, JSConsoleService);

/**
 * NS_NewPromptServiceFactory:
 */ 
nsresult NS_NewJSConsoleServiceFactory(nsIFactory** aFactory)
{
        NS_ENSURE_ARG_POINTER(aFactory);
        *aFactory = nsnull;

        nsJSConsoleServiceFactory *result = new nsJSConsoleServiceFactory;
        if (result == NULL)
        {
                return NS_ERROR_OUT_OF_MEMORY;
        }
    
        NS_ADDREF(result);
        *aFactory = result;
  
        return NS_OK;
}
