/* gok-word-complete.h
*
* Copyright 2001,2002 Sun Microsystems, Inc.,
* Copyright 2001,2002 University Of Toronto
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*/

#ifndef __GOKWORDCOMPLETE_H__
#define __GOKWORDCOMPLETE_H__

#include "gok-keyboard.h"
#include "word-complete.h"
#include "gok-output.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

gboolean gok_wordcomplete_open (gchar *directory);
void gok_wordcomplete_close (void);
void gok_wordcomplete_on (gboolean bTrueFalse);
void gok_wordcomplete_change_number_predictions (int number);
int gok_wordcomplete_predict (const char letter);
gboolean gok_wordcomplete_add_new_word (const char* pWord);
gboolean gok_wordcomplete_add_prediction_keys (GokKeyboard* pKeyboard);
GokOutput* gok_wordcomplete_get_output (GokKey* pKey);
void gok_wordcomplete_clear_keys (void);
void gok_wordcomplete_end_word (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // #ifndef __GOKWORDCOMPLETE_H__
