/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* Stock icons for GPdf
 *
 * Copyright (C) 2003 Martin Kretzschmar
 *
 * Author:
 *   Martin Kretzschmar <Martin.Kretzschmar@inf.tu-dresden.de>
 *
 * GPdf is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GPdf is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtkiconfactory.h>
#include <gdk/gdkpixbuf.h>
#include "gpdf-stock-icons.h"

void
gpdf_stock_icons_init (void)
{
        GtkIconFactory *factory;
        GdkPixbuf *pixbuf;
        GtkIconSet *icon_set;

        factory = gtk_icon_factory_new ();
        gtk_icon_factory_add_default (factory);

        pixbuf = gdk_pixbuf_new_from_file (GNOMEICONDIR "/gpdf/fitwidth.png",
                                           NULL);

        icon_set = gtk_icon_set_new_from_pixbuf (pixbuf);
        gtk_icon_factory_add (factory, GPDF_STOCK_ZOOM_FIT_WIDTH, icon_set);
        gtk_icon_set_unref (icon_set);

        g_object_unref (G_OBJECT (factory));
}
