/* word-complete.h
*
* Copyright 2001,2002 Sun Microsystems, Inc.,
* Copyright 2001,2002 University Of Toronto
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* To use this thing:
* - Call "WordCompleteOpen". If it returns TRUE then you're ready to go.
* - Call "WordCompletePredict" to make the word predictions.
* - Call "WordCompleteClose" when you're done. 
* - To add a word, call "WordCompleteAddNewWord".
*
*/

#ifndef __WORDCOMPLETE_H__
#define __WORDCOMPLETE_H__

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

/* maximum length of a word in the dictionary */
#define MAXWORDLENGTH 30

/* maximum number of words predicted */
#define MAXPREDICTIONS 10

/* state of words in the dictionary */
#define STATE_TEMPORARY 1
#define STATE_PERMANENT 2

/* priority of new word added to the dictionary */
#define PRIORITY_NEWWORD 100

#ifndef FALSE
#define FALSE   (0)
#endif

#ifndef TRUE
#define TRUE    (!FALSE)
#endif

/* a node in the trie */
struct NodeStruct
{
	gchar letter;
	gint priority; /* if this is not 0 then this is the end of a word */
	gint state;
	struct NodeStruct* pNextNode;
	struct NodeStruct* pFirstChildNode;
};
typedef struct NodeStruct Node;

/* a prediction */
struct PredictNode
{
	gchar word[MAXWORDLENGTH];
	gint priority;
};
typedef struct PredictNode Prediction;

/* public functions */
gchar WordCompleteOpen (const gchar *directory);
void WordCompleteClose (void);
gint WordCompletePredict (const gchar* pWord, gint numberPredictions, gchar** Predictions);
gchar WordCompleteAddNewWord (gchar* pWord);

/* private functions */
gchar WordCompleteSaveDictionary (void);
gint WordCompleteSaveLoop (Node* pDictLetter, gchar* pWord, FILE* pFile);
void WordCompletePredictLoop (const gchar* pWord, Node* pNode, gchar* pPrediction);
void WordCompleteDeleteChildren (Node* pNode);
gchar WordCompleteAddWord (gchar* pWord, gint priority, gint state);
Node* WordCompleteAddLetter (Node* pNode, gchar letter);
void WordCompleteAddPrediction (gchar* pWord, gint priority);

#endif // #ifndef __WORDCOMPLETE_H__
