


#include <e-data-book.h>
#include "e-data-book-enumtypes.h"

/* enumerations from "e-data-book-types.h" */
GType
e_data_book_status_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { E_DATA_BOOK_STATUS_SUCCESS, "E_DATA_BOOK_STATUS_SUCCESS", "E_DATA_BOOK_STATUS_SUCCESS" },
      { E_DATA_BOOK_STATUS_REPOSITORY_OFFLINE, "E_DATA_BOOK_STATUS_REPOSITORY_OFFLINE", "E_DATA_BOOK_STATUS_REPOSITORY_OFFLINE" },
      { E_DATA_BOOK_STATUS_PERMISSION_DENIED, "E_DATA_BOOK_STATUS_PERMISSION_DENIED", "E_DATA_BOOK_STATUS_PERMISSION_DENIED" },
      { E_DATA_BOOK_STATUS_CONTACT_NOT_FOUND, "E_DATA_BOOK_STATUS_CONTACT_NOT_FOUND", "E_DATA_BOOK_STATUS_CONTACT_NOT_FOUND" },
      { E_DATA_BOOK_STATUS_CONTACTID_ALREADY_EXISTS, "E_DATA_BOOK_STATUS_CONTACTID_ALREADY_EXISTS", "E_DATA_BOOK_STATUS_CONTACTID_ALREADY_EXISTS" },
      { E_DATA_BOOK_STATUS_AUTHENTICATION_FAILED, "E_DATA_BOOK_STATUS_AUTHENTICATION_FAILED", "E_DATA_BOOK_STATUS_AUTHENTICATION_FAILED" },
      { E_DATA_BOOK_STATUS_AUTHENTICATION_REQUIRED, "E_DATA_BOOK_STATUS_AUTHENTICATION_REQUIRED", "E_DATA_BOOK_STATUS_AUTHENTICATION_REQUIRED" },
      { E_DATA_BOOK_STATUS_UNSUPPORTED_FIELD, "E_DATA_BOOK_STATUS_UNSUPPORTED_FIELD", "E_DATA_BOOK_STATUS_UNSUPPORTED_FIELD" },
      { E_DATA_BOOK_STATUS_UNSUPPORTED_AUTHENTICATION_METHOD, "E_DATA_BOOK_STATUS_UNSUPPORTED_AUTHENTICATION_METHOD", "E_DATA_BOOK_STATUS_UNSUPPORTED_AUTHENTICATION_METHOD" },
      { E_DATA_BOOK_STATUS_TLS_NOT_AVAILABLE, "E_DATA_BOOK_STATUS_TLS_NOT_AVAILABLE", "E_DATA_BOOK_STATUS_TLS_NOT_AVAILABLE" },
      { E_DATA_BOOK_STATUS_NO_SUCH_BOOK, "E_DATA_BOOK_STATUS_NO_SUCH_BOOK", "E_DATA_BOOK_STATUS_NO_SUCH_BOOK" },
      { E_DATA_BOOK_STATUS_BOOK_REMOVED, "E_DATA_BOOK_STATUS_BOOK_REMOVED", "E_DATA_BOOK_STATUS_BOOK_REMOVED" },
      { E_DATA_BOOK_STATUS_OFFLINE_UNAVAILABLE, "E_DATA_BOOK_STATUS_OFFLINE_UNAVAILABLE", "E_DATA_BOOK_STATUS_OFFLINE_UNAVAILABLE" },
      { E_DATA_BOOK_STATUS_SEARCH_SIZE_LIMIT_EXCEEDED, "E_DATA_BOOK_STATUS_SEARCH_SIZE_LIMIT_EXCEEDED", "E_DATA_BOOK_STATUS_SEARCH_SIZE_LIMIT_EXCEEDED" },
      { E_DATA_BOOK_STATUS_SEARCH_TIME_LIMIT_EXCEEDED, "E_DATA_BOOK_STATUS_SEARCH_TIME_LIMIT_EXCEEDED", "E_DATA_BOOK_STATUS_SEARCH_TIME_LIMIT_EXCEEDED" },
      { E_DATA_BOOK_STATUS_INVALID_QUERY, "E_DATA_BOOK_STATUS_INVALID_QUERY", "E_DATA_BOOK_STATUS_INVALID_QUERY" },
      { E_DATA_BOOK_STATUS_QUERY_REFUSED, "E_DATA_BOOK_STATUS_QUERY_REFUSED", "E_DATA_BOOK_STATUS_QUERY_REFUSED" },
      { E_DATA_BOOK_STATUS_COULD_NOT_CANCEL, "E_DATA_BOOK_STATUS_COULD_NOT_CANCEL", "E_DATA_BOOK_STATUS_COULD_NOT_CANCEL" },
      { E_DATA_BOOK_STATUS_OTHER_ERROR, "E_DATA_BOOK_STATUS_OTHER_ERROR", "E_DATA_BOOK_STATUS_OTHER_ERROR" },
      { E_DATA_BOOK_STATUS_INVALID_SERVER_VERSION, "E_DATA_BOOK_STATUS_INVALID_SERVER_VERSION", "E_DATA_BOOK_STATUS_INVALID_SERVER_VERSION" },
      { E_DATA_BOOK_STATUS_NO_SPACE, "E_DATA_BOOK_STATUS_NO_SPACE", "E_DATA_BOOK_STATUS_NO_SPACE" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("EDataBookStatus", values);
  }
  return etype;
}
GType
e_data_book_mode_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { E_DATA_BOOK_MODE_LOCAL, "E_DATA_BOOK_MODE_LOCAL", "E_DATA_BOOK_MODE_LOCAL" },
      { E_DATA_BOOK_MODE_REMOTE, "E_DATA_BOOK_MODE_REMOTE", "E_DATA_BOOK_MODE_REMOTE" },
      { E_DATA_BOOK_MODE_ANY, "E_DATA_BOOK_MODE_ANY", "E_DATA_BOOK_MODE_ANY" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("EDataBookMode", values);
  }
  return etype;
}
GType
e_data_book_change_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { E_DATA_BOOK_BACKEND_CHANGE_ADDED, "E_DATA_BOOK_BACKEND_CHANGE_ADDED", "E_DATA_BOOK_BACKEND_CHANGE_ADDED" },
      { E_DATA_BOOK_BACKEND_CHANGE_DELETED, "E_DATA_BOOK_BACKEND_CHANGE_DELETED", "E_DATA_BOOK_BACKEND_CHANGE_DELETED" },
      { E_DATA_BOOK_BACKEND_CHANGE_MODIFIED, "E_DATA_BOOK_BACKEND_CHANGE_MODIFIED", "E_DATA_BOOK_BACKEND_CHANGE_MODIFIED" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("EDataBookChangeType", values);
  }
  return etype;
}



