/* rygel-media-export-media-cache.c generated by valac, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <rygel.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_DB_OBJECT_TYPE (rygel_media_db_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY (rygel_media_export_db_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY, RygelMediaExportDBObjectFactory))
#define RYGEL_MEDIA_EXPORT_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY, RygelMediaExportDBObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_DB_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY, RygelMediaExportDBObjectFactoryClass))

typedef struct _RygelMediaExportDBObjectFactory RygelMediaExportDBObjectFactory;
typedef struct _RygelMediaExportDBObjectFactoryClass RygelMediaExportDBObjectFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
typedef struct _Block5Data Block5Data;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
typedef struct _Block6Data Block6Data;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;

typedef enum  {
	RYGEL_MEDIA_DB_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_DB_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_DB_ERROR_UNSUPPORTED
} RygelMediaDBError;
#define RYGEL_MEDIA_DB_ERROR rygel_media_db_error_quark ()
typedef enum  {
	RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM
} RygelMediaDBObjectType;

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportDBObjectFactory* factory;
};

typedef gboolean (*RygelMediaExportDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);
typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _Block1Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	RygelMediaObject* parent;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gint count;
};

struct _Block3Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gboolean exists;
	gint64 tmp_timestamp;
};

struct _Block4Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* children;
	RygelMediaContainer* parent;
};

struct _Block5Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	glong count;
};

struct _Block6Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* children;
	RygelMediaContainer* parent;
};

struct _Block7Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gint rows;
};

struct _Block8Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* children;
};

struct _Block9Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* data;
};


static gpointer rygel_media_export_media_cache_parent_class = NULL;

GQuark rygel_media_db_error_quark (void);
GType rygel_media_db_object_type_get_type (void);
GType rygel_media_export_media_cache_get_type (void);
GType rygel_media_export_database_get_type (void);
GType rygel_media_export_db_object_factory_get_type (void);
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_schema_version "6"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_META_DATA_TABLE_STRING "CREATE TABLE meta_data (size INTEGER NOT NULL, " "mime_type TEXT NOT NULL, " "duration INTEGER, " "width INTEGER, " "height INTEGER, " "class TEXT NOT NULL, " "author TEXT, " "album TEXT, " "date TEXT, " "bitrate INTEGER, " "sample_freq INTEGER, " "bits_per_sample INTEGER, " "channels INTEGER, " "track INTEGER, " "color_depth INTEGER, " "object_fk TEXT UNIQUE CONSTRAINT " "object_fk_id REFERENCES Object(upnp_id) " "ON DELETE CASCADE);"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_SCHEMA_STRING "CREATE TABLE schema_info (version TEXT NOT NULL); " RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_META_DATA_TABLE_STRING "CREATE TABLE object (parent TEXT CONSTRAINT parent_fk_id " "REFERENCES Object(upnp_id), " "upnp_id TEXT PRIMARY KEY, " "type_fk INTEGER, " "title TEXT NOT NULL, " "timestamp INTEGER NOT NULL, " "uri TEXT);" "INSERT INTO schema_info (version) VALUES ('" RYGEL_MEDIA_EXPORT_MEDIA_CACHE_schema_version "'); "
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TABLE "CREATE TABLE closure (ancestor TEXT, descendant TEXT, depth INTEGER)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TRIGGER_STRING "CREATE TRIGGER trgr_update_closure " "AFTER INSERT ON Object " "FOR EACH ROW BEGIN " "INSERT INTO Closure (ancestor, descendant, depth) " "VALUES (NEW.upnp_id, NEW.upnp_id, 0); " "INSERT INTO Closure (ancestor, descendant, depth) " "SELECT ancestor, NEW.upnp_id, depth + 1 FROM Closure " "WHERE descendant = NEW.parent;" "END;" "CREATE TRIGGER trgr_delete_closure " "AFTER DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM Closure WHERE descendant = OLD.upnp_id;" "END;"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_TRIGGER_STRING "CREATE TRIGGER trgr_delete_metadata " "BEFORE DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM meta_data WHERE meta_data.object_fk = OLD.upnp_id; " "END;"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_INDICES_STRING "CREATE INDEX idx_parent on Object(parent);" "CREATE INDEX idx_meta_data_fk on meta_data(object_fk);" "CREATE INDEX idx_closure on Closure(descendant,depth);"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_SAVE_META_DATA_STRING "INSERT OR REPLACE INTO meta_data " "(size, mime_type, width, height, class, " "author, album, date, bitrate, " "sample_freq, bits_per_sample, channels, " "track, color_depth, duration, object_fk) VALUES " "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_INSERT_OBJECT_STRING "INSERT OR REPLACE INTO Object (upnp_id, title, type_fk, parent, timest" \
"amp, uri) " "VALUES (?,?,?,?,?,?)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DELETE_BY_ID_STRING "DELETE FROM Object WHERE upnp_id IN " "(SELECT descendant FROM closure WHERE ancestor = ?)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECT_WITH_PATH "SELECT DISTINCT o.type_fk, o.title, m.size, m.mime_type, m.width, m.he" \
"ight, " "m.class, m.author, m.album, m.date, m.bitrate, m.sample_freq, " "m.bits_per_sample, m.channels, m.track, m.color_depth, " "m.duration, o.parent, o.upnp_id, o.uri " "FROM Object o " "JOIN Closure c ON (o.upnp_id = c.ancestor) " "LEFT OUTER JOIN meta_data m ON (o.upnp_id = m.object_fk) " "WHERE c.descendant = ? ORDER BY c.depth DESC"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CHILDREN_STRING "SELECT o.type_fk, o.title, m.size, m.mime_type, " "m.width, m.height, m.class, m.author, m.album, " "m.date, m.bitrate, m.sample_freq, m.bits_per_sample, " "m.channels, m.track, m.color_depth, m.duration, " "o.upnp_id, o.parent, o.timestamp, o.uri " "FROM Object o LEFT OUTER JOIN meta_data m " "ON o.upnp_id = m.object_fk " "WHERE o.parent = ? " "ORDER BY o.type_fk ASC, " "m.class ASC, " "m.track ASC, " "o.title ASC " "LIMIT ?,?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECTS_BY_FILTER_STRING "SELECT DISTINCT o.type_fk, o.title, m.size, m.mime_type, " "m.width, m.height, m.class, m.author, m.album, " "m.date, m.bitrate, m.sample_freq, m.bits_per_sample, " "m.channels, m.track, m.color_depth, m.duration, " "o.upnp_id, o.parent, o.timestamp, o.uri " "FROM Object o " "JOIN Closure c ON o.upnp_id = c.descendant AND c.ancestor = ? " "LEFT OUTER JOIN meta_data m " "ON o.upnp_id = m.object_fk " "WHERE %s " "ORDER BY o.parent ASC, " "o.type_fk ASC, " "m.class ASC, " "m.track ASC, " "o.title ASC " "LIMIT ?,?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECT_COUNT_BY_FILTER_STRING "SELECT COUNT(o.type_fk) FROM Object o " "JOIN Closure c ON o.upnp_id = c.descendant AND c.ancestor = ? " "JOIN meta_data m " "ON o.upnp_id = m.object_fk " "WHERE %s "
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CHILDREN_COUNT_STRING "SELECT COUNT(upnp_id) FROM Object WHERE Object.parent = ?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_OBJECT_EXISTS_STRING "SELECT COUNT(upnp_id), timestamp FROM Object WHERE Object.upnp_id = ?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CHILD_ID_STRING "SELECT upnp_id FROM OBJECT WHERE parent = ?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_META_DATA_COLUMN_STRING "SELECT DISTINCT %s FROM meta_data AS m %s " "ORDER BY %s LIMIT ?,?"
GQuark rygel_media_export_database_error_quark (void);
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement);
static gboolean _lambda0_ (sqlite3_stmt* statement, Block1Data* _data1_);
static gboolean __lambda0__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const char* object_id, GError** error);
RygelMediaItem* rygel_media_export_media_cache_get_item (RygelMediaExportMediaCache* self, const char* item_id, GError** error);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
static gboolean _lambda1_ (sqlite3_stmt* statement, Block2Data* _data2_);
static gboolean __lambda1__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
static gboolean _lambda2_ (sqlite3_stmt* statement, Block3Data* _data3_);
static gboolean __lambda2__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, const char* object_id, gint64* timestamp, GError** error);
static gboolean _lambda3_ (sqlite3_stmt* statement, Block4Data* _data4_);
static gboolean __lambda3__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
GeeArrayList* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, const char* container_id, glong offset, glong max_count, GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
static char* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error);
GeeArrayList* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error);
GeeList* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, guint* total_matches, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, GError** error);
static gboolean _lambda4_ (sqlite3_stmt* statement, Block5Data* _data5_);
static gboolean __lambda4__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void);
static gboolean _lambda5_ (sqlite3_stmt* statement, Block6Data* _data6_);
static gboolean __lambda5__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const char* name, GError** error);
RygelMediaExportDBObjectFactory* rygel_media_export_db_object_factory_new (void);
RygelMediaExportDBObjectFactory* rygel_media_export_db_object_factory_construct (GType object_type);
RygelMediaExportMediaCache* rygel_media_export_media_cache_new (const char* name, GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, const char* name, GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_new_with_factory (const char* name, RygelMediaExportDBObjectFactory* factory, GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_construct_with_factory (GType object_type, const char* name, RygelMediaExportDBObjectFactory* factory, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_new (const char* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const char* name, GError** error);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database);
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void);
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
static gboolean _lambda9_ (sqlite3_stmt* statement, Block7Data* _data7_);
static gboolean __lambda9__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
void rygel_media_export_database_null (GValue* result);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
RygelMediaContainer* rygel_media_export_db_object_factory_get_container (RygelMediaExportDBObjectFactory* self, RygelMediaExportMediaCache* media_db, const char* id, const char* title, guint child_count);
RygelMediaItem* rygel_media_export_db_object_factory_get_item (RygelMediaExportDBObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item);
static gboolean _lambda10_ (sqlite3_stmt* statement, Block8Data* _data8_);
static gboolean __lambda10__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
static char* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error);
static char* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error);
static char* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const char* operand, GError** error);
static gboolean _lambda11_ (sqlite3_stmt* statement, Block9Data* _data9_);
static gboolean __lambda11__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const char* column, const char* filter, GValueArray* args, glong offset, glong max_count, GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const char* attribute, RygelSearchExpression* expression, glong offset, glong max_count, GError** error);
static void rygel_media_export_media_cache_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_media_db_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_db_error-quark");
}


GType rygel_media_db_object_type_get_type (void) {
	static volatile gsize rygel_media_db_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_db_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_db_object_type_type_id;
		rygel_media_db_object_type_type_id = g_enum_register_static ("RygelMediaDBObjectType", values);
		g_once_init_leave (&rygel_media_db_object_type_type_id__volatile, rygel_media_db_object_type_type_id);
	}
	return rygel_media_db_object_type_type_id__volatile;
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


#line 207 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error) {
#line 357 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 207 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 207 "rygel-media-export-media-cache.vala"
	g_return_if_fail (id != NULL);
#line 369 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 209 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DELETE_BY_ID_STRING, values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 374 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 212 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
#line 393 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
#line 212 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 212 "rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 399 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 214 "rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_remove_by_id (self, object->id, &_inner_error_);
#line 403 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


#line 217 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
#line 424 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
#line 217 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 217 "rygel-media-export-media-cache.vala"
	g_return_if_fail (container != NULL);
#line 430 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	{
#line 219 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 435 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch2_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 220 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) container, &_inner_error_);
#line 446 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch2_rygel_media_export_database_error;
			}
			goto __finally2;
		}
#line 221 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 455 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch2_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 223 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 474 "rygel-media-export-media-cache.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				goto __finally2;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 229 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
#line 493 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
#line 229 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 229 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 499 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	{
#line 231 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 504 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch3_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 232 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_metadata (self, item, &_inner_error_);
#line 515 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch3_rygel_media_export_database_error;
			}
			goto __finally3;
		}
#line 233 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) item, &_inner_error_);
#line 524 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch3_rygel_media_export_database_error;
			}
			goto __finally3;
		}
#line 234 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 533 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch3_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 236 "rygel-media-export-media-cache.vala"
			g_warning (_ ("Failed to add item with ID %s: %s"), ((RygelMediaObject*) item)->id, _error_->message);
#line 239 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 554 "rygel-media-export-media-cache.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				goto __finally3;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 249 "rygel-media-export-media-cache.vala"
static gboolean _lambda0_ (sqlite3_stmt* statement, Block1Data* _data1_) {
#line 578 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	RygelMediaObject* _tmp0_;
	RygelMediaContainer* parent_container;
	RygelMediaObject* object;
	RygelMediaObject* _tmp1_;
	self = _data1_->self;
#line 249 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 250 "rygel-media-export-media-cache.vala"
	parent_container = _g_object_ref0 ((_tmp0_ = _data1_->parent, RYGEL_IS_MEDIA_CONTAINER (_tmp0_) ? ((RygelMediaContainer*) _tmp0_) : NULL));
#line 251 "rygel-media-export-media-cache.vala"
	object = rygel_media_export_media_cache_get_object_from_statement (self, parent_container, sqlite3_column_text (statement, 18), statement);
#line 254 "rygel-media-export-media-cache.vala"
	rygel_media_object_set_parent_ref (object, parent_container);
#line 255 "rygel-media-export-media-cache.vala"
	_data1_->parent = (_tmp1_ = _g_object_ref0 (object), _g_object_unref0 (_data1_->parent), _tmp1_);
#line 596 "rygel-media-export-media-cache.c"
	result = TRUE;
	_g_object_unref0 (parent_container);
	_g_object_unref0 (object);
#line 257 "rygel-media-export-media-cache.vala"
	return result;
#line 602 "rygel-media-export-media-cache.c"
}


#line 249 "rygel-media-export-media-cache.vala"
static gboolean __lambda0__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 608 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda0_ (stmt, self);
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	++_data1_->_ref_count_;
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if ((--_data1_->_ref_count_) == 0) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->parent);
		g_slice_free (Block1Data, _data1_);
	}
}


#line 245 "rygel-media-export-media-cache.vala"
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const char* object_id, GError** error) {
#line 632 "rygel-media-export-media-cache.c"
	RygelMediaObject* result = NULL;
	GError * _inner_error_;
	Block1Data* _data1_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	RygelMediaExportDatabaseRowCallback _tmp3_;
	GDestroyNotify cb_target_destroy_notify = NULL;
	void* cb_target = NULL;
	RygelMediaExportDatabaseRowCallback cb;
#line 245 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 245 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 650 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
	_data1_->parent = NULL;
	cb = (_tmp3_ = __lambda0__rygel_media_export_database_row_callback, cb_target = block1_data_ref (_data1_), cb_target_destroy_notify = block1_data_unref, _tmp3_);
#line 260 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECT_WITH_PATH, values, values_length1, cb, cb_target, NULL, &_inner_error_);
#line 660 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			block1_data_unref (_data1_);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			block1_data_unref (_data1_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data1_->parent);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	block1_data_unref (_data1_);
#line 262 "rygel-media-export-media-cache.vala"
	return result;
#line 692 "rygel-media-export-media-cache.c"
}


#line 265 "rygel-media-export-media-cache.vala"
RygelMediaItem* rygel_media_export_media_cache_get_item (RygelMediaExportMediaCache* self, const char* item_id, GError** error) {
#line 698 "rygel-media-export-media-cache.c"
	RygelMediaItem* result = NULL;
	GError * _inner_error_;
	RygelMediaObject* object;
	gboolean _tmp0_ = FALSE;
	RygelMediaObject* _tmp1_;
#line 265 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 265 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 708 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 267 "rygel-media-export-media-cache.vala"
	object = rygel_media_export_media_cache_get_object (self, item_id, &_inner_error_);
#line 712 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 268 "rygel-media-export-media-cache.vala"
	if (object != NULL) {
#line 268 "rygel-media-export-media-cache.vala"
		_tmp0_ = !RYGEL_IS_MEDIA_ITEM (object);
#line 727 "rygel-media-export-media-cache.c"
	} else {
#line 268 "rygel-media-export-media-cache.vala"
		_tmp0_ = FALSE;
#line 731 "rygel-media-export-media-cache.c"
	}
#line 268 "rygel-media-export-media-cache.vala"
	if (_tmp0_) {
#line 735 "rygel-media-export-media-cache.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, _ ("Object %s is not an item"), item_id);
		{
			if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (object);
				return NULL;
			} else {
				_g_object_unref0 (object);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 ((_tmp1_ = object, RYGEL_IS_MEDIA_ITEM (_tmp1_) ? ((RygelMediaItem*) _tmp1_) : NULL));
	_g_object_unref0 (object);
#line 273 "rygel-media-export-media-cache.vala"
	return result;
#line 754 "rygel-media-export-media-cache.c"
	_g_object_unref0 (object);
}


#line 276 "rygel-media-export-media-cache.vala"
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const char* container_id, GError** error) {
#line 761 "rygel-media-export-media-cache.c"
	RygelMediaContainer* result = NULL;
	GError * _inner_error_;
	RygelMediaObject* object;
	gboolean _tmp0_ = FALSE;
	RygelMediaObject* _tmp1_;
#line 276 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 276 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 771 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 278 "rygel-media-export-media-cache.vala"
	object = rygel_media_export_media_cache_get_object (self, container_id, &_inner_error_);
#line 775 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 279 "rygel-media-export-media-cache.vala"
	if (object != NULL) {
#line 279 "rygel-media-export-media-cache.vala"
		_tmp0_ = !RYGEL_IS_MEDIA_CONTAINER (object);
#line 790 "rygel-media-export-media-cache.c"
	} else {
#line 279 "rygel-media-export-media-cache.vala"
		_tmp0_ = FALSE;
#line 794 "rygel-media-export-media-cache.c"
	}
#line 279 "rygel-media-export-media-cache.vala"
	if (_tmp0_) {
#line 798 "rygel-media-export-media-cache.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Object with id %s is not a" "MediaContainer", container_id);
		{
			if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (object);
				return NULL;
			} else {
				_g_object_unref0 (object);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 ((_tmp1_ = object, RYGEL_IS_MEDIA_CONTAINER (_tmp1_) ? ((RygelMediaContainer*) _tmp1_) : NULL));
	_g_object_unref0 (object);
#line 285 "rygel-media-export-media-cache.vala"
	return result;
#line 817 "rygel-media-export-media-cache.c"
	_g_object_unref0 (object);
}


#line 294 "rygel-media-export-media-cache.vala"
static gboolean _lambda1_ (sqlite3_stmt* statement, Block2Data* _data2_) {
#line 824 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data2_->self;
#line 294 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 295 "rygel-media-export-media-cache.vala"
	_data2_->count = sqlite3_column_int (statement, 0);
#line 832 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 297 "rygel-media-export-media-cache.vala"
	return result;
#line 836 "rygel-media-export-media-cache.c"
}


#line 294 "rygel-media-export-media-cache.vala"
static gboolean __lambda1__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 842 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda1_ (stmt, self);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	++_data2_->_ref_count_;
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if ((--_data2_->_ref_count_) == 0) {
		_g_object_unref0 (_data2_->self);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 288 "rygel-media-export-media-cache.vala"
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const char* container_id, GError** error) {
#line 865 "rygel-media-export-media-cache.c"
	gint result = 0;
	GError * _inner_error_;
	Block2Data* _data2_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 288 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 288 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0);
#line 879 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->count = 0;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 292 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CHILDREN_COUNT_STRING, values, values_length1, __lambda1__rygel_media_export_database_row_callback, _data2_, NULL, &_inner_error_);
#line 888 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block2_data_unref (_data2_);
			return 0;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block2_data_unref (_data2_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _data2_->count;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block2_data_unref (_data2_);
#line 300 "rygel-media-export-media-cache.vala"
	return result;
#line 908 "rygel-media-export-media-cache.c"
}


#line 311 "rygel-media-export-media-cache.vala"
static gboolean _lambda2_ (sqlite3_stmt* statement, Block3Data* _data3_) {
#line 914 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data3_->self;
#line 311 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 312 "rygel-media-export-media-cache.vala"
	_data3_->exists = sqlite3_column_int (statement, 0) == 1;
#line 313 "rygel-media-export-media-cache.vala"
	_data3_->tmp_timestamp = sqlite3_column_int64 (statement, 1);
#line 924 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 315 "rygel-media-export-media-cache.vala"
	return result;
#line 928 "rygel-media-export-media-cache.c"
}


#line 311 "rygel-media-export-media-cache.vala"
static gboolean __lambda2__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 934 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda2_ (stmt, self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	++_data3_->_ref_count_;
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if ((--_data3_->_ref_count_) == 0) {
		_g_object_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


#line 303 "rygel-media-export-media-cache.vala"
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, const char* object_id, gint64* timestamp, GError** error) {
#line 957 "rygel-media-export-media-cache.c"
	gboolean result = FALSE;
	GError * _inner_error_;
	Block3Data* _data3_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 303 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 303 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, FALSE);
#line 971 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->exists = FALSE;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
	_data3_->tmp_timestamp = (gint64) 0;
#line 309 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_OBJECT_EXISTS_STRING, values, values_length1, __lambda2__rygel_media_export_database_row_callback, _data3_, NULL, &_inner_error_);
#line 981 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block3_data_unref (_data3_);
			return FALSE;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block3_data_unref (_data3_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
#line 319 "rygel-media-export-media-cache.vala"
	*timestamp = _data3_->tmp_timestamp;
#line 998 "rygel-media-export-media-cache.c"
	result = _data3_->exists;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block3_data_unref (_data3_);
#line 321 "rygel-media-export-media-cache.vala"
	return result;
#line 1004 "rygel-media-export-media-cache.c"
}


#line 334 "rygel-media-export-media-cache.vala"
static gboolean _lambda3_ (sqlite3_stmt* statement, Block4Data* _data4_) {
#line 1010 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	char* child_id;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	self = _data4_->self;
#line 334 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 335 "rygel-media-export-media-cache.vala"
	child_id = g_strdup (sqlite3_column_text (statement, 17));
#line 336 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data4_->children, _tmp0_ = rygel_media_export_media_cache_get_object_from_statement (self, _data4_->parent, child_id, statement));
#line 1023 "rygel-media-export-media-cache.c"
	_g_object_unref0 (_tmp0_);
#line 339 "rygel-media-export-media-cache.vala"
	rygel_media_object_set_parent_ref (_tmp1_ = (RygelMediaObject*) gee_abstract_list_last ((GeeAbstractList*) _data4_->children), _data4_->parent);
#line 1027 "rygel-media-export-media-cache.c"
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	_g_free0 (child_id);
#line 341 "rygel-media-export-media-cache.vala"
	return result;
#line 1033 "rygel-media-export-media-cache.c"
}


#line 334 "rygel-media-export-media-cache.vala"
static gboolean __lambda3__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1039 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda3_ (stmt, self);
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	++_data4_->_ref_count_;
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if ((--_data4_->_ref_count_) == 0) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->children);
		_g_object_unref0 (_data4_->parent);
		g_slice_free (Block4Data, _data4_);
	}
}


#line 324 "rygel-media-export-media-cache.vala"
GeeArrayList* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, const char* container_id, glong offset, glong max_count, GError** error) {
#line 1064 "rygel-media-export-media-cache.c"
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	Block4Data* _data4_;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	GValue* _tmp6_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp5_ = NULL;
	GValue _tmp4_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp2_ = {0};
	GValue* values;
	RygelMediaExportDatabaseRowCallback _tmp7_;
	GDestroyNotify callback_target_destroy_notify = NULL;
	void* callback_target = NULL;
	RygelMediaExportDatabaseRowCallback callback;
#line 324 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 324 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1086 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->children = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 329 "rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_media_cache_get_object (self, container_id, &_inner_error_);
#line 1094 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block4_data_unref (_data4_);
		return NULL;
	}
	_data4_->parent = (_tmp1_ = _tmp0_, RYGEL_IS_MEDIA_CONTAINER (_tmp1_) ? ((RygelMediaContainer*) _tmp1_) : NULL);
	values = (_tmp6_ = (_tmp5_ = g_new0 (GValue, 3), _tmp5_[0] = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, container_id), _tmp2_), _tmp5_[1] = (g_value_init (&_tmp3_, G_TYPE_INT64), g_value_set_int64 (&_tmp3_, (gint64) offset), _tmp3_), _tmp5_[2] = (g_value_init (&_tmp4_, G_TYPE_INT64), g_value_set_int64 (&_tmp4_, (gint64) max_count), _tmp4_), _tmp5_), values_length1 = 3, _values_size_ = values_length1, _tmp6_);
	callback = (_tmp7_ = __lambda3__rygel_media_export_database_row_callback, callback_target = block4_data_ref (_data4_), callback_target_destroy_notify = block4_data_unref, _tmp7_);
#line 344 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CHILDREN_STRING, values, values_length1, callback, callback_target, NULL, &_inner_error_);
#line 1105 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		block4_data_unref (_data4_);
		return NULL;
	}
	result = _g_object_ref0 (_data4_->children);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block4_data_unref (_data4_);
#line 346 "rygel-media-export-media-cache.vala"
	return result;
#line 1125 "rygel-media-export-media-cache.c"
}


#line 349 "rygel-media-export-media-cache.vala"
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
#line 1131 "rygel-media-export-media-cache.c"
	guint result = 0U;
#line 349 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 350 "rygel-media-export-media-cache.vala"
	if (max_count == 0) {
#line 1137 "rygel-media-export-media-cache.c"
		result = (guint) (-1);
#line 351 "rygel-media-export-media-cache.vala"
		return result;
#line 1141 "rygel-media-export-media-cache.c"
	} else {
		result = max_count;
#line 353 "rygel-media-export-media-cache.vala"
		return result;
#line 1146 "rygel-media-export-media-cache.c"
	}
}


#line 357 "rygel-media-export-media-cache.vala"
GeeList* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, guint* total_matches, GError** error) {
#line 1153 "rygel-media-export-media-cache.c"
	GeeList* result = NULL;
	GError * _inner_error_;
	GValueArray* args;
	char* filter;
	char* _tmp0_;
	guint max_objects;
	glong _tmp2_;
	GeeArrayList* _tmp3_;
#line 357 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 357 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1166 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 364 "rygel-media-export-media-cache.vala"
	args = g_value_array_new ((guint) 0);
#line 365 "rygel-media-export-media-cache.vala"
	filter = rygel_media_export_media_cache_search_expression_to_sql (self, expression, args, &_inner_error_);
#line 1172 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
#line 367 "rygel-media-export-media-cache.vala"
	if (filter == NULL) {
#line 1180 "rygel-media-export-media-cache.c"
		result = (GeeList*) gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		_g_value_array_free0 (args);
		_g_free0 (filter);
#line 368 "rygel-media-export-media-cache.vala"
		return result;
#line 1186 "rygel-media-export-media-cache.c"
	}
#line 371 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:371: Original search: %s", _tmp0_ = rygel_search_expression_to_string (expression));
#line 1190 "rygel-media-export-media-cache.c"
	_g_free0 (_tmp0_);
#line 372 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:372: Parsed search expression: %s", filter);
#line 1194 "rygel-media-export-media-cache.c"
	{
		gint i;
#line 374 "rygel-media-export-media-cache.vala"
		i = 0;
#line 1199 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp1_;
#line 374 "rygel-media-export-media-cache.vala"
			_tmp1_ = TRUE;
#line 374 "rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 374 "rygel-media-export-media-cache.vala"
				if (!_tmp1_) {
#line 374 "rygel-media-export-media-cache.vala"
					i++;
#line 1210 "rygel-media-export-media-cache.c"
				}
#line 374 "rygel-media-export-media-cache.vala"
				_tmp1_ = FALSE;
#line 374 "rygel-media-export-media-cache.vala"
				if (!(i < args->n_values)) {
#line 374 "rygel-media-export-media-cache.vala"
					break;
#line 1218 "rygel-media-export-media-cache.c"
				}
#line 375 "rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:375: Arg %d: %s", i, g_value_get_string (g_value_array_get_nth (args, (guint) i)));
#line 1222 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 378 "rygel-media-export-media-cache.vala"
	max_objects = rygel_media_export_media_cache_modify_limit (self, max_count);
#line 379 "rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_export_media_cache_get_object_count_by_filter (self, filter, args, container_id, (glong) offset, (glong) max_objects, &_inner_error_);
#line 1230 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		_g_free0 (filter);
		return NULL;
	}
#line 379 "rygel-media-export-media-cache.vala"
	*total_matches = (guint) _tmp2_;
#line 385 "rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_get_objects_by_filter (self, filter, args, container_id, (glong) offset, (glong) max_objects, &_inner_error_);
#line 1241 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		_g_free0 (filter);
		return NULL;
	}
	result = (GeeList*) _tmp3_;
	_g_value_array_free0 (args);
	_g_free0 (filter);
#line 385 "rygel-media-export-media-cache.vala"
	return result;
#line 1253 "rygel-media-export-media-cache.c"
}


#line 392 "rygel-media-export-media-cache.vala"
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, GError** error) {
#line 1259 "rygel-media-export-media-cache.c"
	glong result = 0L;
	GError * _inner_error_;
	GValueArray* args;
	char* filter;
	char* _tmp0_;
	guint max_objects;
	glong _tmp2_;
#line 392 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 392 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0L);
#line 1271 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 398 "rygel-media-export-media-cache.vala"
	args = g_value_array_new ((guint) 0);
#line 399 "rygel-media-export-media-cache.vala"
	filter = rygel_media_export_media_cache_search_expression_to_sql (self, expression, args, &_inner_error_);
#line 1277 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return 0L;
	}
#line 401 "rygel-media-export-media-cache.vala"
	if (filter == NULL) {
#line 1285 "rygel-media-export-media-cache.c"
		result = (glong) 0;
		_g_value_array_free0 (args);
		_g_free0 (filter);
#line 402 "rygel-media-export-media-cache.vala"
		return result;
#line 1291 "rygel-media-export-media-cache.c"
	}
#line 405 "rygel-media-export-media-cache.vala"
	g_debug (_ ("Original search: %s"), _tmp0_ = rygel_search_expression_to_string (expression));
#line 1295 "rygel-media-export-media-cache.c"
	_g_free0 (_tmp0_);
#line 406 "rygel-media-export-media-cache.vala"
	g_debug (_ ("Parsed search expression: %s"), filter);
#line 1299 "rygel-media-export-media-cache.c"
	{
		gint i;
#line 408 "rygel-media-export-media-cache.vala"
		i = 0;
#line 1304 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp1_;
#line 408 "rygel-media-export-media-cache.vala"
			_tmp1_ = TRUE;
#line 408 "rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 408 "rygel-media-export-media-cache.vala"
				if (!_tmp1_) {
#line 408 "rygel-media-export-media-cache.vala"
					i++;
#line 1315 "rygel-media-export-media-cache.c"
				}
#line 408 "rygel-media-export-media-cache.vala"
				_tmp1_ = FALSE;
#line 408 "rygel-media-export-media-cache.vala"
				if (!(i < args->n_values)) {
#line 408 "rygel-media-export-media-cache.vala"
					break;
#line 1323 "rygel-media-export-media-cache.c"
				}
#line 409 "rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:409: Arg %d: %s", i, g_value_get_string (g_value_array_get_nth (args, (guint) i)));
#line 1327 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 412 "rygel-media-export-media-cache.vala"
	max_objects = rygel_media_export_media_cache_modify_limit (self, max_count);
#line 414 "rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_export_media_cache_get_object_count_by_filter (self, filter, args, container_id, (glong) offset, (glong) max_objects, &_inner_error_);
#line 1335 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		_g_free0 (filter);
		return 0L;
	}
	result = _tmp2_;
	_g_value_array_free0 (args);
	_g_free0 (filter);
#line 414 "rygel-media-export-media-cache.vala"
	return result;
#line 1347 "rygel-media-export-media-cache.c"
}


#line 434 "rygel-media-export-media-cache.vala"
static gboolean _lambda4_ (sqlite3_stmt* statement, Block5Data* _data5_) {
#line 1353 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data5_->self;
#line 434 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 435 "rygel-media-export-media-cache.vala"
	_data5_->count = (glong) sqlite3_column_int (statement, 0);
#line 1361 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 437 "rygel-media-export-media-cache.vala"
	return result;
#line 1365 "rygel-media-export-media-cache.c"
}


#line 434 "rygel-media-export-media-cache.vala"
static gboolean __lambda4__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1371 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda4_ (stmt, self);
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	++_data5_->_ref_count_;
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if ((--_data5_->_ref_count_) == 0) {
		_g_object_unref0 (_data5_->self);
		g_slice_free (Block5Data, _data5_);
	}
}


#line 421 "rygel-media-export-media-cache.vala"
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error) {
#line 1394 "rygel-media-export-media-cache.c"
	glong result = 0L;
	GError * _inner_error_;
	Block5Data* _data5_;
	GValue _tmp0_ = {0};
	GValue v;
	RygelMediaExportDatabaseRowCallback _tmp1_;
	GDestroyNotify callback_target_destroy_notify = NULL;
	void* callback_target = NULL;
	RygelMediaExportDatabaseRowCallback callback;
	char* _tmp2_;
#line 421 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 421 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, 0L);
#line 421 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, 0L);
#line 421 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0L);
#line 1413 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
#line 428 "rygel-media-export-media-cache.vala"
	v = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_);
#line 429 "rygel-media-export-media-cache.vala"
	g_value_array_prepend (args, &v);
#line 1422 "rygel-media-export-media-cache.c"
	_data5_->count = (glong) 0;
#line 432 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:432: Parameters to bind: %u", args->n_values);
#line 1426 "rygel-media-export-media-cache.c"
	callback = (_tmp1_ = __lambda4__rygel_media_export_database_row_callback, callback_target = block5_data_ref (_data5_), callback_target_destroy_notify = block5_data_unref, _tmp1_);
#line 440 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, _tmp2_ = g_strdup_printf (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECT_COUNT_BY_FILTER_STRING, filter), args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
#line 1430 "rygel-media-export-media-cache.c"
	_g_free0 (_tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		block5_data_unref (_data5_);
		return 0L;
	}
	result = _data5_->count;
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block5_data_unref (_data5_);
#line 444 "rygel-media-export-media-cache.vala"
	return result;
#line 1451 "rygel-media-export-media-cache.c"
}


#line 464 "rygel-media-export-media-cache.vala"
static gboolean _lambda5_ (sqlite3_stmt* statement, Block6Data* _data6_) {
#line 1457 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	char* child_id;
	char* parent_id;
	self = _data6_->self;
#line 464 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 1466 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 465 "rygel-media-export-media-cache.vala"
	child_id = g_strdup (sqlite3_column_text (statement, 17));
#line 466 "rygel-media-export-media-cache.vala"
	parent_id = g_strdup (sqlite3_column_text (statement, 18));
#line 1472 "rygel-media-export-media-cache.c"
	{
		gboolean _tmp0_ = FALSE;
#line 468 "rygel-media-export-media-cache.vala"
		if (_data6_->parent == NULL) {
#line 468 "rygel-media-export-media-cache.vala"
			_tmp0_ = TRUE;
#line 1479 "rygel-media-export-media-cache.c"
		} else {
#line 468 "rygel-media-export-media-cache.vala"
			_tmp0_ = _vala_strcmp0 (parent_id, ((RygelMediaObject*) _data6_->parent)->id) != 0;
#line 1483 "rygel-media-export-media-cache.c"
		}
#line 468 "rygel-media-export-media-cache.vala"
		if (_tmp0_) {
#line 1487 "rygel-media-export-media-cache.c"
			RygelMediaContainer* _tmp1_;
			char* _tmp2_;
#line 469 "rygel-media-export-media-cache.vala"
			_data6_->parent = (_tmp1_ = (RygelMediaContainer*) rygel_null_container_new (), _g_object_unref0 (_data6_->parent), _tmp1_);
#line 470 "rygel-media-export-media-cache.vala"
			((RygelMediaObject*) _data6_->parent)->id = (_tmp2_ = g_strdup (parent_id), _g_free0 (((RygelMediaObject*) _data6_->parent)->id), _tmp2_);
#line 1494 "rygel-media-export-media-cache.c"
		}
#line 473 "rygel-media-export-media-cache.vala"
		if (_data6_->parent != NULL) {
#line 1498 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp3_;
			RygelMediaObject* _tmp4_;
#line 474 "rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->children, _tmp3_ = rygel_media_export_media_cache_get_object_from_statement (self, _data6_->parent, child_id, statement));
#line 1503 "rygel-media-export-media-cache.c"
			_g_object_unref0 (_tmp3_);
#line 477 "rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp4_ = (RygelMediaObject*) gee_abstract_list_last ((GeeAbstractList*) _data6_->children), _data6_->parent);
#line 1507 "rygel-media-export-media-cache.c"
			_g_object_unref0 (_tmp4_);
		} else {
#line 479 "rygel-media-export-media-cache.vala"
			g_warning ("Inconsistent database: item %s " "has no parent %s", child_id, parent_id);
#line 1512 "rygel-media-export-media-cache.c"
		}
		result = TRUE;
		_g_free0 (child_id);
		_g_free0 (parent_id);
#line 485 "rygel-media-export-media-cache.vala"
		return result;
#line 1519 "rygel-media-export-media-cache.c"
	}
	goto __finally4;
	__catch4_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 487 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:487: Failed to get parent item: %s", _error_->message);
#line 1530 "rygel-media-export-media-cache.c"
			result = FALSE;
			_g_error_free0 (_error_);
			_g_free0 (child_id);
			_g_free0 (parent_id);
#line 489 "rygel-media-export-media-cache.vala"
			return result;
#line 1537 "rygel-media-export-media-cache.c"
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (child_id);
		_g_free0 (parent_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (child_id);
	_g_free0 (parent_id);
}


#line 464 "rygel-media-export-media-cache.vala"
static gboolean __lambda5__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1555 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda5_ (stmt, self);
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	++_data6_->_ref_count_;
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if ((--_data6_->_ref_count_) == 0) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->children);
		_g_object_unref0 (_data6_->parent);
		g_slice_free (Block6Data, _data6_);
	}
}


#line 448 "rygel-media-export-media-cache.vala"
GeeArrayList* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error) {
#line 1580 "rygel-media-export-media-cache.c"
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	Block6Data* _data6_;
	GValue _tmp0_ = {0};
	GValue v;
	GValue _tmp2_;
	GValue _tmp1_ = {0};
	RygelMediaExportDatabaseRowCallback _tmp3_;
	GDestroyNotify callback_target_destroy_notify = NULL;
	void* callback_target = NULL;
	RygelMediaExportDatabaseRowCallback callback;
	char* _tmp4_;
#line 448 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 448 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 448 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 448 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1601 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->children = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 456 "rygel-media-export-media-cache.vala"
	v = (g_value_init (&_tmp0_, G_TYPE_LONG), g_value_set_long (&_tmp0_, offset), _tmp0_);
#line 457 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 458 "rygel-media-export-media-cache.vala"
	v = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_LONG), g_value_set_long (&_tmp1_, max_count), _tmp1_), G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp2_);
#line 459 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 1615 "rygel-media-export-media-cache.c"
	_data6_->parent = NULL;
#line 462 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:462: Parameters to bind: %u", args->n_values);
#line 1619 "rygel-media-export-media-cache.c"
	callback = (_tmp3_ = __lambda5__rygel_media_export_database_row_callback, callback_target = block6_data_ref (_data6_), callback_target_destroy_notify = block6_data_unref, _tmp3_);
#line 493 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, _tmp4_ = g_strdup_printf (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECTS_BY_FILTER_STRING, filter), args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
#line 1623 "rygel-media-export-media-cache.c"
	_g_free0 (_tmp4_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		block6_data_unref (_data6_);
		return NULL;
	}
	result = _g_object_ref0 (_data6_->children);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block6_data_unref (_data6_);
#line 497 "rygel-media-export-media-cache.vala"
	return result;
#line 1644 "rygel-media-export-media-cache.c"
}


#line 500 "rygel-media-export-media-cache.vala"
RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, const char* name, GError** error) {
#line 1650 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	RygelMediaExportMediaCache * self;
	RygelMediaExportDBObjectFactory* _tmp0_;
#line 500 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1656 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 500 "rygel-media-export-media-cache.vala"
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
#line 501 "rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_open_db (self, name, &_inner_error_);
#line 1662 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		g_object_unref (self);
		return NULL;
	}
#line 502 "rygel-media-export-media-cache.vala"
	self->priv->factory = (_tmp0_ = rygel_media_export_db_object_factory_new (), _g_object_unref0 (self->priv->factory), _tmp0_);
#line 1670 "rygel-media-export-media-cache.c"
	return self;
}


#line 500 "rygel-media-export-media-cache.vala"
RygelMediaExportMediaCache* rygel_media_export_media_cache_new (const char* name, GError** error) {
#line 500 "rygel-media-export-media-cache.vala"
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, name, error);
#line 1679 "rygel-media-export-media-cache.c"
}


#line 505 "rygel-media-export-media-cache.vala"
RygelMediaExportMediaCache* rygel_media_export_media_cache_construct_with_factory (GType object_type, const char* name, RygelMediaExportDBObjectFactory* factory, GError** error) {
#line 1685 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	RygelMediaExportMediaCache * self;
	RygelMediaExportDBObjectFactory* _tmp0_;
#line 505 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 505 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (factory != NULL, NULL);
#line 1693 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 505 "rygel-media-export-media-cache.vala"
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
#line 508 "rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_open_db (self, name, &_inner_error_);
#line 1699 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		g_object_unref (self);
		return NULL;
	}
#line 509 "rygel-media-export-media-cache.vala"
	self->priv->factory = (_tmp0_ = _g_object_ref0 (factory), _g_object_unref0 (self->priv->factory), _tmp0_);
#line 1707 "rygel-media-export-media-cache.c"
	return self;
}


#line 505 "rygel-media-export-media-cache.vala"
RygelMediaExportMediaCache* rygel_media_export_media_cache_new_with_factory (const char* name, RygelMediaExportDBObjectFactory* factory, GError** error) {
#line 505 "rygel-media-export-media-cache.vala"
	return rygel_media_export_media_cache_construct_with_factory (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, name, factory, error);
#line 1716 "rygel-media-export-media-cache.c"
}


#line 541 "rygel-media-export-media-cache.vala"
static gboolean _lambda9_ (sqlite3_stmt* statement, Block7Data* _data7_) {
#line 1722 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data7_->self;
#line 541 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 542 "rygel-media-export-media-cache.vala"
	_data7_->rows = sqlite3_column_int (statement, 0);
#line 1730 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 544 "rygel-media-export-media-cache.vala"
	return result;
#line 1734 "rygel-media-export-media-cache.c"
}


#line 541 "rygel-media-export-media-cache.vala"
static gboolean __lambda9__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1740 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda9_ (stmt, self);
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	++_data7_->_ref_count_;
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if ((--_data7_->_ref_count_) == 0) {
		_g_object_unref0 (_data7_->self);
		g_slice_free (Block7Data, _data7_);
	}
}


#line 512 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const char* name, GError** error) {
#line 1763 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportDatabase* _tmp1_;
	gint old_version;
	gint current_version;
#line 512 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 512 "rygel-media-export-media-cache.vala"
	g_return_if_fail (name != NULL);
#line 1773 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 513 "rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_database_new (name, &_inner_error_);
#line 1777 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 513 "rygel-media-export-media-cache.vala"
	self->priv->db = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->db), _tmp1_);
#line 514 "rygel-media-export-media-cache.vala"
	old_version = -1;
#line 515 "rygel-media-export-media-cache.vala"
	current_version = atoi (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_schema_version);
#line 1788 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportMediaCacheUpgrader* upgrader;
		gboolean _tmp2_;
#line 518 "rygel-media-export-media-cache.vala"
		upgrader = rygel_media_export_media_cache_upgrader_new (self->priv->db);
#line 519 "rygel-media-export-media-cache.vala"
		_tmp2_ = rygel_media_export_media_cache_upgrader_needs_upgrade (upgrader, &old_version, &_inner_error_);
#line 1796 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch5_rygel_media_export_database_error;
			}
			goto __finally5;
		}
#line 519 "rygel-media-export-media-cache.vala"
		if (_tmp2_) {
#line 520 "rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_upgrader_upgrade (upgrader, old_version);
#line 1808 "rygel-media-export-media-cache.c"
		} else {
#line 521 "rygel-media-export-media-cache.vala"
			if (old_version == current_version) {
#line 522 "rygel-media-export-media-cache.vala"
				rygel_media_export_media_cache_upgrader_fix_schema (upgrader, &_inner_error_);
#line 1814 "rygel-media-export-media-cache.c"
				if (_inner_error_ != NULL) {
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch5_rygel_media_export_database_error;
					}
					goto __finally5;
				}
			} else {
				RygelMediaExportDatabase* _tmp3_;
#line 524 "rygel-media-export-media-cache.vala"
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", old_version, current_version);
#line 528 "rygel-media-export-media-cache.vala"
				self->priv->db = (_tmp3_ = NULL, _g_object_unref0 (self->priv->db), _tmp3_);
#line 1828 "rygel-media-export-media-cache.c"
				_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR, "Database format" " not supported");
				{
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch5_rygel_media_export_database_error;
					}
					goto __finally5;
				}
			}
		}
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
	}
	goto __finally5;
	__catch5_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 534 "rygel-media-export-media-cache.vala"
			g_debug ("rygel-media-export-media-cache.vala:534: %s", "Could not find schema version;" " checking for empty database...");
#line 1850 "rygel-media-export-media-cache.c"
			{
				Block7Data* _data7_;
				_data7_ = g_slice_new0 (Block7Data);
				_data7_->_ref_count_ = 1;
				_data7_->self = g_object_ref (self);
				_data7_->rows = -1;
#line 538 "rygel-media-export-media-cache.vala"
				rygel_media_export_database_exec (self->priv->db, "SELECT count(type) FROM sqlite_master " "WHERE rowid=1", NULL, 0, __lambda9__rygel_media_export_database_row_callback, _data7_, NULL, &_inner_error_);
#line 1859 "rygel-media-export-media-cache.c"
				if (_inner_error_ != NULL) {
					block7_data_unref (_data7_);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch6_rygel_media_export_database_error;
					}
					block7_data_unref (_data7_);
					_g_error_free0 (_error_);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
#line 546 "rygel-media-export-media-cache.vala"
				if (_data7_->rows == 0) {
#line 547 "rygel-media-export-media-cache.vala"
					g_debug ("rygel-media-export-media-cache.vala:547: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_MEDIA_CACHE_schema_version);
#line 549 "rygel-media-export-media-cache.vala"
					if (!rygel_media_export_media_cache_create_schema (self)) {
#line 1877 "rygel-media-export-media-cache.c"
						RygelMediaExportDatabase* _tmp4_;
#line 550 "rygel-media-export-media-cache.vala"
						self->priv->db = (_tmp4_ = NULL, _g_object_unref0 (self->priv->db), _tmp4_);
#line 1881 "rygel-media-export-media-cache.c"
						block7_data_unref (_data7_);
						_g_error_free0 (_error_);
#line 552 "rygel-media-export-media-cache.vala"
						return;
#line 1886 "rygel-media-export-media-cache.c"
					}
				} else {
					RygelMediaExportDatabase* _tmp5_;
#line 555 "rygel-media-export-media-cache.vala"
					g_warning ("rygel-media-export-media-cache.vala:555: Incompatible schema... cannot" \
" proceed");
#line 556 "rygel-media-export-media-cache.vala"
					self->priv->db = (_tmp5_ = NULL, _g_object_unref0 (self->priv->db), _tmp5_);
#line 1894 "rygel-media-export-media-cache.c"
					block7_data_unref (_data7_);
					_g_error_free0 (_error_);
#line 558 "rygel-media-export-media-cache.vala"
					return;
#line 1899 "rygel-media-export-media-cache.c"
				}
				block7_data_unref (_data7_);
			}
			goto __finally6;
			__catch6_rygel_media_export_database_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
					RygelMediaExportDatabase* _tmp6_;
#line 561 "rygel-media-export-media-cache.vala"
					g_warning ("rygel-media-export-media-cache.vala:561: Something weird going on: %s", _error_->message);
#line 562 "rygel-media-export-media-cache.vala"
					self->priv->db = (_tmp6_ = NULL, _g_object_unref0 (self->priv->db), _tmp6_);
#line 1915 "rygel-media-export-media-cache.c"
					_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR, "Invalid database");
					{
						_g_error_free0 (_error_);
						_g_error_free0 (_error_);
						goto __finally6;
					}
					_g_error_free0 (_error_);
				}
			}
			__finally6:
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally5;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 569 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
#line 1943 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	GValue* _tmp17_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp16_ = NULL;
	GValue _tmp15_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp5_ = {0};
	GValue _tmp4_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp0_ = {0};
	GValue* values;
#line 569 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 569 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 1970 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	values = (_tmp17_ = (_tmp16_ = g_new0 (GValue, 16), _tmp16_[0] = (g_value_init (&_tmp0_, G_TYPE_LONG), g_value_set_long (&_tmp0_, item->size), _tmp0_), _tmp16_[1] = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, item->mime_type), _tmp1_), _tmp16_[2] = (g_value_init (&_tmp2_, G_TYPE_INT), g_value_set_int (&_tmp2_, item->width), _tmp2_), _tmp16_[3] = (g_value_init (&_tmp3_, G_TYPE_INT), g_value_set_int (&_tmp3_, item->height), _tmp3_), _tmp16_[4] = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_set_string (&_tmp4_, ((RygelMediaObject*) item)->upnp_class), _tmp4_), _tmp16_[5] = (g_value_init (&_tmp5_, G_TYPE_STRING), g_value_set_string (&_tmp5_, item->author), _tmp5_), _tmp16_[6] = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_set_string (&_tmp6_, item->album), _tmp6_), _tmp16_[7] = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, item->date), _tmp7_), _tmp16_[8] = (g_value_init (&_tmp8_, G_TYPE_INT), g_value_set_int (&_tmp8_, item->bitrate), _tmp8_), _tmp16_[9] = (g_value_init (&_tmp9_, G_TYPE_INT), g_value_set_int (&_tmp9_, item->sample_freq), _tmp9_), _tmp16_[10] = (g_value_init (&_tmp10_, G_TYPE_INT), g_value_set_int (&_tmp10_, item->bits_per_sample), _tmp10_), _tmp16_[11] = (g_value_init (&_tmp11_, G_TYPE_INT), g_value_set_int (&_tmp11_, item->n_audio_channels), _tmp11_), _tmp16_[12] = (g_value_init (&_tmp12_, G_TYPE_INT), g_value_set_int (&_tmp12_, item->track_number), _tmp12_), _tmp16_[13] = (g_value_init (&_tmp13_, G_TYPE_INT), g_value_set_int (&_tmp13_, item->color_depth), _tmp13_), _tmp16_[14] = (g_value_init (&_tmp14_, G_TYPE_LONG), g_value_set_long (&_tmp14_, item->duration), _tmp14_), _tmp16_[15] = (g_value_init (&_tmp15_, G_TYPE_STRING), g_value_set_string (&_tmp15_, ((RygelMediaObject*) item)->id), _tmp15_), _tmp16_), values_length1 = 16, _values_size_ = values_length1, _tmp17_);
#line 586 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_SAVE_META_DATA_STRING, values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 1975 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 589 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error) {
#line 1987 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	gint type;
	GValue parent = {0};
	char* _tmp4_;
	GValue* _tmp14_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp13_ = NULL;
	GValue _tmp12_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp7_ = {0};
	GValue* values;
#line 589 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 589 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 2007 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 590 "rygel-media-export-media-cache.vala"
	type = (gint) RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER;
#line 593 "rygel-media-export-media-cache.vala"
	if (RYGEL_IS_MEDIA_ITEM (item)) {
#line 594 "rygel-media-export-media-cache.vala"
		type = (gint) RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM;
#line 2015 "rygel-media-export-media-cache.c"
	}
#line 597 "rygel-media-export-media-cache.vala"
	if (item->parent == NULL) {
#line 2019 "rygel-media-export-media-cache.c"
		GValue _tmp1_;
		GValue _tmp0_ = {0};
#line 598 "rygel-media-export-media-cache.vala"
		parent = (_tmp1_ = (rygel_media_export_database_null (&_tmp0_), _tmp0_), G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL, _tmp1_);
#line 2024 "rygel-media-export-media-cache.c"
	} else {
		GValue _tmp3_;
		GValue _tmp2_ = {0};
#line 600 "rygel-media-export-media-cache.vala"
		parent = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, ((RygelMediaObject*) item->parent)->id), _tmp2_), G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL, _tmp3_);
#line 2030 "rygel-media-export-media-cache.c"
	}
	_tmp4_ = NULL;
#line 608 "rygel-media-export-media-cache.vala"
	if (gee_collection_get_size ((GeeCollection*) item->uris) == 0) {
#line 2035 "rygel-media-export-media-cache.c"
		char* _tmp5_;
#line 608 "rygel-media-export-media-cache.vala"
		_tmp4_ = (_tmp5_ = NULL, _g_free0 (_tmp4_), _tmp5_);
#line 2039 "rygel-media-export-media-cache.c"
	} else {
		char* _tmp6_;
		_tmp4_ = (_tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) item->uris, 0), _g_free0 (_tmp4_), _tmp6_);
	}
	values = (_tmp14_ = (_tmp13_ = g_new0 (GValue, 6), _tmp13_[0] = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, item->id), _tmp7_), _tmp13_[1] = (g_value_init (&_tmp8_, G_TYPE_STRING), g_value_set_string (&_tmp8_, rygel_media_object_get_title (item)), _tmp8_), _tmp13_[2] = (g_value_init (&_tmp9_, G_TYPE_INT), g_value_set_int (&_tmp9_, type), _tmp9_), _tmp13_[3] = G_IS_VALUE (&parent) ? (g_value_init (&_tmp10_, G_VALUE_TYPE (&parent)), g_value_copy (&parent, &_tmp10_), _tmp10_) : parent, _tmp13_[4] = (g_value_init (&_tmp11_, G_TYPE_INT64), g_value_set_int64 (&_tmp11_, (gint64) item->modified), _tmp11_), _tmp13_[5] = (g_value_init (&_tmp12_, G_TYPE_STRING), g_value_set_string (&_tmp12_, _tmp4_), _tmp12_), _tmp13_), values_length1 = 6, _values_size_ = values_length1, _tmp14_);
#line 610 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_INSERT_OBJECT_STRING, values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 2047 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		_g_free0 (_tmp4_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
	_g_free0 (_tmp4_);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 621 "rygel-media-export-media-cache.vala"
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
#line 2063 "rygel-media-export-media-cache.c"
	gboolean result = FALSE;
	GError * _inner_error_;
#line 621 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2068 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	{
#line 623 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 2073 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
#line 624 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_SCHEMA_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2079 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
#line 625 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_TRIGGER_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2085 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
#line 626 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TABLE, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2091 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
#line 627 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_INDICES_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2097 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
#line 628 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2103 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
#line 629 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 2109 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
#line 630 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_analyze (self->priv->db);
#line 2115 "rygel-media-export-media-cache.c"
		result = TRUE;
#line 632 "rygel-media-export-media-cache.vala"
		return result;
#line 2119 "rygel-media-export-media-cache.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 634 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:634: Failed to create schema: %s", err->message);
#line 635 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 2132 "rygel-media-export-media-cache.c"
			_g_error_free0 (err);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
#line 638 "rygel-media-export-media-cache.vala"
	return result;
#line 2145 "rygel-media-export-media-cache.c"
}


#line 641 "rygel-media-export-media-cache.vala"
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement) {
#line 2151 "rygel-media-export-media-cache.c"
	RygelMediaObject* result = NULL;
	RygelMediaObject* object;
#line 641 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 641 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 641 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, NULL);
#line 644 "rygel-media-export-media-cache.vala"
	object = NULL;
#line 645 "rygel-media-export-media-cache.vala"
	switch (sqlite3_column_int (statement, 0)) {
#line 2164 "rygel-media-export-media-cache.c"
		case 0:
		{
			RygelMediaObject* _tmp0_;
			char* uri;
#line 648 "rygel-media-export-media-cache.vala"
			object = (_tmp0_ = (RygelMediaObject*) rygel_media_export_db_object_factory_get_container (self->priv->factory, self, object_id, sqlite3_column_text (statement, 1), (guint) 0), _g_object_unref0 (object), _tmp0_);
#line 652 "rygel-media-export-media-cache.vala"
			uri = g_strdup (sqlite3_column_text (statement, 20));
#line 653 "rygel-media-export-media-cache.vala"
			if (uri != NULL) {
#line 654 "rygel-media-export-media-cache.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) object->uris, uri);
#line 2177 "rygel-media-export-media-cache.c"
			}
			_g_free0 (uri);
#line 656 "rygel-media-export-media-cache.vala"
			break;
#line 2182 "rygel-media-export-media-cache.c"
		}
		case 1:
		{
			RygelMediaObject* _tmp1_;
			RygelMediaObject* _tmp2_;
			char* uri;
#line 659 "rygel-media-export-media-cache.vala"
			object = (_tmp1_ = (RygelMediaObject*) rygel_media_export_db_object_factory_get_item (self->priv->factory, self, parent, object_id, sqlite3_column_text (statement, 1), sqlite3_column_text (statement, 6)), _g_object_unref0 (object), _tmp1_);
#line 664 "rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_fill_item (self, statement, (_tmp2_ = object, RYGEL_IS_MEDIA_ITEM (_tmp2_) ? ((RygelMediaItem*) _tmp2_) : NULL));
#line 665 "rygel-media-export-media-cache.vala"
			uri = g_strdup (sqlite3_column_text (statement, 20));
#line 666 "rygel-media-export-media-cache.vala"
			if (uri != NULL) {
#line 2197 "rygel-media-export-media-cache.c"
				RygelMediaObject* _tmp3_;
#line 667 "rygel-media-export-media-cache.vala"
				rygel_media_item_add_uri ((_tmp3_ = object, RYGEL_IS_MEDIA_ITEM (_tmp3_) ? ((RygelMediaItem*) _tmp3_) : NULL), uri, NULL);
#line 2201 "rygel-media-export-media-cache.c"
			}
			_g_free0 (uri);
#line 669 "rygel-media-export-media-cache.vala"
			break;
#line 2206 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 671 "rygel-media-export-media-cache.vala"
			g_assert_not_reached ();
#line 2212 "rygel-media-export-media-cache.c"
		}
	}
#line 674 "rygel-media-export-media-cache.vala"
	if (object != NULL) {
#line 675 "rygel-media-export-media-cache.vala"
		object->modified = (guint64) sqlite3_column_int64 (statement, 18);
#line 2219 "rygel-media-export-media-cache.c"
	}
	result = object;
#line 678 "rygel-media-export-media-cache.vala"
	return result;
#line 2224 "rygel-media-export-media-cache.c"
}


#line 681 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item) {
#line 2230 "rygel-media-export-media-cache.c"
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
#line 681 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 681 "rygel-media-export-media-cache.vala"
	g_return_if_fail (statement != NULL);
#line 681 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 682 "rygel-media-export-media-cache.vala"
	item->author = (_tmp0_ = g_strdup (sqlite3_column_text (statement, 7)), _g_free0 (item->author), _tmp0_);
#line 683 "rygel-media-export-media-cache.vala"
	item->album = (_tmp1_ = g_strdup (sqlite3_column_text (statement, 8)), _g_free0 (item->album), _tmp1_);
#line 684 "rygel-media-export-media-cache.vala"
	item->date = (_tmp2_ = g_strdup (sqlite3_column_text (statement, 9)), _g_free0 (item->date), _tmp2_);
#line 685 "rygel-media-export-media-cache.vala"
	item->mime_type = (_tmp3_ = g_strdup (sqlite3_column_text (statement, 3)), _g_free0 (item->mime_type), _tmp3_);
#line 686 "rygel-media-export-media-cache.vala"
	item->duration = (glong) sqlite3_column_int64 (statement, 16);
#line 688 "rygel-media-export-media-cache.vala"
	item->size = (glong) sqlite3_column_int64 (statement, 2);
#line 689 "rygel-media-export-media-cache.vala"
	item->bitrate = sqlite3_column_int (statement, 10);
#line 691 "rygel-media-export-media-cache.vala"
	item->sample_freq = sqlite3_column_int (statement, 11);
#line 692 "rygel-media-export-media-cache.vala"
	item->bits_per_sample = sqlite3_column_int (statement, 12);
#line 693 "rygel-media-export-media-cache.vala"
	item->n_audio_channels = sqlite3_column_int (statement, 13);
#line 694 "rygel-media-export-media-cache.vala"
	item->track_number = sqlite3_column_int (statement, 14);
#line 696 "rygel-media-export-media-cache.vala"
	item->width = sqlite3_column_int (statement, 4);
#line 697 "rygel-media-export-media-cache.vala"
	item->height = sqlite3_column_int (statement, 5);
#line 698 "rygel-media-export-media-cache.vala"
	item->color_depth = sqlite3_column_int (statement, 15);
#line 2269 "rygel-media-export-media-cache.c"
}


#line 708 "rygel-media-export-media-cache.vala"
static gboolean _lambda10_ (sqlite3_stmt* statement, Block8Data* _data8_) {
#line 2275 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data8_->self;
#line 708 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 709 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data8_->children, sqlite3_column_text (statement, 0));
#line 2283 "rygel-media-export-media-cache.c"
	result = TRUE;
#line 711 "rygel-media-export-media-cache.vala"
	return result;
#line 2287 "rygel-media-export-media-cache.c"
}


#line 708 "rygel-media-export-media-cache.vala"
static gboolean __lambda10__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 2293 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda10_ (stmt, self);
	return result;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	++_data8_->_ref_count_;
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if ((--_data8_->_ref_count_) == 0) {
		_g_object_unref0 (_data8_->self);
		_g_object_unref0 (_data8_->children);
		g_slice_free (Block8Data, _data8_);
	}
}


#line 701 "rygel-media-export-media-cache.vala"
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const char* container_id, GError** error) {
#line 2317 "rygel-media-export-media-cache.c"
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	Block8Data* _data8_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 701 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 701 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 2331 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->children = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 706 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CHILD_ID_STRING, values, values_length1, __lambda10__rygel_media_export_database_row_callback, _data8_, NULL, &_inner_error_);
#line 2340 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block8_data_unref (_data8_);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block8_data_unref (_data8_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data8_->children);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block8_data_unref (_data8_);
#line 714 "rygel-media-export-media-cache.vala"
	return result;
#line 2360 "rygel-media-export-media-cache.c"
}


#line 717 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error) {
#line 2366 "rygel-media-export-media-cache.c"
	char* result = NULL;
	GError * _inner_error_;
#line 717 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 717 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 2373 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 720 "rygel-media-export-media-cache.vala"
	if (expression == NULL) {
#line 2377 "rygel-media-export-media-cache.c"
		result = NULL;
#line 721 "rygel-media-export-media-cache.vala"
		return result;
#line 2381 "rygel-media-export-media-cache.c"
	}
#line 724 "rygel-media-export-media-cache.vala"
	if (RYGEL_IS_LOGICAL_EXPRESSION (expression)) {
#line 2385 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp0_;
		char* _tmp1_;
#line 725 "rygel-media-export-media-cache.vala"
		_tmp1_ = rygel_media_export_media_cache_logical_expression_to_sql (self, (_tmp0_ = expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp0_) ? ((RygelLogicalExpression*) _tmp0_) : NULL), args, &_inner_error_);
#line 2390 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp1_;
#line 725 "rygel-media-export-media-cache.vala"
		return result;
#line 2398 "rygel-media-export-media-cache.c"
	} else {
		RygelSearchExpression* _tmp2_;
		char* _tmp3_;
#line 728 "rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_media_cache_relational_expression_to_sql (self, (_tmp2_ = expression, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp2_) ? ((RygelRelationalExpression*) _tmp2_) : NULL), args, &_inner_error_);
#line 2404 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp3_;
#line 728 "rygel-media-export-media-cache.vala"
		return result;
#line 2412 "rygel-media-export-media-cache.c"
	}
}


#line 734 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error) {
#line 2419 "rygel-media-export-media-cache.c"
	char* result = NULL;
	GError * _inner_error_;
	char* left_sql_string;
	char* right_sql_string;
	char* operator_sql_string;
#line 734 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 734 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 2429 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 737 "rygel-media-export-media-cache.vala"
	left_sql_string = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand1, args, &_inner_error_);
#line 2433 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 739 "rygel-media-export-media-cache.vala"
	right_sql_string = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand2, args, &_inner_error_);
#line 2440 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (left_sql_string);
		return NULL;
	}
#line 741 "rygel-media-export-media-cache.vala"
	operator_sql_string = g_strdup ("OR");
#line 743 "rygel-media-export-media-cache.vala"
	if (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op) == RYGEL_LOGICAL_OPERATOR_AND) {
#line 2450 "rygel-media-export-media-cache.c"
		char* _tmp0_;
#line 744 "rygel-media-export-media-cache.vala"
		operator_sql_string = (_tmp0_ = g_strdup ("AND"), _g_free0 (operator_sql_string), _tmp0_);
#line 2454 "rygel-media-export-media-cache.c"
	}
	result = g_strdup_printf ("(%s %s %s)", left_sql_string, operator_sql_string, right_sql_string);
	_g_free0 (left_sql_string);
	_g_free0 (right_sql_string);
	_g_free0 (operator_sql_string);
#line 747 "rygel-media-export-media-cache.vala"
	return result;
#line 2462 "rygel-media-export-media-cache.c"
}


#line 752 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const char* operand, GError** error) {
#line 2468 "rygel-media-export-media-cache.c"
	char* result = NULL;
	GError * _inner_error_;
	char* column;
	GQuark _tmp9_;
	const char* _tmp8_;
	static GQuark _tmp9__label0 = 0;
	static GQuark _tmp9__label1 = 0;
	static GQuark _tmp9__label2 = 0;
	static GQuark _tmp9__label3 = 0;
	static GQuark _tmp9__label4 = 0;
	static GQuark _tmp9__label5 = 0;
	static GQuark _tmp9__label6 = 0;
	static GQuark _tmp9__label7 = 0;
	static GQuark _tmp9__label8 = 0;
#line 752 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 752 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (operand != NULL, NULL);
#line 2487 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 753 "rygel-media-export-media-cache.vala"
	column = NULL;
#line 2491 "rygel-media-export-media-cache.c"
	_tmp8_ = operand;
	_tmp9_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
	if (_tmp9_ == ((0 != _tmp9__label0) ? _tmp9__label0 : (_tmp9__label0 = g_quark_from_static_string ("res"))))
	switch (0) {
		default:
		{
			char* _tmp0_;
#line 757 "rygel-media-export-media-cache.vala"
			column = (_tmp0_ = g_strdup ("o.uri"), _g_free0 (column), _tmp0_);
#line 758 "rygel-media-export-media-cache.vala"
			break;
#line 2503 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label1) ? _tmp9__label1 : (_tmp9__label1 = g_quark_from_static_string ("@id"))))
	switch (0) {
		default:
		{
			char* _tmp1_;
#line 760 "rygel-media-export-media-cache.vala"
			column = (_tmp1_ = g_strdup ("o.upnp_id"), _g_free0 (column), _tmp1_);
#line 761 "rygel-media-export-media-cache.vala"
			break;
#line 2514 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label2) ? _tmp9__label2 : (_tmp9__label2 = g_quark_from_static_string ("@parentID"))))
	switch (0) {
		default:
		{
			char* _tmp2_;
#line 763 "rygel-media-export-media-cache.vala"
			column = (_tmp2_ = g_strdup ("o.parent"), _g_free0 (column), _tmp2_);
#line 764 "rygel-media-export-media-cache.vala"
			break;
#line 2525 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label3) ? _tmp9__label3 : (_tmp9__label3 = g_quark_from_static_string ("upnp:class"))))
	switch (0) {
		default:
		{
			char* _tmp3_;
#line 766 "rygel-media-export-media-cache.vala"
			column = (_tmp3_ = g_strdup ("m.class"), _g_free0 (column), _tmp3_);
#line 767 "rygel-media-export-media-cache.vala"
			break;
#line 2536 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label4) ? _tmp9__label4 : (_tmp9__label4 = g_quark_from_static_string ("dc:title"))))
	switch (0) {
		default:
		{
			char* _tmp4_;
#line 769 "rygel-media-export-media-cache.vala"
			column = (_tmp4_ = g_strdup ("o.title"), _g_free0 (column), _tmp4_);
#line 770 "rygel-media-export-media-cache.vala"
			break;
#line 2547 "rygel-media-export-media-cache.c"
		}
	} else if ((_tmp9_ == ((0 != _tmp9__label5) ? _tmp9__label5 : (_tmp9__label5 = g_quark_from_static_string ("upnp:artist")))) || (_tmp9_ == ((0 != _tmp9__label6) ? _tmp9__label6 : (_tmp9__label6 = g_quark_from_static_string ("dc:creator")))))
	switch (0) {
		default:
		{
			char* _tmp5_;
#line 773 "rygel-media-export-media-cache.vala"
			column = (_tmp5_ = g_strdup ("m.author"), _g_free0 (column), _tmp5_);
#line 774 "rygel-media-export-media-cache.vala"
			break;
#line 2558 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label7) ? _tmp9__label7 : (_tmp9__label7 = g_quark_from_static_string ("dc:date"))))
	switch (0) {
		default:
		{
			char* _tmp6_;
#line 776 "rygel-media-export-media-cache.vala"
			column = (_tmp6_ = g_strdup ("m.date"), _g_free0 (column), _tmp6_);
#line 777 "rygel-media-export-media-cache.vala"
			break;
#line 2569 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label8) ? _tmp9__label8 : (_tmp9__label8 = g_quark_from_static_string ("upnp:album"))))
	switch (0) {
		default:
		{
			char* _tmp7_;
#line 779 "rygel-media-export-media-cache.vala"
			column = (_tmp7_ = g_strdup ("m.album"), _g_free0 (column), _tmp7_);
#line 780 "rygel-media-export-media-cache.vala"
			break;
#line 2580 "rygel-media-export-media-cache.c"
		}
	} else
	switch (0) {
		default:
		{
			char* message;
#line 782 "rygel-media-export-media-cache.vala"
			message = g_strdup_printf ("Unsupported column %s", operand);
#line 2589 "rygel-media-export-media-cache.c"
			_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_UNSUPPORTED, message);
			{
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_free0 (column);
				return NULL;
			}
		}
	}
	result = column;
#line 787 "rygel-media-export-media-cache.vala"
	return result;
#line 2602 "rygel-media-export-media-cache.c"
}


#line 790 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error) {
#line 2608 "rygel-media-export-media-cache.c"
	char* result = NULL;
	GError * _inner_error_;
	char* sql_function;
	GValue* v;
	char* column;
#line 790 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 790 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 2618 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 793 "rygel-media-export-media-cache.vala"
	sql_function = NULL;
#line 794 "rygel-media-export-media-cache.vala"
	v = NULL;
#line 796 "rygel-media-export-media-cache.vala"
	column = rygel_media_export_media_cache_map_operand_to_column (self, (const char*) ((RygelSearchExpression*) exp)->operand1, &_inner_error_);
#line 2626 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sql_function);
		_g_free0 (v);
		return NULL;
	}
#line 798 "rygel-media-export-media-cache.vala"
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op)) {
#line 2635 "rygel-media-export-media-cache.c"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
#line 800 "rygel-media-export-media-cache.vala"
			if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) exp)->operand2, "true") == 0) {
#line 2640 "rygel-media-export-media-cache.c"
				char* _tmp0_;
#line 801 "rygel-media-export-media-cache.vala"
				sql_function = (_tmp0_ = g_strdup ("IS NOT NULL AND %s != ''"), _g_free0 (sql_function), _tmp0_);
#line 2644 "rygel-media-export-media-cache.c"
			} else {
				char* _tmp1_;
#line 803 "rygel-media-export-media-cache.vala"
				sql_function = (_tmp1_ = g_strdup ("IS NULL OR %s = ''"), _g_free0 (sql_function), _tmp1_);
#line 2649 "rygel-media-export-media-cache.c"
			}
#line 805 "rygel-media-export-media-cache.vala"
			break;
#line 2653 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			char* _tmp2_;
			GValue* _tmp4_;
			GValue* _tmp3_ = NULL;
#line 807 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp2_ = g_strdup ("="), _g_free0 (sql_function), _tmp2_);
#line 808 "rygel-media-export-media-cache.vala"
			v = (_tmp4_ = (_tmp3_ = g_new0 (GValue, 1), g_value_init (_tmp3_, G_TYPE_STRING), g_value_set_string (_tmp3_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp3_), _g_free0 (v), _tmp4_);
#line 809 "rygel-media-export-media-cache.vala"
			break;
#line 2666 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			char* _tmp5_;
			GValue* _tmp7_;
			GValue* _tmp6_ = NULL;
#line 811 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp5_ = g_strdup ("!="), _g_free0 (sql_function), _tmp5_);
#line 812 "rygel-media-export-media-cache.vala"
			v = (_tmp7_ = (_tmp6_ = g_new0 (GValue, 1), g_value_init (_tmp6_, G_TYPE_STRING), g_value_set_string (_tmp6_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp6_), _g_free0 (v), _tmp7_);
#line 813 "rygel-media-export-media-cache.vala"
			break;
#line 2679 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		{
			char* _tmp8_;
			GValue* _tmp10_;
			GValue* _tmp9_ = NULL;
#line 815 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp8_ = g_strdup ("<"), _g_free0 (sql_function), _tmp8_);
#line 816 "rygel-media-export-media-cache.vala"
			v = (_tmp10_ = (_tmp9_ = g_new0 (GValue, 1), g_value_init (_tmp9_, G_TYPE_STRING), g_value_set_string (_tmp9_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp9_), _g_free0 (v), _tmp10_);
#line 817 "rygel-media-export-media-cache.vala"
			break;
#line 2692 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		{
			char* _tmp11_;
			GValue* _tmp13_;
			GValue* _tmp12_ = NULL;
#line 819 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp11_ = g_strdup ("<="), _g_free0 (sql_function), _tmp11_);
#line 820 "rygel-media-export-media-cache.vala"
			v = (_tmp13_ = (_tmp12_ = g_new0 (GValue, 1), g_value_init (_tmp12_, G_TYPE_STRING), g_value_set_string (_tmp12_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp12_), _g_free0 (v), _tmp13_);
#line 821 "rygel-media-export-media-cache.vala"
			break;
#line 2705 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		{
			char* _tmp14_;
			GValue* _tmp16_;
			GValue* _tmp15_ = NULL;
#line 823 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp14_ = g_strdup (">"), _g_free0 (sql_function), _tmp14_);
#line 824 "rygel-media-export-media-cache.vala"
			v = (_tmp16_ = (_tmp15_ = g_new0 (GValue, 1), g_value_init (_tmp15_, G_TYPE_STRING), g_value_set_string (_tmp15_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp15_), _g_free0 (v), _tmp16_);
#line 825 "rygel-media-export-media-cache.vala"
			break;
#line 2718 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			char* _tmp17_;
			GValue* _tmp19_;
			GValue* _tmp18_ = NULL;
#line 827 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp17_ = g_strdup (">="), _g_free0 (sql_function), _tmp17_);
#line 828 "rygel-media-export-media-cache.vala"
			v = (_tmp19_ = (_tmp18_ = g_new0 (GValue, 1), g_value_init (_tmp18_, G_TYPE_STRING), g_value_set_string (_tmp18_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp18_), _g_free0 (v), _tmp19_);
#line 829 "rygel-media-export-media-cache.vala"
			break;
#line 2731 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			char* _tmp20_;
			GValue* _tmp22_;
			GValue* _tmp21_ = NULL;
#line 831 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp20_ = g_strdup ("LIKE"), _g_free0 (sql_function), _tmp20_);
#line 832 "rygel-media-export-media-cache.vala"
			v = (_tmp22_ = (_tmp21_ = g_new0 (GValue, 1), g_value_init (_tmp21_, G_TYPE_STRING), g_value_take_string (_tmp21_, g_strdup_printf ("%%%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp21_), _g_free0 (v), _tmp22_);
#line 833 "rygel-media-export-media-cache.vala"
			break;
#line 2744 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			char* _tmp23_;
			GValue* _tmp25_;
			GValue* _tmp24_ = NULL;
#line 835 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp23_ = g_strdup ("NOT LIKE"), _g_free0 (sql_function), _tmp23_);
#line 836 "rygel-media-export-media-cache.vala"
			v = (_tmp25_ = (_tmp24_ = g_new0 (GValue, 1), g_value_init (_tmp24_, G_TYPE_STRING), g_value_take_string (_tmp24_, g_strdup_printf ("%%%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp24_), _g_free0 (v), _tmp25_);
#line 837 "rygel-media-export-media-cache.vala"
			break;
#line 2757 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			char* _tmp26_;
			GValue* _tmp28_;
			GValue* _tmp27_ = NULL;
#line 839 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp26_ = g_strdup ("LIKE"), _g_free0 (sql_function), _tmp26_);
#line 840 "rygel-media-export-media-cache.vala"
			v = (_tmp28_ = (_tmp27_ = g_new0 (GValue, 1), g_value_init (_tmp27_, G_TYPE_STRING), g_value_take_string (_tmp27_, g_strdup_printf ("%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp27_), _g_free0 (v), _tmp28_);
#line 841 "rygel-media-export-media-cache.vala"
			break;
#line 2770 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 843 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:843: Unsupported op %d", (gint) GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op));
#line 844 "rygel-media-export-media-cache.vala"
			break;
#line 2778 "rygel-media-export-media-cache.c"
		}
	}
#line 847 "rygel-media-export-media-cache.vala"
	if (v != NULL) {
#line 848 "rygel-media-export-media-cache.vala"
		g_value_array_append (args, v);
#line 2785 "rygel-media-export-media-cache.c"
	}
	result = g_strdup_printf ("%s %s ?", column, sql_function);
	_g_free0 (sql_function);
	_g_free0 (v);
	_g_free0 (column);
#line 851 "rygel-media-export-media-cache.vala"
	return result;
#line 2793 "rygel-media-export-media-cache.c"
}


#line 867 "rygel-media-export-media-cache.vala"
static gboolean _lambda11_ (sqlite3_stmt* statement, Block9Data* _data9_) {
#line 2799 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data9_->self;
#line 867 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 868 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data9_->data, sqlite3_column_text (statement, 0));
#line 2807 "rygel-media-export-media-cache.c"
	result = TRUE;
#line 870 "rygel-media-export-media-cache.vala"
	return result;
#line 2811 "rygel-media-export-media-cache.c"
}


#line 867 "rygel-media-export-media-cache.vala"
static gboolean __lambda11__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 2817 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda11_ (stmt, self);
	return result;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	++_data9_->_ref_count_;
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if ((--_data9_->_ref_count_) == 0) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->data);
		g_slice_free (Block9Data, _data9_);
	}
}


#line 854 "rygel-media-export-media-cache.vala"
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const char* column, const char* filter, GValueArray* args, glong offset, glong max_count, GError** error) {
#line 2841 "rygel-media-export-media-cache.c"
	GeeList* result = NULL;
	GError * _inner_error_;
	Block9Data* _data9_;
	GValue _tmp0_ = {0};
	GValue v;
	GValue _tmp2_;
	GValue _tmp1_ = {0};
	RygelMediaExportDatabaseRowCallback _tmp3_;
	GDestroyNotify callback_target_destroy_notify = NULL;
	void* callback_target = NULL;
	RygelMediaExportDatabaseRowCallback callback;
	char* sql;
#line 854 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 854 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (column != NULL, NULL);
#line 854 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 854 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 2862 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
#line 861 "rygel-media-export-media-cache.vala"
	v = (g_value_init (&_tmp0_, G_TYPE_LONG), g_value_set_long (&_tmp0_, offset), _tmp0_);
#line 862 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 863 "rygel-media-export-media-cache.vala"
	v = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_LONG), g_value_set_long (&_tmp1_, max_count), _tmp1_), G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp2_);
#line 864 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 2875 "rygel-media-export-media-cache.c"
	_data9_->data = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	callback = (_tmp3_ = __lambda11__rygel_media_export_database_row_callback, callback_target = block9_data_ref (_data9_), callback_target_destroy_notify = block9_data_unref, _tmp3_);
#line 873 "rygel-media-export-media-cache.vala"
	sql = g_strdup_printf (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_META_DATA_COLUMN_STRING, column, filter, column);
#line 874 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, sql, args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
#line 2882 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		_g_free0 (sql);
		block9_data_unref (_data9_);
		return NULL;
	}
	result = _g_object_ref0 ((GeeList*) _data9_->data);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	_g_free0 (sql);
	block9_data_unref (_data9_);
#line 876 "rygel-media-export-media-cache.vala"
	return result;
#line 2904 "rygel-media-export-media-cache.c"
}


#line 879 "rygel-media-export-media-cache.vala"
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const char* attribute, RygelSearchExpression* expression, glong offset, glong max_count, GError** error) {
#line 2910 "rygel-media-export-media-cache.c"
	GeeList* result = NULL;
	GError * _inner_error_;
	GValueArray* args;
	char* filter;
	char* column;
	GeeList* _tmp2_;
#line 879 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 879 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (attribute != NULL, NULL);
#line 2921 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 885 "rygel-media-export-media-cache.vala"
	args = g_value_array_new ((guint) 0);
#line 886 "rygel-media-export-media-cache.vala"
	filter = rygel_media_export_media_cache_search_expression_to_sql (self, expression, args, &_inner_error_);
#line 2927 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
#line 887 "rygel-media-export-media-cache.vala"
	if (filter != NULL) {
#line 2935 "rygel-media-export-media-cache.c"
		char* _tmp0_;
#line 888 "rygel-media-export-media-cache.vala"
		filter = (_tmp0_ = g_strdup_printf (" WHERE %s ", filter), _g_free0 (filter), _tmp0_);
#line 2939 "rygel-media-export-media-cache.c"
	} else {
		char* _tmp1_;
#line 890 "rygel-media-export-media-cache.vala"
		filter = (_tmp1_ = g_strdup (""), _g_free0 (filter), _tmp1_);
#line 2944 "rygel-media-export-media-cache.c"
	}
#line 893 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:893: Parsed filter: %s", filter);
#line 895 "rygel-media-export-media-cache.vala"
	column = rygel_media_export_media_cache_map_operand_to_column (self, attribute, &_inner_error_);
#line 2950 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		_g_free0 (filter);
		return NULL;
	}
#line 897 "rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, column, filter, args, offset, max_count, &_inner_error_);
#line 2959 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		_g_free0 (filter);
		_g_free0 (column);
		return NULL;
	}
	result = _tmp2_;
	_g_value_array_free0 (args);
	_g_free0 (filter);
	_g_free0 (column);
#line 897 "rygel-media-export-media-cache.vala"
	return result;
#line 2973 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
	self = RYGEL_MEDIA_EXPORT_MEDIA_CACHE (obj);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
}


GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




