from DisplayTarget import DisplayTarget
from utils.datatypes import *
import desktop

import gtk, pango



class TargetLabel(DisplayTarget):

    def __init__(self, parent, display):

        self.__old_value = ""


        DisplayTarget.__init__(self, parent, display)

        self.__widget = gtk.Label("")
        self.__widget.show()

        self.add(self.__widget)

        self._set_property_type("value", TYPE_STRING)
        self._set_property_type("color", TYPE_STRING)
        self._set_property_type("font", TYPE_STRING)



    def __set_font(self, font):

        fontdescr = pango.FontDescription(font)
        size = fontdescr.get_size()
        size = int(desktop.pixels2points(size))
        fontdescr.set_size(size)
        self.__widget.modify_font(fontdescr)
        self.__old_value = ""
        


    def __set_color(self, color):

        self.__widget.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse(color))
        self.__old_value = ""



    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "value" and value != self.__old_value):
            value = str(value)
            # make sure we have clean UTF-8 text
            if (type(value) != type(u"")):
                try:
                    value = value.decode("utf8")
                except UnicodeDecodeError, e:
                    try:
                        value = unicode(str(value), CHARMAP, "ignore")
                    except LookupError, e:
                        value = unicode(str(value), "UTF-8", "replace")
            #end if

            #self.__widget.set_markup(str(value))
            # the idle_add is a workaround for bug #122501
            gtk.idle_add(self.__widget.set_markup, str(value))
            self.__old_value = value

        elif (key == "font"):
            self.__set_font(value)
        elif (key == "color"):
            self.__set_color(value)
        else:
            DisplayTarget.set_config(self, key, value)


# determine the locale
import commands
fail, CHARMAP = commands.getstatusoutput("locale charmap")
if (fail or not CHARMAP):
    print "Could not detect character encoding."
    CHARMAP = "ASCII"
