from main import HOME, SENSORPATHS
from config.ConfigManager import ConfigManager
from utils import singleton
from utils import dialog

from main import _

import os, sys


sys.path.append(".")
sys.path.append(HOME)



#
# Factory class for dynamically loaded Sensors.
#
class SensorFactory:

    def __init__(self):

        # a set to remember the modules loaded so far
        self.__modules = {}

        # get instance of the configuration manager
        self.__config = singleton.get(ConfigManager)



    #
    # Creates and returns a Sensor of the given type or None if the Sensor
    # could not be created.
    #
    def create_sensor(self, name, args):

        oldcwd = os.getcwd()
        sensor = None
        for p in SENSORPATHS:
            try:
                os.chdir(p)

                # reload old modules to force using the latest version; this
                # means we can edit modules while running gDesklets
                try:
                    if (self.__modules.has_key(name)):
                        module, path = self.__modules[name]
                        reload(module)

                    else:
                        module = __import__(name)
                        path = os.path.abspath(name)

                except ImportError, e:
                    if (str(e).find(name) == -1):
                        import traceback; traceback.print_exc()
                        print e
                    
                except StandardError, e:
                    # a stack trace could be useful for debugging sensors
                    import traceback; traceback.print_exc()
                    print e

                self.__modules[name] = (module, path)

            except:
                continue

            try:
                os.chdir(path)
                sensor = module.new_sensor(args)
                break
            except StandardError, e:
                # a stack trace could be useful for debugging sensors
                import traceback; traceback.print_exc()
                print e
        #end for

        if (not sensor):
            print "Could not load sensor %(name)s" % vars()
            dialog.warning(_("Could not load sensor '%(name)s'") % vars(),
                           _("An error occured while loading a sensor. This "
                             "most likely means that the sensor is broken or "
                             "simply not installed."))

        os.chdir(oldcwd)

        return sensor
