# Convenience class for conversion matters
class Convert:

    def human_readable_bytes(self, bytes):

        if (bytes >= 1099511627776):
            return "%.2f TB" % (bytes / (1024.0**4))
        elif (bytes >= 1073741824):
            return "%.2f GB" % (bytes / (1024.0**3))
        elif(bytes >= 1048576):
            return "%.2f MB" % (bytes / (1024.0**2))
        elif (bytes >= 1024):
            return "%.2f kB" % (bytes / 1024.0)
        else:
            return "%i" % bytes



    def bytes_to_gmkb(self, bytes):

        gigs = bytes / (1024 * 1024 * 1024)
        bytes %= (1024 * 1024 * 1024)
        megs = bytes / (1024 * 1024)
        bytes %= (1024 * 1024)
        ks = bytes / 1024
        bytes %= 1024
        byte = bytes

        return (gigs, megs, ks, byte)



    def gmkb_to_bytes(self, gigs, megs, ks, bytes):

        b = gigs * 1024 * 1024 * 1024
        b += megs * 1024 * 1024
        b += ks * 1024
        b += bytes

        return b


    def secs_to_dhms(self, secs):

        day = secs / (60*60*24)
        secs = secs % (60*60*24)
        hou = secs / (60*60)
        secs = secs % (60*60)
        min = secs / 60
        secs = secs % 60
        sec = secs

        return (day, hou, min, sec)



    def dhms_to_secs(self, d, h, m, s):

        secs = 60 * 60 * 24 * d
        secs += 60 * 60 * h
        secs += 60 * m
        secs += s

        return secs



    def centigrade_to_fahrenheit(self, c):

        return (9.0/5.0 * c + 32)



    def fahrenheit_to_centigrade(self, f):

        return (5.0/9.0 * f - 17.777)



    def centigrade_to_kelvin(self, c):

        return (c + 273)



    def kelvin_to_centigrade(self, k):

        return (k - 273)
