import getopt
import admin
from utils import dialog
from utils import vfs
from config import settings
from main import _

import os, sys


#
# Class for parsing command line arguments.
#
class CmdLineParser:

    __OPTIONS = "x"
    __LONGOPTIONS = ["sm-config-prefix=", "sm-client-id=",
                     "no-config", "profile="]


    def __init__(self):

        pass



    #
    # Parses the given list of command line arguments. This is usually
    # sys.argv[1:].
    #
    def parse(self, args):

        opts, rest = getopt.getopt(args, self.__OPTIONS, self.__LONGOPTIONS)

        for o, a in opts:
            if (o in ["--sm-config-prefix", "--sm-client-id"]):
                pass
            elif (o == "--no-config"):
                print "Ignoring configuration."
                settings.no_config = 1
            elif (o == "--profile"):
                settings.profile = a
                admin.set_profile(a)
        #end for


        # load displays
        if (rest):
            for display in rest:
                display = vfs.join(vfs.getcwd(), display)
                #if (not vfs.exists(display)):
                #    print vfs.getcwd()
                #    display = os.path.abspath(display)

                if (not vfs.exists(display)):
                    dialog.error(_("Could not add display"),
                                 _("The display could not be added because "
                                   "the file does not exist."))
                else:
                    admin.add_display(display)
            #end for

            if (not settings.no_config): sys.exit(0)
        #end if
