/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is 
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *      Gagan Saksena (original author)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or 
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK *****
 *
 * $Id: EphyAboutRedirector.cpp,v 1.13 2004/11/17 19:41:57 chpe Exp $
 */

#include "mozilla-config.h"

#include "config.h"

#include "EphyAboutRedirector.h"

#include <nsNetCID.h>
#include <nsIIOService.h>
#include <nsIServiceManager.h>
#include <nsCOMPtr.h>
#include <nsIURI.h>
#define MOZILLA_STRICT_API
#include <nsEmbedString.h>
#undef MOZILLA_STRICT_API

static NS_DEFINE_CID(kIOServiceCID, NS_IOSERVICE_CID);

NS_IMPL_ISUPPORTS1(EphyAboutRedirector, nsIAboutModule)

struct RedirEntry {
	const char* id;
	const char* url;
};

static RedirEntry kRedirMap[] = {
	{ "epiphany", "file://" SHARE_DIR "/epiphany.xhtml" },
	{ "conspiracy", "file://" SHARE_DIR "/conspiracy.xhtml" },
	{ "marco", "http://mpgritti.oltrelinux.com" }
};
static const int kRedirTotal = sizeof(kRedirMap)/sizeof(*kRedirMap);

NS_IMETHODIMP
EphyAboutRedirector::NewChannel(nsIURI *aURI, nsIChannel **result)
{
	NS_ENSURE_ARG(aURI);
	nsEmbedCString path;
    	(void)aURI->GetPath(path);

	nsCOMPtr<nsIIOService> ioService(do_GetService(kIOServiceCID));
	NS_ENSURE_TRUE (ioService, NS_ERROR_FAILURE);

	for (int i = 0; i< kRedirTotal; i++) 
	{
		if (strcmp(path.get(), kRedirMap[i].id) == 0)
		{
			nsCOMPtr<nsIChannel> tempChannel;
			ioService->NewChannel(nsEmbedCString(kRedirMap[i].url),
               			              nsnull, nsnull, getter_AddRefs(tempChannel));
			NS_ENSURE_TRUE (tempChannel, NS_ERROR_FAILURE);

			tempChannel->SetOriginalURI(aURI);

			*result = tempChannel.get();
			NS_ADDREF(*result);

			return NS_OK;
		}
	}

	NS_ASSERTION(0, "EphyAboutRedirector called for unknown case");
	return NS_ERROR_ILLEGAL_VALUE;
}

NS_METHOD
EphyAboutRedirector::Create(nsISupports *aOuter, REFNSIID aIID, void **aResult)
{
	EphyAboutRedirector* about = new EphyAboutRedirector();
	if (about == nsnull)
		return NS_ERROR_OUT_OF_MEMORY;
	NS_ADDREF(about);
	nsresult rv = about->QueryInterface(aIID, aResult);
	NS_RELEASE(about);
	return rv;
}
