#ifndef __GDICT_PREF_H_
#define __GDICT_PREF_H_

/* $Id: gdict-pref.h,v 1.10 2004/12/14 18:56:47 vnoel Exp $ */

/*
 *  Papadimitriou Spiros <spapadim@cs.cmu.edu>
 *  Mike Hughes <mfh@psilord.com>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 * 
 *  GDict preferences
 *
 */

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include "dict.h"

enum {
    TYPEFACE_HEADWORD,              /* Headword */
    TYPEFACE_NUMBER,                /* Sub-definition number */
    TYPEFACE_PRONUNCIATION,         /* Pronunciation */
    TYPEFACE_ETYMOLOGY,             /* Etymology */
    TYPEFACE_PART,                  /* Part of speech */
    TYPEFACE_EXAMPLE,               /* Example phrase */
    TYPEFACE_BODY,                  /* Definition body */
    TYPEFACE_XREF,                  /* Cross-reference */
    NUM_TYPEFACES
};

typedef struct _GDictTypeface {
    GdkFont   *font;
    gchar     *font_name;
    GdkColor  *color;
} GDictTypeface;

typedef struct _GDictPref {
    /* Server preferences */
    gchar        *server;
    gint          port;
    gboolean      smart;        /* Auto-detect patterns */
    gchar        *database;     /* Database to search for words and defs */
    gchar        *dfl_strat;    /* Default match strategy */

    /* Applet preferences (read only during startup) */
    gboolean      applet_handle;

    /* Font preferences */
    GDictTypeface typefaces[NUM_TYPEFACES];
} GDictPref;

GDictPref *gdict_pref_new (gpointer data);
GConfClient *gdict_get_gconf_client (void);

gboolean gdict_is_gconf_key_writable (GDictWindow *gdict, gchar *key);

int gdict_get_gconf_int (GDictWindow *gdict, gchar *key);
gboolean gdict_get_gconf_bool (GDictWindow *gdict, gchar *key);
gchar* gdict_get_gconf_string (GDictWindow *gdict, gchar *key);
void gdict_set_gconf_int (GDictWindow *gdict, gchar *key, int value);
void gdict_set_gconf_bool (GDictWindow *gdict, gchar *key, gboolean bool);
void gdict_set_gconf_string (GDictWindow *gdict, gchar *key, gchar *string);
void gdict_window_store_geometry (GDictWindow *gdict);

#endif /* __GDICT_PREF_H_ */
