/*
 *  interface_theme_images.h
 */

#ifndef __INTERFACE_IMAGES_H__
#define	__INTERFACE_IMAGES_H__

#include "Interface_theme.h"

/*	Radio button
	"radio_xpm" for all states
	
	radio_normal_remap:						 normal/prelight state
	radio_down_remap: 						 normal/prelight + button down
	radio_down_remap + radio_selected_remap: selected
*/
static const char * radio_xpm[] = {
"13 13 51 1",
". c #000000",
"S c #000000",
"? c #000000",
"= c #000000",
"* c #000000",
"z c #000000",
"! c #000000",
"% c #000000",
"& c #000000",
"i c #000000",
"j c #000000",
"8 c #000000",
"9 c #000000",
"W c #000000",
"B c #000000",
"L c #000000",
"D c #000000",
"0 c #000000",
"1 c #000000",
"2 c #000000",
"3 c #000000",
"4 c #000000",
"5 c #000000",
"6 c #000000",
"7 c #000000",
"a c #000000",
"b c #000000",
"c c #000000",
"d c #000000",
"e c #000000",
"f c #000000",
"g c #000000",
"h c #000000",
"k c #000000",
"l c #000000",
"m c #000000",
"n c #000000",
"o c #000000",
"p c #000000",
"q c #000000",
"r c #000000",
"s c #000000",
"t c #000000",
"u c #000000",
"v c #000000",
"w c #000000",
"x c #000000",
"y c #000000",
"# c #000000",
"$ c #000000",
"  None",
"   210Wklm   ",
"  3654Lstun  ",
" 37L98.z!#vo ",
"26L..*?*..$wp",
"159.=SSS=.%xq",
"048*SSSSS*&yr",
"WL.?SSSSS?.DB",
"ksz*SSSSS*iea",
"lt!.=SSS=.jfb",
"mu#..*?*..Dgc",
" nv$%&.ijDhd ",
"  owxyDefgd  ",
"   pqrBabc   "
};

static const guchar radio_normal_remap[] = {
	'.', INTERFACE_BG,INTERFACE_CURRENT,
	'S', INTERFACE_BG,INTERFACE_CURRENT,
	'?', INTERFACE_BG,INTERFACE_CURRENT,
	'=', INTERFACE_BG,INTERFACE_CURRENT,
	'*', INTERFACE_BG,INTERFACE_CURRENT,
	'z', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_TRI, 40,		230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'!', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_TRI, 75,		153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'%', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_TRI, 75,		153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	'&', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_TRI, 40,		230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	
	'i', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_BI, 230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'j', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_BI, 153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'8', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_BI, 230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	'9', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_BI, 153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	
	'W', INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'B', INTERFACE_THIN, INTERFACE_DARK,INTERFACE_CURRENT, INTERFACE_BLACK,
	'L', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_CURRENT,
	'D', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_CURRENT,
	 
	'0', INTERFACE_BI, 234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'1', INTERFACE_BI, 170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'2', INTERFACE_BI, 51,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'3', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'4', INTERFACE_BI, 21,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'5', INTERFACE_BI, 85,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'6', INTERFACE_BI, 204,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'7', INTERFACE_BI, 128,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	
	'a', INTERFACE_BI, 234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'b', INTERFACE_BI, 170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'c', INTERFACE_BI, 51,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'd', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'e', INTERFACE_BI, 21,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'f', INTERFACE_BI, 85,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'g', INTERFACE_BI, 204,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'h', INTERFACE_BI, 128,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	
	'k', INTERFACE_TRI, 27,		21,		INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'l', INTERFACE_TRI, 52,		85,		INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'm', INTERFACE_TRI, 75,		204,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'n', INTERFACE_TRI, 110,		127,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'o', INTERFACE_TRI, 110,		127,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'p', INTERFACE_TRI, 75,		204,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'q', INTERFACE_TRI, 52,		85,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'r', INTERFACE_TRI, 27,		21,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	's', INTERFACE_QUAD, 21,		32,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	't', INTERFACE_QUAD, 85,		62,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'u', INTERFACE_QUAD, 204,	88,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'v', INTERFACE_QUAD, 128,	127,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'w', INTERFACE_QUAD, 204,	88,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,
	'x', INTERFACE_QUAD, 85,		62,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,
	'y', INTERFACE_QUAD, 21,		32,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,
	
	'#', INTERFACE_BI, 116,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,
	'$', INTERFACE_BI, 116,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,
	0
};

static const guchar radio_selected_remap[] = {
	'.', INTERFACE_BASE,INTERFACE_CURRENT,
	'S', INTERFACE_BASE,INTERFACE_SELECTED,
	'?', INTERFACE_BI,	127,			INTERFACE_BASE,INTERFACE_CURRENT, INTERFACE_BASE,INTERFACE_SELECTED,
	'=', INTERFACE_BI,	179,			INTERFACE_BASE,INTERFACE_CURRENT, INTERFACE_BASE,INTERFACE_SELECTED,
	'*', INTERFACE_BI,	83,				INTERFACE_BASE,INTERFACE_CURRENT, INTERFACE_BASE,INTERFACE_SELECTED,
	'z', INTERFACE_TRI,	40,		230,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK, INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE, INTERFACE_BASE,INTERFACE_CURRENT,
	'!', INTERFACE_TRI,	75,		153,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK, INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_BASE,INTERFACE_CURRENT,
	'%', INTERFACE_TRI,	75,		153,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE, INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_BASE,INTERFACE_CURRENT,
	'&', INTERFACE_TRI,	40,		230,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE, INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_BASE,INTERFACE_CURRENT,
	'i', INTERFACE_BI,	230,			INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE, INTERFACE_BASE,INTERFACE_CURRENT,
	'j', INTERFACE_BI,	153,			INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE, INTERFACE_BASE,INTERFACE_CURRENT,
	'8', INTERFACE_BI,	230,			INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK, INTERFACE_BASE,INTERFACE_CURRENT,
	'9', INTERFACE_BI,	153,			INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK, INTERFACE_BASE,INTERFACE_CURRENT,

	'W', INTERFACE_DARK, INTERFACE_PARENT|INTERFACE_CURRENT,
	'B', INTERFACE_LIGHT, INTERFACE_PARENT|INTERFACE_CURRENT,
	'L', INTERFACE_THIN, INTERFACE_BASE, INTERFACE_CURRENT, INTERFACE_BLACK,
	'D', INTERFACE_THIN, INTERFACE_BASE, INTERFACE_CURRENT, INTERFACE_WHITE,
	 
	'0', INTERFACE_BI,	234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'1', INTERFACE_BI,	170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'2', INTERFACE_BI, 51,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'3', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'4', INTERFACE_BI, 21,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,				INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'5', INTERFACE_BI, 85,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,				INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'6', INTERFACE_BI, 204,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,				INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'7', INTERFACE_BI, 128,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,				INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	'a', INTERFACE_BI, 234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'b', INTERFACE_BI, 170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'c', INTERFACE_BI, 51,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'd', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'e', INTERFACE_BI, 21,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,				INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'f', INTERFACE_BI, 85,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,				INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'g', INTERFACE_BI, 204,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,				INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'h', INTERFACE_BI, 128,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,				INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	'k', INTERFACE_TRI, 27,		21,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'l', INTERFACE_TRI, 52,		85,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'm', INTERFACE_TRI, 75,		204,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'n', INTERFACE_TRI, 110,	127,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'o', INTERFACE_TRI, 110,	127,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'p', INTERFACE_TRI, 75,		204,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'q', INTERFACE_TRI, 52,		85,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'r', INTERFACE_TRI, 27,		21,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	's', INTERFACE_QUAD, 21,		32,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	't', INTERFACE_QUAD, 85,		62,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT, 	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'u', INTERFACE_QUAD, 204,	88,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT, 	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'v', INTERFACE_QUAD, 128,	127,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT, 	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'w', INTERFACE_QUAD, 204,	88,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'x', INTERFACE_QUAD, 85,		62,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'y', INTERFACE_QUAD, 21,		32,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	'#', INTERFACE_BI, 116,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,
	'$', INTERFACE_BI, 116,	INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BASE,INTERFACE_CURRENT,INTERFACE_BLACK,
	0
};

static const guchar radio_down_remap[] = {
	'.', INTERFACE_BG,INTERFACE_CURRENT,
	'S', INTERFACE_BG,INTERFACE_CURRENT,
	'?', INTERFACE_BG,INTERFACE_CURRENT,
	'=', INTERFACE_BG,INTERFACE_CURRENT,
	'*', INTERFACE_BG,INTERFACE_CURRENT,
	'z', INTERFACE_TRI, 40,		230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_BG,INTERFACE_CURRENT,
	'!', INTERFACE_TRI, 75,		153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_BG,INTERFACE_CURRENT,
	'%', INTERFACE_TRI, 75,		153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_BG,INTERFACE_CURRENT,
	'&', INTERFACE_TRI, 40,		230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_BG,INTERFACE_CURRENT,
	'i', INTERFACE_BI, 230,			INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,					INTERFACE_BG,INTERFACE_CURRENT,
	'j', INTERFACE_BI, 153,			INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,					INTERFACE_BG,INTERFACE_CURRENT,
	'8', INTERFACE_BI, 230,			INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,					INTERFACE_BG,INTERFACE_CURRENT,
	'9', INTERFACE_BI, 153,			INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,					INTERFACE_BG,INTERFACE_CURRENT,
	
	'W', INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'B', INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'L', INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,
	'D', INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,
	 
	'0', INTERFACE_BI,	234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'1', INTERFACE_BI,	170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'2', INTERFACE_BI, 51,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'3', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'4', INTERFACE_BI, 21,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,				INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'5', INTERFACE_BI, 85,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,				INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'6', INTERFACE_BI, 204,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,				INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'7', INTERFACE_BI, 128,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,				INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	'a', INTERFACE_BI, 234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'b', INTERFACE_BI, 170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'c', INTERFACE_BI, 51,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'd', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'e', INTERFACE_BI, 21,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,				INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'f', INTERFACE_BI, 85,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,				INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'g', INTERFACE_BI, 204,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,				INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'h', INTERFACE_BI, 128,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,				INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	'k', INTERFACE_TRI, 27,		21,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'l', INTERFACE_TRI, 52,		85,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'm', INTERFACE_TRI, 75,		204,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'n', INTERFACE_TRI, 110,	127,	INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'o', INTERFACE_TRI, 110,	127,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'p', INTERFACE_TRI, 75,		204,	INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'q', INTERFACE_TRI, 52,		85,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'r', INTERFACE_TRI, 27,		21,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	's', INTERFACE_QUAD, 21,		32,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	't', INTERFACE_QUAD, 85,		62,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT, 	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'u', INTERFACE_QUAD, 204,	88,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT, 	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'v', INTERFACE_QUAD, 128,	127,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT, 	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,
	'w', INTERFACE_QUAD, 204,	88,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'x', INTERFACE_QUAD, 85,		62,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	'y', INTERFACE_QUAD, 21,		32,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_LIGHT,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_DARK,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	'#', INTERFACE_BI, 116,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,
	'$', INTERFACE_BI, 116,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_BLACK,
	0
};


/* Checkmark
	"check_xpm" for all images
	
	check_bg_remap:		for images with normal or active state.
	check_base_remap:	for images with "base" as background.
*/
static const guchar check_bg_remap[] = {
	'#', INTERFACE_FG, INTERFACE_CURRENT,
	0
};

static const guchar check_base_remap[] = {
	'#', INTERFACE_FG, INTERFACE_CURRENT,
	0
};

static const char * check_xpm[] = {
"8 8 2 1",
"# c #000000",
"  c None",
"       #",
"      ##",
"     ###",
"#   ### ",
"## ###  ",
"#####   ",
" ###    ",
"  #     "
};


/* Radio menu item */
static const char * radio_item_xpm[] = {
"6 6 3 1",
"# c #000000",
". c #000000",
"  c None",
" .##. ",
".####.",
"######",
"######",
".####.",
" .##. ",
};

static const guchar radio_item_remap[] = {
	'#', INTERFACE_FG,INTERFACE_CURRENT,
	'.', INTERFACE_BI,	127, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_FG,INTERFACE_CURRENT,
	0
};


/* Scrollbar dimple */
static const char * dimple_xpm[] = {
"6 6 10 1",
"# c #555555",
"a c #aaaaaa",
"c c #555555",
"d c #7f7f7f",
"e c #d4d4d4",
"f c #7f7f7f",
"g c #393939",
". c #000000",
"b c #ffffff",
"  c None",
" c..c ",
"c.g##d",
".g#faa",
".#fabb",
"c#abbe",
" dabe "
};

static const guchar dimple_remap[] = {
	'#', INTERFACE_HUE,INTERFACE_BG,INTERFACE_CURRENT,0xff,0x55,
	'a', INTERFACE_HUE,INTERFACE_BG,INTERFACE_CURRENT,0x7f,0xaa,
	'c', INTERFACE_BI, 0x7f,	INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_BLACK,
	'd', INTERFACE_BI, 0x7f,	INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_HUE,INTERFACE_BG,INTERFACE_CURRENT,0x7f,0x55,
	'e', INTERFACE_BI, 0x7f,	INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_WHITE,
	'f', INTERFACE_HUE,INTERFACE_BG,INTERFACE_CURRENT,0xff,0x7f,
	'g', INTERFACE_HUE,INTERFACE_BG,INTERFACE_CURRENT,0xff,0x39,
	0
};



static const char * corner_xpm[] = {
"13 13 46 1",
"z c #000000",
"! c #000000",
"% c #000000",
"& c #000000",
"i c #000000",
"j c #000000",
"8 c #000000",
"9 c #000000",
"W c #000000",
"B c #000000",
"L c #000000",
"D c #000000",
"0 c #000000",
"1 c #000000",
"2 c #000000",
"3 c #000000",
"4 c #000000",
"5 c #000000",
"6 c #000000",
"7 c #000000",
"a c #000000",
"b c #000000",
"c c #000000",
"d c #000000",
"e c #000000",
"f c #000000",
"g c #000000",
"h c #000000",
"k c #000000",
"l c #000000",
"m c #000000",
"n c #000000",
"o c #000000",
"p c #000000",
"q c #000000",
"r c #000000",
"s c #000000",
"t c #000000",
"u c #000000",
"v c #000000",
"w c #000000",
"x c #000000",
"y c #000000",
"# c #000000",
"$ c #000000",
"  None",
"   210Wklm   ",
"  3654Lstun  ",
" 37L98 z!#vo ",
"26L       $wp",
"159       %xq",
"048       &yr",
"WL         DB",
"ksz       iea",
"lt!       jfb",
"mu#       Dgc",
" nv$%& ijDhd ",
"  owxyDefgd  ",
"   pqrBabc   "
};

static const guchar corner_remap[] = {
	'z', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_TRI, 40,		230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'!', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_TRI, 75,		153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'%', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_TRI, 75,		153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	'&', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_TRI, 40,		230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	
	'i', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_BI, 230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'j', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_BI, 153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'8', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_BI, 230,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	'9', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_BI, 153,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	
	'W', INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'B', INTERFACE_THIN, INTERFACE_DARK,INTERFACE_CURRENT, INTERFACE_BLACK,
	'L', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_LIGHT,INTERFACE_CURRENT,
	'D', INTERFACE_THIN, INTERFACE_BG,INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_CURRENT,
	 
	'0', INTERFACE_BI, 234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'1', INTERFACE_BI, 170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'2', INTERFACE_BI, 51,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'3', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'4', INTERFACE_BI, 21,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'5', INTERFACE_BI, 85,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'6', INTERFACE_BI, 204,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	'7', INTERFACE_BI, 128,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN, INTERFACE_LIGHT,INTERFACE_CURRENT, INTERFACE_WHITE,
	
	'a', INTERFACE_BI, 234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'b', INTERFACE_BI, 170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'c', INTERFACE_BI, 51,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'd', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'e', INTERFACE_BI, 21,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'f', INTERFACE_BI, 85,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'g', INTERFACE_BI, 204,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'h', INTERFACE_BI, 128,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	
	'k', INTERFACE_TRI, 27,		21,		INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'l', INTERFACE_TRI, 52,		85,		INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'm', INTERFACE_TRI, 75,		204,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'n', INTERFACE_TRI, 110,		127,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'o', INTERFACE_TRI, 110,		127,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'p', INTERFACE_TRI, 75,		204,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'q', INTERFACE_TRI, 52,		85,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'r', INTERFACE_TRI, 27,		21,		INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	's', INTERFACE_QUAD, 21,		32,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	't', INTERFACE_QUAD, 85,		62,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'u', INTERFACE_QUAD, 204,	88,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'v', INTERFACE_QUAD, 128,	127,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,
	'w', INTERFACE_QUAD, 204,	88,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,
	'x', INTERFACE_QUAD, 85,		62,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,
	'y', INTERFACE_QUAD, 21,		32,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_DARK,INTERFACE_CURRENT,INTERFACE_BLACK,		INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_LIGHT,INTERFACE_CURRENT,INTERFACE_WHITE,
	
	'#', INTERFACE_BI, 116,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,
	'$', INTERFACE_BI, 116,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_DARK,INTERFACE_CURRENT,	INTERFACE_THIN,INTERFACE_BG,INTERFACE_CURRENT,INTERFACE_LIGHT,INTERFACE_CURRENT,
	0
/*	
	'z', INTERFACE_TRI, 40,		230,	INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'!', INTERFACE_TRI, 75,		153,	INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'%', INTERFACE_TRI, 75,		153,	INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	'&', INTERFACE_TRI, 40,		230,	INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	
	'i', INTERFACE_BI, 230,	INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'j', INTERFACE_BI, 153,	INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BG,INTERFACE_CURRENT,
	'8', INTERFACE_BI, 230,	INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	'9', INTERFACE_BI, 153,	INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_BG,INTERFACE_CURRENT,
	
	'W', INTERFACE_WHITE,
	'B', INTERFACE_BLACK,
	'L', INTERFACE_LIGHT,INTERFACE_CURRENT,
	'D', INTERFACE_DARK,INTERFACE_CURRENT,
	 
	'0', INTERFACE_BI,	234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_WHITE,
	'1', INTERFACE_BI,	170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_WHITE,
	'2', INTERFACE_BI, 51,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_WHITE,
	'3', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_WHITE,
	'4', INTERFACE_BI, 21,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,
	'5', INTERFACE_BI, 85,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,
	'6', INTERFACE_BI, 204,	INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,
	'7', INTERFACE_BI, 128,	INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,
	
	'a', INTERFACE_BI, 234,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_BLACK,
	'b', INTERFACE_BI, 170,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_BLACK,
	'c', INTERFACE_BI, 51,		INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_BLACK,
	'd', INTERFACE_BI, 127,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,	INTERFACE_BLACK,
	'e', INTERFACE_BI, 21,		INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,
	'f', INTERFACE_BI, 85,		INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,
	'g', INTERFACE_BI, 204,	INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,
	'h', INTERFACE_BI, 128,	INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,
	
	'k', INTERFACE_TRI, 27,		21,		INTERFACE_WHITE,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'l', INTERFACE_TRI, 52,		85,		INTERFACE_WHITE,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'm', INTERFACE_TRI, 75,		204,	INTERFACE_WHITE,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'n', INTERFACE_TRI, 110,	127,	INTERFACE_WHITE,INTERFACE_BLACK,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'o', INTERFACE_TRI, 110,	127,	INTERFACE_BLACK,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'p', INTERFACE_TRI, 75,		204,	INTERFACE_BLACK,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'q', INTERFACE_TRI, 52,		85,		INTERFACE_BLACK,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	'r', INTERFACE_TRI, 27,		21,		INTERFACE_BLACK,INTERFACE_WHITE,	INTERFACE_BG,INTERFACE_PARENT|INTERFACE_CURRENT,
	
	's', INTERFACE_QUAD, 21,		32,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,		INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,
	't', INTERFACE_QUAD, 85,		62,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,		INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,
	'u', INTERFACE_QUAD, 204,	88,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,		INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,
	'v', INTERFACE_QUAD, 128,	127,	INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,		INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,
	'w', INTERFACE_QUAD, 204,	88,		INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,
	'x', INTERFACE_QUAD, 85,		62,		INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,
	'y', INTERFACE_QUAD, 21,		32,		INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_BLACK,		INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_WHITE,
	
	'#', INTERFACE_BI, 116,	INTERFACE_LIGHT,INTERFACE_CURRENT,	INTERFACE_DARK,INTERFACE_CURRENT,
	'$', INTERFACE_BI, 116,	INTERFACE_DARK,INTERFACE_CURRENT,		INTERFACE_LIGHT,INTERFACE_CURRENT,
	0
*/
};

/*	The available xpm, remap and state combinations. */
InterfaceImage interface_images[] = {
	check_xpm,		INTERFACE_MASK_CHECK,	check_base_remap,		GTK_STATE_NORMAL,		INTERFACE_USE(FG, INTERFACE_NORMAL)     | INTERFACE_USE(BASE, INTERFACE_NORMAL),
	check_xpm,		INTERFACE_MASK_CHECK,	check_base_remap,		GTK_STATE_PRELIGHT,		INTERFACE_USE(FG, INTERFACE_PRELIGHT)   | INTERFACE_USE(BASE, INTERFACE_NORMAL),
	check_xpm,		INTERFACE_MASK_CHECK,	check_base_remap,		GTK_STATE_INSENSITIVE,	INTERFACE_USE(FG, INTERFACE_INSENSITIVE)| INTERFACE_USE(BASE, INTERFACE_NORMAL),
	
	check_xpm,		INTERFACE_MASK_CHECK,	check_bg_remap,			GTK_STATE_ACTIVE,		INTERFACE_USE(FG, INTERFACE_ACTIVE)     | INTERFACE_USE(BASE, INTERFACE_NORMAL),
	check_xpm,		INTERFACE_MASK_CHECK,	check_bg_remap,			GTK_STATE_NORMAL,		INTERFACE_USE(FG, INTERFACE_NORMAL)     | INTERFACE_USE(BASE, INTERFACE_NORMAL),
	check_xpm,		INTERFACE_MASK_CHECK,	check_bg_remap,			GTK_STATE_PRELIGHT,		INTERFACE_USE(FG, INTERFACE_PRELIGHT)   | INTERFACE_USE(BASE, INTERFACE_NORMAL),
	check_xpm,		INTERFACE_MASK_CHECK,	check_bg_remap,			GTK_STATE_INSENSITIVE,	INTERFACE_USE(FG, INTERFACE_INSENSITIVE)| INTERFACE_USE(BASE, INTERFACE_NORMAL),

	radio_xpm,		INTERFACE_MASK_RADIO,	radio_normal_remap,		GTK_STATE_NORMAL,		INTERFACE_USE(BG, INTERFACE_NORMAL),
	radio_xpm,		INTERFACE_MASK_RADIO,	radio_normal_remap,		GTK_STATE_PRELIGHT,		INTERFACE_USE(BG, INTERFACE_PRELIGHT),
	radio_xpm,		INTERFACE_MASK_RADIO,	radio_normal_remap,		GTK_STATE_INSENSITIVE,	INTERFACE_USE(BG, INTERFACE_INSENSITIVE),
	radio_xpm,		INTERFACE_MASK_RADIO,	radio_selected_remap,	GTK_STATE_NORMAL,		INTERFACE_USE(BG, INTERFACE_NORMAL) | INTERFACE_USE(BASE,INTERFACE_NORMAL)   | INTERFACE_USE(BASE,INTERFACE_SELECTED),
	radio_xpm,		INTERFACE_MASK_RADIO,	radio_selected_remap,	GTK_STATE_PRELIGHT,		INTERFACE_USE(BG, INTERFACE_NORMAL) | INTERFACE_USE(BASE,INTERFACE_PRELIGHT) | INTERFACE_USE(BASE,INTERFACE_SELECTED),
	radio_xpm,		INTERFACE_MASK_RADIO,	radio_down_remap,		GTK_STATE_INSENSITIVE,	INTERFACE_USE(BG, INTERFACE_INSENSITIVE),
	radio_xpm,		INTERFACE_MASK_RADIO,	radio_down_remap,		GTK_STATE_ACTIVE,		INTERFACE_USE(BG, INTERFACE_ACTIVE),
	
	radio_item_xpm,	INTERFACE_MASK_RADIO_ITEM, radio_item_remap,		GTK_STATE_NORMAL,		INTERFACE_USE(FG, INTERFACE_NORMAL) | INTERFACE_USE(BG, INTERFACE_NORMAL),
	radio_item_xpm,	INTERFACE_MASK_RADIO_ITEM, radio_item_remap,		GTK_STATE_PRELIGHT,		INTERFACE_USE(FG, INTERFACE_PRELIGHT) | INTERFACE_USE(BG, INTERFACE_PRELIGHT),
	radio_item_xpm,	INTERFACE_MASK_RADIO_ITEM, radio_item_remap,		GTK_STATE_INSENSITIVE,	INTERFACE_USE(FG, INTERFACE_INSENSITIVE) | INTERFACE_USE(BG, INTERFACE_PRELIGHT),

	corner_xpm,		INTERFACE_MASK_CORNER,	corner_remap,			GTK_STATE_NORMAL,		INTERFACE_USE(BG, INTERFACE_NORMAL),
	corner_xpm,		INTERFACE_MASK_CORNER,	corner_remap,			GTK_STATE_ACTIVE,		INTERFACE_USE(BG, INTERFACE_ACTIVE),
	corner_xpm,		INTERFACE_MASK_CORNER,	corner_remap,			GTK_STATE_INSENSITIVE,	INTERFACE_USE(BG, INTERFACE_INSENSITIVE),

	dimple_xpm,		INTERFACE_MASK_DIMPLE,	dimple_remap,			GTK_STATE_NORMAL,		INTERFACE_USE(BG, INTERFACE_NORMAL),
	dimple_xpm,		INTERFACE_MASK_DIMPLE,	dimple_remap,			GTK_STATE_PRELIGHT,		INTERFACE_USE(BG, INTERFACE_PRELIGHT)
};


#endif

