/* arch-tag: 6f4e5640-5c21-4c0d-8076-6666df7752f2 */

/*  eXperience GTK engine: main.c
 *  
 *  Copyright (C) 2004-2005  Benjamin Berg <benjamin@sipsolutions.net>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <gmodule.h>
#include <gtk/gtk.h>

#include "experience.h"
#include "style.h"
#include "rcstyle.h"
#include "image.h"
#include "fill.h"

G_MODULE_EXPORT void theme_init (GTypeModule *module);
G_MODULE_EXPORT void theme_exit (void);
G_MODULE_EXPORT GtkRcStyle * theme_create_rc_style (void);
G_MODULE_EXPORT const gchar* g_module_check_init (GModule *module);

G_MODULE_EXPORT void
theme_init (GTypeModule *module)
{
	gchar * env, * copy;
	experience_g_quark = g_quark_from_string("experience_theme_engine");
	
	experience_rc_style_register_type (module);
	experience_style_register_type (module);
	
	/* widget path display */
	print_widget_path = FALSE;
	
	env = getenv ("EXPERIENCE_PRINT_WIDGET_PATH");
	
	if (env) {
		copy = g_ascii_strdown (env, -1);
		
		if (g_str_equal (copy, "true")) {
			print_widget_path = TRUE;
		}
		
		free (copy);
	}
	
	experience_image_init_class ();
	experience_fill_init_class ();
}

G_MODULE_EXPORT void
theme_exit (void)
{
	experience_cleanup_everything ();
}

G_MODULE_EXPORT GtkRcStyle *
theme_create_rc_style (void)
{
	return GTK_RC_STYLE (g_object_new (EXPERIENCE_TYPE_RC_STYLE, NULL));
}

/* The following function will be called by GTK+ when the module
 * is loaded and checks to see if we are compatible with the
 * version of GTK+ that loads us.
 */
const gchar*
g_module_check_init (GModule *module)
{
	return gtk_check_version (GTK_MAJOR_VERSION,
                          GTK_MINOR_VERSION,
	                          GTK_MICRO_VERSION - GTK_INTERFACE_AGE);
}
