#!/bin/sh

#creates PNG versions of the SVG theme

function rendertiny
{
   for soubor in $*
      do
         echo "generating PNGs from  $soubor: "
         # filenames
         n50=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-24.png/g'`
         n75=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-36.png/g'`
         n100=`echo $soubor | sed 's/\(.*\)\.svg$/\1\.png/g'`
         n150=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-72.png/g'`
         n200=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-96.png/g'`
         n400=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-192.png/g'`
         test-rsvg -z 0.05 $soubor > $n50 && echo "50%"
         test-rsvg -z 0.08 $soubor > $n75 && echo "75%"
         test-rsvg -z 0.14 $soubor > $n100 && echo "100%"
         test-rsvg -z 0.20 $soubor > $n150 && echo "150%"
         test-rsvg -z 0.5 $soubor > $n200 && echo "200%"
         test-rsvg -z 0.7 $soubor > $n400 && echo "400%"
   done
}     

function rendersmall
{
   for soubor in $*
      do
         echo "generating PNGs from  $soubor: "
         # filenames
         n50=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-24.png/g'`
         n75=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-36.png/g'`
         n100=`echo $soubor | sed 's/\(.*\)\.svg$/\1\.png/g'`
         n150=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-72.png/g'`
         n200=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-96.png/g'`
         n400=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-192.png/g'`
         test-rsvg -z 0.08 $soubor > $n50 && echo "50%"
         test-rsvg -z 0.10 $soubor > $n75 && echo "75%"
         test-rsvg -z 0.18 $soubor > $n100 && echo "100%"
         test-rsvg -z 0.3 $soubor > $n150 && echo "150%"
         test-rsvg -z 0.5 $soubor > $n200 && echo "200%"
         test-rsvg -z 0.8 $soubor > $n400 && echo "400%"
   done
}     

function render
{
   for soubor in $*
      do
         echo "generating PNGs from  $soubor: "
         # filenames
         n50=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-24.png/g'`
         n75=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-36.png/g'`
         n100=`echo $soubor | sed 's/\(.*\)\.svg$/\1\.png/g'`
         n150=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-72.png/g'`
         n200=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-96.png/g'`
         n400=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-192.png/g'`
         test-rsvg -z 0.15 $soubor > $n50 && echo "50%"
         test-rsvg -z 0.18 $soubor > $n75 && echo "75%"
         test-rsvg -z 0.25 $soubor > $n100 && echo "100%"
         test-rsvg -z 0.4 $soubor > $n150 && echo "150%"
         test-rsvg -z 0.8 $soubor > $n200 && echo "200%"
         test-rsvg -z 1 $soubor > $n400 && echo "400%"
   done
}     

function renderbig
{
   for soubor in $*
      do
         echo "generating PNGs from  $soubor: "
         # filenames
         n50=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-24.png/g'`
         n75=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-36.png/g'`
         n100=`echo $soubor | sed 's/\(.*\)\.svg$/\1\.png/g'`
         n150=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-72.png/g'`
         n200=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-96.png/g'`
         n400=`echo $soubor | sed 's/\(.*\)\.svg$/\1\-192.png/g'`
         test-rsvg -z 0.15 $soubor > $n50 && echo "50%"
         test-rsvg -z 0.18 $soubor > $n75 && echo "75%"
         test-rsvg -z 0.25 $soubor > $n100 && echo "100%"
         test-rsvg -z 0.5 $soubor > $n150 && echo "150%"
         test-rsvg -z 0.9 $soubor > $n200 && echo "200%"
         test-rsvg -z 1.2 $soubor > $n400 && echo "400%"
   done
}

function renderemblems
{
   for soubor in $*
      do
         echo "generating PNGs from  $soubor: "
         # filenames
         n100=`echo $soubor | sed 's/\(.*\)\.svg$/\1\.png/g'`
         test-rsvg -z 0.25 $soubor > $n100 && echo "100%"
   done
}

echo
echo "This will clean *.svg and *.png in `pwd`!!"
echo ""
echo "to exit, press ^C now!"
read
rm *.png *.svg
cp -v ../ScalableGorilla/*.svg .
#smaller icons
render trash*.svg i-directory*.svg  temp-home.svg  \
gnome-{text,image,application,video,http,}*.svg \
i-spreadsheet.svg loading.svg i-core.svg i-music.svg gnome-library.svg 
#supersmall
rendertiny i-cdrom.svg i-blockdev.svg i-smb.svg i-executable.svg \
i-nfs.svg i-chardev.svg
#bigger
renderbig i-regular.svg 
#tiny icons
rendersmall i-symlink.svg i-web.svg gnome-application-x-bzip.svg \
gnome-pack*.svg gnome-compressed.svg gnome-application-x-compress.svg \
gnome-application-x-arj.svg gnome-application-x-compressed-tar.svg \
gnome-application-zip.svg
#emblems
renderemblems emblem-*.svg audio.svg
cd extra_emblems/
cp ../../ScalableGorilla/extra_emblems/*.svg .
renderemblems *.svg
rm *.svg
cd ../

cp -v ../ScalableGorilla/{decrement,increment,theme_preview,zoom_body}.png .
cp -v midtoolbar/* .
rm *.svg
