/***************************************************************************
                          cmapcreationundo.cpp
                      -------------------
    description          :
    begin                : Wed Feb 7 2001
    copyright            : (C) 2001 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cmapcreationundo.h"

CMapCreationUndo::CMapCreationUndo(CMapWidget* mapper, int maxUndoSteps)
{
  active = true;
  map = mapper;
  maxSteps = maxUndoSteps > 0 ? maxUndoSteps : 10;
  stepCount = 0;
  connect(mapper, SIGNAL(elementsAutoCreated(CMapUndoElement*)), this, SLOT(slotElementCreated(CMapUndoElement*)));
}

CMapCreationUndo::~CMapCreationUndo()
{
  undoList.setAutoDelete(true);
  undoList.clear();
}

/** slot to be called when elements are autmatically created by the mapper */
void CMapCreationUndo::slotElementCreated(CMapUndoElement* element)
{
  if (!active) return;
  push(element);
//  CMapRoom* room = element->getRoom();
}

/** to be called when a creational step should be undone */
void CMapCreationUndo::slotUndo()
{
  if (!active) return;
  if (stepCount == 0) return;

  CMapUndoElement* element;
  direction dir;
  CMapRoom* room;
  CMapRoom* undoRoom;
  CMapPath* path;
  int level;
  CMapZone* zone;

  element = pop();
  dir = element->getDirection();
  room = element->getRoom();
  if (room == NULL)
  {
    fprintf(stderr, "CMapCreationUndo::slotUndo: element's room was NULL\n");
    return;
  }

  path = room->getPathDirection(dir, "");

  undoRoom = path->getDestRoom();
  level = undoRoom->getLevel();
  zone = undoRoom->getZone();

  // first remove the path if one was created
  if (element->isFlagSet(element->PATH) || element->isFlagSet(element->BIDIR))
  {
    if (element->isFlagSet(element->BIDIR))
    {
      map->delElement(path);
    }
    else
    {
      CMapPath* oposite = path->getOpsitePath();
      if (oposite) {
        map->makePathOneWay(oposite);
      }
      else
      {
        map->delElement(path);
      }
    }
  }

  // second remove the room if one was created
  if (element->isFlagSet(element->ROOM))
  {
    map->delElement(undoRoom);
  }

  // third remove the level if one was created
  if (element->isFlagSet(element->LEVEL))
  {
    map->deleteLevel(level, zone, false);
  }

  map->setCurrentPos(room); // set player position to the previous room
}

/** if activate is false signals are ignored */
void CMapCreationUndo::setActive(bool activate)
{
  active = activate;
}

bool CMapCreationUndo::isActive()
{
  return active;
}

/** clears the stack of undoable steps */
void CMapCreationUndo::clear()
{
  undoList.setAutoDelete(true);
  undoList.clear();
  stepCount = 0;
}

/** appends an element to the list of undo steps */
void CMapCreationUndo::push(CMapUndoElement* element)
{
  if (stepCount == maxSteps)
  {
    undoList.setAutoDelete(true);
    undoList.removeFirst();
    stepCount--;
  }

  undoList.append(element);
  stepCount++;
}

/** removes an element and returns it */
CMapUndoElement* CMapCreationUndo::pop()
{
  CMapUndoElement* element = undoList.last();
  undoList.setAutoDelete(false);
  undoList.removeLast();
  stepCount--;
  return element;
}
