/***************************************************************************
                          cmaproom.h
                      -------------------
    description          : The room map element
    begin                : Wed Oct 20 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMAPROOM_H
#define CMAPROOM_H

#include <qpainter.h>
#include <qlist.h>

#include "cmapelement.h"
#include "cmappath.h"
#include "cmapzone.h"

class CMapPath;
class CMapZone;

/**This class is used to store the details of each room
  *on the map
  *@author John-Paul Stanford
  */
class CMapRoom : public CMapElement
{
public:                                                                             	
	/** Constructor which is used to create a new room */
	CMapRoom(CMapZone *mapZone);
	~CMapRoom(void);

	/** Used to add a exit from the room */
	void addPath(CMapPath *path);
	/** Used to find the path for the give direction. If a path can't be found then
	    null is returned                                                             */
	CMapPath *getPathDirection(direction dir,QString specialCmd);

	void setLevel(signed int level)             { mapLevel = level; }
	signed int  getLevel(void)                  { return mapLevel;  }
	
	void setEditMode(bool edit);

	void setX(int x);			
	void setY(int y);		
	int  getX(void)                             { return xpos; }
	int  getY(void)                             { return ypos; }

	void setCurrentRoom(bool currentRoom);
	bool getCurrentRoom(void)                   { return current; }
	void setLoginRoom(bool loginRoom)           { login = loginRoom; }
	bool getLoginRoom(void)                     { return login; }
	
	virtual void paint(QPainter *p,CMapZone *zone);
	virtual void dragPaint(QPainter *p,int offsetx,int offsety,CMapZone *zone);
	virtual void lowerPaint(QPainter *p,CMapZone *zone);
	virtual void higherPaint(QPainter *p,CMapZone *zone);
	virtual elementTyp getElementType(void)     { return ROOM; }
	virtual CMapElement *copy(void);
		
	void moveBy(int x, int y);		
	
	void setMoveTime(signed int time)           { moveTime = time; }
	signed int getMoveTime(void)                { return moveTime; }	
	
	void setLabel(QString str)                  { label = str; }
	QString getLabel(void)                      { return label; }
	void setDescription (QString str)	        { description = str; }
	QString getDescription (void)               { return description; }
	void setColour(QColor col)                  { colour = col; }
	QColor getColour(void)                      { return colour; }
	void setLoginColour(QColor col)	            { loginCol = col; }
	QColor getLoginColour(void)                 { return loginCol; }
	void setSpecialColour(QColor col)           { specialCol = col; }
	QColor getSpecialColour(void)               { return specialCol; }	
	void setCurrentColour(QColor col)           { currentCol = col; }
	QColor getCurrentColour(void)               { return currentCol; }		
	void setUseDefaultCol(bool b)               { useDefaultCol = b; }
	bool getUseDefaultCol(void)                 { return useDefaultCol; }
	
	QString getBeforeEnterCommand(void)         { return beforeEnterCommand; }	
	QString getAfterEnterCommand(void)          { return afterEnterCommand; }
	QString getBeforeExitCommand(void)          { return beforeExitCommand; }	
	QString getAfterExitCommand(void)           { return afterExitCommand; }	
	void setBeforeEnterCommand(QString command) { beforeEnterCommand = command; }	
	void setAfterEnterCommand(QString command)  { afterEnterCommand = command; }
	void setBeforeExitCommand(QString command)  { beforeExitCommand = command; }
	void setAfterExitCommand(QString command)   { afterExitCommand = command; }
	
	void delPathReferences(void);
	
	void setZone(CMapZone *mapZone)             { zone = mapZone; }
	CMapZone *getZone(void)                     { return zone; }	

	void setOldZone(CMapZone *mapOldZone)             { oldZone = mapOldZone; }
	CMapZone *getOldZone(void)                     { return oldZone; }	
	void setNewRoom(CMapRoom *mapNewRoom)             { newRoom = mapNewRoom; }
	CMapRoom *getNewRoom(void)                     { return newRoom; }	

	virtual void read(KCMapFile* kcmfile);
	virtual void write(KCMapFile* kcmfile);
		
public:
	/** Used to store details of all the paths from this room */
	QList<CMapPath> pathList;
	QList<CMapPath> connectingPaths;	

private:
	CMapZone *zone,*oldZone;
	CMapRoom *newRoom;
	bool useDefaultCol;
	QColor colour,loginCol,specialCol,currentCol;
	QString label;
	QString description;
	
	signed int moveTime;
	/** Used to store the position of the room on the map */
	int xpos,ypos;

	bool current;
	signed int  mapLevel;
	bool login;
	
	/** Command strings for the room */
	QString beforeEnterCommand;	
	QString afterEnterCommand;
	QString beforeExitCommand;
	QString afterExitCommand;
};

#endif