/***************************************************************************
                          cmaptooltext.cpp
                      -------------------
    description          : The text tool class
    begin                : Thu Nov 23 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cmaptooltext.h"

#include "dialogs/dlgmaptextproperties.h"

/** This method is called when the mouse is pressed */
void CMapToolText::mousePressEvent(QMouseEvent *e)
{
	
}

/** This method is called when the mouse is released */
void CMapToolText::mouseReleaseEvent(QMouseEvent *e)
{
	QScrollView *mapView = mapWidget->getMapView();

	if (mapWidget->getViewOverview() && mapWidget->width()>180 && mapWidget->height()>100)
	{
		int view_x,view_y;
		if (mapView->viewport()->width()>mapView->contentsWidth())
			view_x =mapView->contentsWidth();
		else
			view_x =mapView->viewport()->width();

		if (mapView->viewport()->height()>mapView->contentsHeight())
			view_y =mapView->contentsHeight();
		else
			view_y =mapView->viewport()->height();

		if (e->x()>=mapView->contentsX()+view_x-180 &&
			e->x()<=mapView->contentsX()+view_x &&
            		e->y()>=mapView->contentsY()+view_y-100 &&
	                e->y()<=mapView->contentsY()+view_y)
		{
			return;			
		}
	}

	int x = ((int)(e->x() / ROOM_SIZE)) * ROOM_SIZE;
	int y = ((int)(e->y() / ROOM_SIZE)) * ROOM_SIZE;

	QFont font;
	QString str;
	QColor col;

	DlgMapTextProperties d(mapWidget);
			
	d.setColour(mapperData->defaultTextColour);
			
	if (d.exec())
	{
		font = d.getFont();
		col = d.getColour();
		str = d.getText();
		mapWidget->createText(str,x,y+32,font,col,mapWidget->getCurrentLevel(),mapWidget->getCurrentZone(),true);
		mapWidget->redraw();
	}									
}

/** This method is called when the mouse is moved */
void CMapToolText::mouseMoveEvent(QMouseEvent *e)
{

}

/** This function called when the text tool is selected */
void CMapToolText::toolSelected(void)
{
	mapWidget->setCursor(ibeamCursor);
	mapWidget->setMouseTracking(false);
	menu->setItemChecked(id,true);	
	toolsToolbar->setButton(id,true);	
}

/** This function is called when the text tool is unselected */
void CMapToolText::toolUnselected()
{
	menu->setItemChecked(id,false);	
	toolsToolbar->setButton(id,false);	

}
