/***************************************************************************
                          dlgselectmud.cpp
                      -------------------
    description          :
    begin                : Thu Nov 4 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgselectmud.h"


DlgSelectMud::DlgSelectMud(KmudDoc* document, QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Select MUD"));
	
	CMudProfile* mud;

	initDialog();

	doc=document;
	filenames.setAutoDelete(true);
	filenames.clear();

	mud=doc->firstMud();
	while (mud!=NULL)
	{
		mud_ListBox->insertItem(mud->getTitle());
		filenames.append(mud->getFileName());
		mud=doc->nextMud();
	}

 	connect( ok_Button, SIGNAL(clicked()), SLOT(accept()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );
	connect( mud_ListBox, SIGNAL(selected(int)), SLOT(accept()) );
	connect( mud_ListBox, SIGNAL(highlighted(int)), SLOT(slotShowItem(int)) );

	if (mud_ListBox->count() >= 1 ) 
		mud_ListBox->setSelected(0,true);

}

DlgSelectMud::~DlgSelectMud(){
}

void DlgSelectMud::slotShowItem(int i)
{
	CMudProfile* mud;
	QString s;

	titleShow_Label->setText("");
	hostnameShow_Label->setText("");
	portShow_Label->setText("");

	mud=doc->getMudProfile(filenames.at(i));
	if (mud!=NULL)
	{
		titleShow_Label->setText(mud->getTitle());
		hostnameShow_Label->setText(mud->getHostName());
		s.setNum(mud->getPort());
		portShow_Label->setText(s);
	}
}

CMudProfile* DlgSelectMud::getSelectedMud()
{
	return doc->getMudProfile(filenames.at(mud_ListBox->currentItem()));
}
