/***************************************************************************
                          kmud.h
                    -------------------
    description          : Main Application Class
    begin                : Sun Jun 20 14:17:54 MEST 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KMUD_H
#define KMUD_H 

// Comment out to make sure that the map is not compiled

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qdialog.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qmultilinedit.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qtimer.h>

// include files for KDE
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <kiconloader.h>

// application specific includes
#include "kmudview.h"
#include "kmuddoc.h"
#include "resource.h"
#include "ansi.h"
#include "kmudapi.h"


#include "ctelnet.h"
#include "cmudstream.h"
#include "cmudlog.h"
#include "cpluginmanager.h"
#include "cmapwindow.h"
#include "kmuddocker.h"
#include "kmudapplication.h"
#include "ccustombarbutton.h"

// forward declarations
class DlgMultiLineInput;



/**
  * This class is the base class for Kmud.
  * It sets up the main  window and reads the config file as well as
  * providing a menubar, toolbar  and statusbar. For the main view,
  * an instance of class KmudView is created which creates the view.
  *@author Stephan Uhlmann, Andre Alexander Bell
  */

class KmudApp : public KTMainWindow
{
  Q_OBJECT

public:
	/** construtor */
	KmudApp(); 
	/** destructor */
	~KmudApp();
	/** initMenuBar creates the menu_bar and inserts the menuitems */
	void initMenuBar();
	/** this creates the toolbars. Change the toobar look and add new toolbars in this
	  * function */
	void initToolBar();
	/** setup the statusbar */
	void initStatusBar();
	/** setup the mainview*/
	void initView();
	/** setup the connection timer */
	void initTimer();
	/** save the app-specific options on slotAppExit or by an Options dialog */	
	void saveOptions();
	/** read the app-specific options on init() or by an Options dialog */
	void readOptions();
	/** enable menuentries/toolbar items */
	void enableCommand(int id_);
	/** disable menuentries/toolbar items */
	void disableCommand(int id_);
	/** does the connect to a mud */
	void connectToMud(QString mudTitle, QString login,QString mudHost,QString mudPort);
	/** Connect to a mud that as been setup in with the wizard
	  * eg. ID -> "Sunbright@MidnightSun"
	  */
	int connectWizardId(QString ID);

	/** returns pointer to the view class */
	KmudView* getView();
	/** returns pointer to the doc class */
	KmudDoc* getDoc();
	/** returns pointer to the telnet connection */
	CTelnet* getConnection();
	/** returns pointer to the mud log */
	CMudLog* getMudLog();
	/** returns pointer to the plugin manager */
	CPluginManager* getPluginManager();

	CMapWindow* getMapper();
	/** are numpad-macros enabled or disabled? */
	bool getNumpadMacros();

	/** initialises key accelerators */
	void initAccelerators();
	/** override KTMainWindow::show() */
	virtual void show();
	/** overrides KTMainWindow::hide() */
	virtual void hide();

public slots:
	/** Called when a custom toolbar item is clicked */
	void slotCustomToolbarClicked(int handle);
	/** switch argument for slot selection by menu or toolbar ID */
	void commandCallback(int id_);
	/** switch argument for Statusbar help entries on slot selection */
	void statusCallback(int id_);
	/** open a new application window */
	void slotMudNewWindow();
	/** popup connection wizard */
	void slotMudConnectionWizard();
	/** connect to mud */
	void slotMudConnect();
	/** close the actual connection */
	void slotMudClose();
	/** close the current window */
	void slotMudCloseWindow();
	/** exits the application */
	void slotMudQuit();

	/** toggle the custom toolbar*/
	void slotViewCustomToolBar();
	/** toggle the main toolbar*/	
	void slotViewToolBar();
	/** toggle the statusbar*/
	void slotViewStatusBar();
	/** toggle the alternative input*/
	void slotViewAltInput();
	/** toggle the multi line input*/
	void slotViewMultiLineInput();
	/** called when multiline input is closed (not modal!)*/
	void slotViewMultiLineInputClose();

	/** toggle the auto mapper */
	void slotViewMapper();
	
	/** setup font */
	void slotOptionFont();
	/** setup colors */
	void slotOptionColors();
	/** Preferences */
	void slotOptionPreferences();
	/** MUD Settings */
	void slotOptionMud();
	
	/** save profile */
	void slotProfileSave();
	/** aliases profile */
	void slotProfileAliases();
	/** triggers profile */
	void slotProfileTriggers();
	/** logging profile */
	void slotProfileLogging();
	/** custom toolbar profile */
	void slotProfileToobar();

	/** runs the plugin manager */
	void slotPluginManager();

	
	/** change the status message to text */
	void slotStatusMsg(const char *text);
	/** change the status message of the whole statusbar temporary */
	void slotStatusHelpMsg(const char *text);
	
	/** update the connection time */
	void slotConnectionTime(void);
	
	/** called when output from mud was received
	  *	resets mudOutputTimer and makes some action to notify user when needed
	  */
	void slotMudOutputReceived();
	/** Used to connect to a previous mud for the history list */
	void slotMudQuickConnect(int histNum);

	/** user clicked on the toolbar icon for logging on/off */
	void slotToolbarLoggingToggleClicked();

	/** return pointer to the plugin menu */
	QPopupMenu* getPluginMenu();
	
	/** user wants to hide the application's main window
	    (boss key pressed)
	  */
	void slotHideMainWindow();

	/** opens the key configuration dialog */
	void slotOptionKeys();

protected:
	/** overloaded closeEvent */
	void closeEvent(QCloseEvent*);

private:
	/** The toolbars */
	KToolBar *mainToolBar;
	KToolBar *customToolBar;
	
	signed int lastNumToolbarItems;
	
	/** Used to update the custom tool bar */
	void updateCustomToolbar(void);

	/** enables/disables Menu slots and Toolbar icons from current state
	    (connected or disconnected, character profile set or not set, ... )
	*/
	void refreshEnablesDisables();

	/** refreshes the Toolbar icon for logging on/logging off, in the case
	    that logging is enabled or disabled in the current character profile
	*/
	void refreshLoggingToolbarIcon();

	/** refreshes key accelerator bindings */
	void refreshAccelerators();

	/** If set to false then auto reconnect is disabled temporialy */
	bool autoReconnect;

	/** These varables are used to store the details of
	  * that last mud that was connected to
	  */
	QString lastTitle;
	QString lastLogin;
	QString lastHost;
	QString lastPort;

	/** The connected/disconected icon for the status bar */
	QLabel *connectIcon;
	/** file_menu contains all items of the menubar entry "File" */
	QPopupMenu *mud_menu;
	/** edit_menu contains all items of the menubar entry "Edit" */
	QPopupMenu *edit_menu;
	/** view_menu contains all items of the menubar entry "View" */
	QPopupMenu *view_menu;
	
	/** option_menu contains all items of the menubar entry "Option" */
	QPopupMenu *option_menu;
	
	/** profile_menu contains all items of the menubar entry "Profile" */
	QPopupMenu *profile_menu;

	/** plugin_menu contains all items of the menubar entry "Plugins" */
	QPopupMenu *plugin_menu;
	
	/** help_menu contains all items of the menubar entry "Help" */
	QPopupMenu *help_menu;
	
	/** view is the main widget which represents your working area. The View
	  * class should handle all events of the view widget.  It is kept empty so
	  * you can create your view according to your application's needs by
	  * changing the view class. */
	KmudView *view;

	/** This is a pointer to the main auto mapper widget */
 	CMapWindow *mapper;

	/** toggable input dialog with multiple lines */
	DlgMultiLineInput* multiLineInput;

	/** doc represents your actual document and is created only once. It keeps
	  * information such as filename and does the serialization of your files.
	  */
	KmudDoc* doc;
	
	/** Telnet connection that this instance of KmudApp handles */
	CTelnet* mud;

	/** wrapper class for the telnet connection, do all I/O there */
	CMudStream* mudstream;

	/** plugin manager for dynamic loading of our share lib plugins */
	CPluginManager* plugin_manager;

	/** class for logging facility */
	CMudLog* mudlog;

	/** instance of the kmud API */
	KmudAPI*	kmudapi;
	
	QColor mudForegroundColor;
	QColor mudBackgroundColor;
	QFont mudFont;
	QColor mudLocalEchoColor;
	QFont inputFont;
	
	QColor mudDebugHighlightColor;

	QColor mudANSIColor[ANSICOLOR_COUNT];
	
	QColor mudBgColor[BGCOLOR_COUNT];
	
	QStrList lastConnectHost;
	QStrList lastConnectPort;
	QStrList lastConnectTitle;
	QStrList lastConnectLogin;
	
	int mainWindowWidth;
	int mainWindowHeight;
	
	/** Interpretation Type */
	int interpretType;
		
	/** flag if toolbar is visible or not. Used for kconfig and checking the
	  * view-menu entry view toolbar. bViewStatusbar does the same for the
	  * statusbar.
	  */
	bool bViewToolbar;
	bool bViewCustomToolbar;
	bool bViewStatusbar;
	bool bViewAltInput;

	bool autoReconnectOption;
	bool keepLastInput;
	bool selectAllOnFocus;
	int maxOutputLines;
	int maxInputLines;
	bool sharedInputHistory;
	int localEchoMode;
	bool localEchoSuppressNewline;
	int inputEchoMode;

	int toolBarConnectButtonPosition;

	/** used for KConfig to store and restore menubar position. Same with
	  * tool_bar_pos. If more menubars or toolbars are created, you should add
	  * positions as well and implement them in saveOptions() and readOptions().
	  */
	KMenuBar::menuPosition menu_bar_pos;
	KToolBar::BarPosition tool_bar_pos;
	KToolBar::BarPosition custom_tool_bar_pos;	
	/** These variables is used to time how long a user is connected to the mud. */
	QTimer *connectTimer;
	int connectHour;
	int connectMin;
	int connectSec;

	bool mudOutputNotifyOn;
	unsigned int mudOutputNotifyWaitSeconds;
	QTimer* mudOutputTimer;
	bool mudOutputDoNotify;
	QTimer* mudOutputBlinkTimer;
	bool mudOutputIconBlinkOn;

	/** The auto reconnect timer start value */
	unsigned int autoTime;

	/** The separator character */
	QString separator;

	/** Whether or not to use the \007 beep command */
	bool useBeep;
	
	/** ID of Aliases in the Profile menu */
	int aliasID;
	/** ID of Triggers in the Profile menu */
	int triggerID;
	/** ID of Logging in the Profile menu */
	int loggingID;
	/** ID of the Toolbar in the profile menu */
	int toolbarID;
	/** ID of SAVE in the Profile menu */
	int saveID;
	/** ID of Mud in the Options menu */
	int mudOptionsID;
	
	/** ID of aliases on the ToolBar */
	int aliasToolID;
	/** ID of triggers on the ToolBar */
	int triggerToolID;
	/** ID of logging on the ToolBar */
	int loggingToolID;

	/** ID of mapper on the ToolBar */
	// KTool *mapperToolButton;
	int mapperToolID;

	/** ID of the plugin manager in the plugin menu */
	int pluginManagerID;

	/** list of plugin filenames which are auto-loaded on startup */
	QStrList autoloadPlugins;

	// QString currentLogin;

	/** special chars enabled or not */
	bool enableSpecialChars;
  /** the character, that starts a speedwalking-sequence */
  QString speedwalkingChar;
	// QString currentMudTitle;
  /** the external command char */
  QString externChar;
  /** seconds till connection made times out */
  unsigned int connecttimeout;

  /** The DockerWidget */
  KmudDocker* docker;
  /** the kmud-application-class */
  KmudApplication* app;
  /** Kmud's key accelerators */
  KAccel* accelerators;

	
private slots:
	/* internal timeout slot for mudOutputTimer */
	void slotMudOutputTimeout();
	/* internal slot for blinking mini-icon */
	void slotMudOutputBlinker();
	/** slot used to close the mapper */
	void slotCloseMapper(void);
	/** Move the player in a given direction */
	void slotMovePlayer(QString dirCmd);
protected slots: // Protected slots
  /** toggle the state of alias resolving (on/off) */
  void slotToggleAliasResolving();
  /** enable/disable triggers */
  void slotToggleTriggers();
};
 
#endif // KMUD_H
