#ifndef KWVDIALWIDGET_H 
#define KWVDIALWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <kled.h>
#include <qlistbox.h>
#include <qslider.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <ktabctl.h>

#include "wvlogrcv.h"
#include "wvbuffer.h"
#include "wvmodemscan.h"
#include "configfile/wvconf.h"

#include "kgraph.h"

class KwvdialNew : public QDialog
{
	Q_OBJECT

public:
	KwvdialNew(QWidget *parent = 0, const char *name = 0);
	virtual ~KwvdialNew();
	QLineEdit	*newprofile;

private:
	QLabel		*newprofilel;
	QGridLayout	*newprofilelayout;
	QPushButton	*ok;
};

class KwvdialWidget : public KTabCtl, public WvLogRcv
{
	Q_OBJECT

public:
	KwvdialWidget(QWidget *parent, const char *name, WvConf &_cfg);
	virtual ~KwvdialWidget();
	virtual void _begin_line();
	virtual void _mid_line(const char *str, size_t len);
	virtual void _end_line();
	void update(int timeonline);
	void statsoff();
		
public slots:
	void 		setup(int id);
	void		changedisplay(WvString sect);
	void		applyprof();
	void		resetprof();
	void		deleteprof();
	void		newprof();
	void		redrawtab();
	void		chgdsp(int id);
	void		setdirty();
	void		wvautoconf();

private:
	QListBox 	*logwindow;
	WvBuffer 	buffer;
	QGridLayout 	*loglayout;
	QWidget		*logtab;

	QGridLayout 	*graphlayout;
	QWidget		*graphtab;
	KGraph		*graph;
	QLabel		*recvl;
	KLed		*recv;
	QLabel		*trnsl;
	KLed		*trns;
	QLabel		*byteinl;
	QLabel		*bytein;
	QLabel		*byteoutl;
	QLabel		*byteout;
	QLabel		*speedl;
	QLabel		*speed;
	
	QGridLayout 	*configlayout;
	QWidget		*configtab;
	QLabel		*profilel;
	QComboBox	*profile;
	QLabel		*profiletypel;
	QComboBox	*profiletype;

	QLabel		*usernamel;
	QLineEdit	*username;
	QLabel		*passwordl;
	QLineEdit	*password;
	QCheckBox	*usetokenpassword;
	
	QLabel		*areal;
	QLineEdit	*area;
	QLabel		*telnuml;
	QLineEdit	*telnum;
	QLabel		*spid1l;
	QLineEdit	*spid1;
	QLabel		*spid2l;
	QLineEdit	*spid2;
	
	QLabel		*baudl;
	QLineEdit	*baud;
	
	QCheckBox   	*callwtg;
	QCheckBox   	*dialtone;
	QCheckBox   	*dialasld;
	QCheckBox   	*pulsetone;
	QCheckBox   	*stupidmode;
	QCheckBox	*newpppd;
	QCheckBox   	*autoredial;

	QLabel 		*currencyl;
    	QComboBox 	*currency;
    	QLabel 		*ratel;
    	QLineEdit 	*rate;
    
	QLabel		*volumel;
	QSlider		*volume;
	
	QLabel		*extrainitl;
	QLineEdit	*extrainit;
	
	QPushButton	*detectbutton;
	QPushButton	*profilebutton;
	QPushButton	*profdelbutton;
	QPushButton	*applybutton;
	QPushButton	*resetbutton;
	
	QGridLayout	*advconflayout;
	QWidget		*advconftab;
	QCheckBox	*usedialprefix;
	QLabel		*dialprefixl;
	QLineEdit	*dialprefix;
	QCheckBox	*useoutsideline;
	QLabel		*outsidelinel;
	QLineEdit	*outsideline;
	QCheckBox	*usecallingcard;
	QLabel		*callingcardl;
	QLineEdit	*callingcard;
	QPushButton	*advapplybutton;
	QPushButton	*advresetbutton;
	
	bool		dirty;
	
	WvConf		&cfg;

	long		oldbytes;
	long		oldavg;
	long		oldrcv;
	long		oldtmt;

};

#endif // KWVDIALWIDGET_H 
