.TH xrt 1 ""
.SH XRT

xrt \- Display a short text file in the root window

.SH SYNOPSIS

.B xrt
.RB [ -? ]
.RB [ -a ]
.RB [ -b\ colour ]
.RB [ -c ]
.RB [ -d ]
.RB [ -f\ font ]
.RB [ -g\ gap ]
.RB [ -h ]
.RB [ -l\ linewidth ]
.RB [ -n ]
.RB [ -p\ percentage ]
.RB [ -r ]
.RB [ -s\ colour ]
.RB [ -t\ title ]
.RB [ -w\ width ]
.RI [ filename\ [filename...] ]
.SH DESCRIPTION
.I xrt
writes a box containing text directly onto the root window, with an optional
title line. Its primary use is to display the motd on the xdm login screen
(i.e. prior to the user logging in).
.SH OPTIONS
The following options are recognised:
.PP
.RS
.TP
.B  \-?
Display a syntax usage message.
.TP
.B  \-a
Only display characters in the range ASCII 32 to 126. Tabs and linefeeds are
the only other characters dealt with if this option is used.
.TP
.B  \-b colour
Sets the specified background colour for the box, the default being
beige.
.TP
.B  \-c
Centre the text in each line of the box. Leading and trailing spaces (after tab
expansion) are removed prior to the centralisation of the text. This is
particularly useful for proportional fonts.
.TP
.B  \-d
Add the time and date (of the most recent file specified or the current time
if standard input is used) at the top of the text box. TZ is used for the
time zone, but a fallback time zone can be hard-coded in during compile-time
for use when the TZ environmental variable isn't set (e.g. during the xdm
login screen).
.TP
.B  \-f font
Use the font specified instead of the default 9x15 font (unless the specified
font doesn't exist). Either proportional or non-proportional fonts can be used,
although it is recommended that you use -c to centre proportional fonts.
.TP
.B  \-g gap
Add the specified number of pixels as an inter-line gap, the default being 1
pixel. Negative values can be specified if you want pointlessly overlapping
lines of text.
.TP
.B  \-h
Use a horizontal line to split each readable file (assuming there are 2 or more
such files) that is displayed. This enforces a limit of 16 readable files. The
line width specified via -l is ignored - the line is always one pixel high.
.TP
.B  \-l linewidth
Sets the line width of the box border (default is 3). A line width of 0 means
no border around the box.
.TP
.B  \-n
Add the last openable filename to the title at the top of the box (<stdin> is
displayed if standard input is used).
.TP
.B  \-p percent
Specify the percentage down from the top of the screen where the vertical
centre of the box (excluding the title) is located. Defaults to 50%. This is
a percentage so that different sized screens will still have sensible
positioning. For xdm login screens, the author recommends an 80% setting.
.TP
.B  \-r
Switch to reverse video (i.e. flip foreground and background colours).
.TP
.B  \-s colour
Sets the specified foreground colour for the text and borders, the
default being navyblue.
.TP
.B  \-t title
Adds the specified title to the top of the box, overriding the -n option. It
can still be combined with the -d option though.
.TP
.B  \-w width
Set a fixed width in pixels for the box (excluding any borders). This overrides
the default behaviour, which is to dynamically calculate the box width based on
the longest string to be displayed.
.SH CLEVER BITS
xrt will not draw anything if no lines of text or only blank lines of text are
supplied. It also converts tabs into spaces using a tabstop of 8 characters.
Files that can't be read are skipped with a warning to stderr. The box is now
intelligently positioned/truncated on the screen, so it usually avoids being
partially off the screen (-h might fool it though).
.SH BUGS
Nothing at the moment, he says with a grin.
.SH SEE ALSO
xdm(1),xroach(1),xsetroot(1)
.SH AUTHOR
Richard K. Lloyd	<rkl@csc.liv.ac.uk>
