#ifndef GAMESP_H
# define GAMESP_H

# include <time.h>
# include "players.h"

#define AppContext(w)   XtWidgetToApplicationContext(w)

/* Must be < 0 */
# define NOTONSERVER -1
# define REVIEWGAME  -2

# define BUSY      2 /* The first three exclude each other */
# define ADJOURNED 3 /* The bit assignments are important  */
# define OVER      1
# define SCORING   4 /* This one is a tagged on bit */
# define UNSCORING (~SCORING) /* To extract non scoring part */

#define NOBYO     -1

#define CHANGEINT(ptr, field, value, extra)     \
do {                                            \
    if ((ptr)->field != (value)) {              \
        (ptr)->field = (value);                 \
        (ptr)->Found = CHANGED;                 \
        extra;                                  \
    }                                           \
} while(0)

#define CHANGESTRING(ptr, field, value, extra)  \
do {                                            \
    if ((ptr)->field && (!value || strcmp((ptr)->field, (value))) || \
        !(ptr)->field && value) {               \
        char *sillystr;                         \
                                                \
        sillystr = mystrdup(value);             \
        myfree((ptr)->field);                   \
        (ptr)->field = sillystr;                \
        (ptr)->Found = CHANGED;                 \
        extra;                                  \
    }                                           \
} while(0)

#define PROPHANDICAP(value)                                     \
    if (Log) {                                                  \
        DeleteGlobalProperty(Log, "Handicap");                  \
        if (value) {                                            \
            sprintf(Buffer, "%d", (value));                     \
            AddGlobalProperty(Log, "Handicap", Buffer, -1);     \
        }                                                       \
    }

#define PROPSTRING(value, name)                                 \
    if (Log) {                                                  \
        DeleteGlobalProperty(Log, (name));                      \
        AddGlobalProperty(Log, (name), (value), -1);            \
    }

struct _Game {
    struct _Game    *Next, *Previous;
    Gamelog         *Log;
    int              ServerId; /* -1: not on server, -2: review */
    int              WantObserved, Observed, NrObservers;
    int              WhiteByo,       BlackByo;
    int              WhiteCaptures,  BlackCaptures;
    Player          *Black, *White, *Strongest, *Weakest;
    long             WhiteTime,      BlackTime;
    int              ByoPeriod;
    struct _Observe *Observers;
    int              Move, XSize, YSize, Handicap;
    char            *Komi, *Title;
    int              Pos;
    int              Finished, Mode, Rules, WidgetPlan;
    State            Found;
    struct tm        UniversalTime;  /* When did we see the game first */
    Widget           Widget;         /* Widget in the gamelist    */
    BWPiece          ToMove;         /* Who   is to move          */
    BWPiece	     Color; 	     /* WHITE if you play white,  */
                		     /* BLACK if you play black,  */
                		     /* EMPTY if you don't play   */
};

extern Game ReviewBase;
extern CommentFun NextMoveFun, PrevMoveFun;
extern void FreeGame(Game *game);
extern void DumpGame(const Game *game);
extern void ShowObserve(Game *game);
#endif /* GAMESP_H */
