#ifndef _WIDGETTREE_H
# define _WIDGETTREE_H

# include "myxlib.h"
# include "YShell.h"

# define ISSHELL    1
# define ISAPPSHELL 2

typedef struct _XtTypedArg {
    String      name;
    String      type;
    XtArgVal    value;
    int         size;
} XtTypedArg, *XtTypedArgList;

typedef struct _OptionTemplate {
    struct _OptionTemplate *Next;
/*  XtTypedArg             *Pos; */
    char                   *WitchetName;
    char                    WidgetName[1];
} OptionTemplate;

typedef struct _TreeTemplateList {
    struct _TreeTemplateList *Next;
    struct _OptionTemplate   *Option;
    struct _TreeTemplate     *Pos;
} TreeTemplateList;

typedef struct _OptionHash {
    struct _OptionHash *Left, *Right;
    const char         *WitchetName;
    TreeTemplateList   *Positions;
} OptionHash;

typedef struct _TreeTemplate {
    struct _TreeTemplate *Children, *Next, *Previous;
    OptionTemplate       *Options;
    OptionHash           *HashOptions;
    int                   NrArgs, NrWidgetChildren;
    XtTypedArg           *Args; 
    int                   Flags;
    WidgetClass           Class;
    char                  Name[1];
} TreeTemplate;

typedef struct _ExpansionHash {
   struct _ExpansionHash *Next;
   Widget                 Parent;
   TreeTemplate          *Tree;
} ExpansionHash;

typedef struct _witchet {
    TreeTemplate  *Where;
    ExpansionHash *Expander;
    int            NrWidgets;
    Widget         Widgets[1];
} _Witchet, *Witchet;

extern void CallDestroyWitchet(Widget w,
                               XtPointer clientdata, XtPointer calldata);
extern TreeTemplate *MakeTemplate(const char *Name, const char *Class);
extern void FreeOptionTemplates(OptionTemplate *Options);
extern void FreeTemplate(TreeTemplate *Tree);
extern TreeTemplate *treeParse(const NameClassList Base,
                               const char *Str, int Len);
#endif /* _WIDGETTREE_H */
