#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <myxlib.h>
#include <mymalloc.h>
#include <except.h>

#include "events.h"
#include "stats.h"
#include "players.h"
#include "gointer.h"
#include "xgospel.h"

struct _Stats {
    struct _Stats   *Next, *Previous;
    char            *Name, *Idle;
/*    struct _NameVal  */
};

static Stats StatsBase = { &StatsBase, &StatsBase };

static void UnSpace(char *Value)
{
    char ch, *ptr;

    ptr = Value;
    while (*ptr == ' ') ptr++;
    while ((ch = *ptr++) != 0) *Value++ = ch;
    *Value = 0;
}

static void WrapLine(char *Value, int MaxLength)
{
    char *ptr;
    int   Length;

    Length = strlen(Value);
    if (Length > MaxLength-6) { /* strlen("Info: ") = 6 */
        *Value = '\n';
        while (Length > MaxLength)
            if ((ptr = strchr(Value+MaxLength, ' ')) != NULL) {
                *ptr++  = '\n';
                Length -= ptr-Value;
                Value   = ptr;
            } else break;
    }
}

void ShowStats(NameVal *stats)
{
    const char     *Strength, *Name;
    char           *title, *icon, *ptr, *text, Buffer[300];
    Widget          Root, quit;
    NameVal        *Nameval;
    const NameList *Line, *Lines;
    Player         *Person;
    int             Length;

    Strength = Name = NULL;

    for (Nameval=stats->Next; Nameval != stats; Nameval=Nameval->Next) {
        if      (strcmp(Nameval->Name, "Info") == 0)
            WrapLine(Nameval->Value, 75);
        else {
            UnSpace(Nameval->Value);
            if      (strcmp(Nameval->Name, "Rank") == 0 && !Strength)
                Strength = Nameval->Value;
            else if (strcmp(Nameval->Name, "Player") == 0 && !Name)
                Name = Nameval->Value;
            else if (strcmp(Nameval->Name, "Rating") == 0)
                Strength = Nameval->Value;
        }
    }
    if (!Name || !*Name) {
        Name = "unknown person";
        Warning("Receiving stats for an unknown person. "
                "Probably out of sync\n");
        Person = PlayerFromName(Name);
    } else Person = PlayerFromName(Name);

    if (Strength) {
        title = strchr(Strength, ' ');
        if (title) *title = 0;
        CheckPlayerStrength(Person, Strength);
        if (title) *title = ' ';
    }
    
    if (!GotStats(Person, stats)) {
        Root = MyVaCreateManagedWidget("stats", toplevel, NULL);
        XtVaGetValues(Root,
                      XtNtitle,     (XtArgVal) &title,
                      XtNiconName,  (XtArgVal) &icon,
                      NULL);
        title = PlayerTemplateDescription(Person, title);
        icon  = PlayerTemplateDescription(Person, icon);
        XtVaSetValues(Root,
                      XtNtitle,     (XtArgVal) title,
                      XtNiconName,  (XtArgVal) icon,
                      NULL); 
        myfree(title);
        myfree(icon);

        quit    = XtNameToWidget(Root, "*quit");

        for (Nameval=stats->Next; Nameval != stats; Nameval=Nameval->Next) {
            sprintf(Buffer, "%s: %s", Nameval->Name, Nameval->Value);
            MyVaCreateManagedWidget("info", Root,
                                    XtNlabel, (XtArgVal) Buffer,
                                    NULL);
        }
        /* Code from when idle came from who
          Idle     = PlayerToIdle(Person);
          if (Idle) {
          sprintf(title, "Idle: %s", Idle);
          XtVaCreateManagedWidget(Nameval->Name, labelWidgetClass, Collect,
                                  XtNlabel, (XtArgVal) title, NULL);
          }
          */

        Lines = PlayerToResults(Person);
        if (Lines) {
            Length = 0;
            Line = Lines->Next;
            if (Line != Lines) {
                do {
                    Length += strlen(Line->Name)+1;
                    Line = Line->Next;
                } while (Line != Lines);
                ptr = text = mynews(char, Length);
                WITH_UNWIND {
                    for (Line = Lines->Next; Line != Lines; Line = Line->Next)
                    {
                        Length = strlen(Line->Name);
                        memcpy(ptr, Line->Name, Length);
                        ptr += Length;
                        *ptr++ = '\n';
                    }
                    *--ptr = 0;
                    MyVaCreateManagedWidget("text", Root, "text", text, NULL);
                } ON_UNWIND {
                    myfree(text);
                } END_UNWIND;
            }
        }
        if (quit)
            XtAddCallback(quit, XtNcallback, CallDestroy, (XtPointer) Root);
        MyRealizeWidget(Root);
    }
    FreeNameValList(stats);
}
