/* game.c:
 *	This file should contail all the internal game mechanisms;
 *	things that deal with the way things play, not how the
 *	windows look.
 */
 

#include <stdio.h>
#include <stdlib.h>	/* This SHOULD define lrand48..
			 *	but doesn't for solaris. go figure
			 */
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>

#include "defs.h"
#include "externs.h"
#include "widgets.h"
#include "grades.h"
#include "init.h"
#include "game.h"
#include "convert.h"

TRANSLATION lastpicked=NULL;/* we can't "really" auto-initialize this...
		  * set to zero so we can set it
		  * properly later
		  */
TRANSLATION values[NUMBEROFCHOICES];
int truevalue=0;
int numberincorrect=0;

int choicesmode=GUESS_ENGLISH;
int questionmode=GUESS_KANJI;
int romajiswitch=0;	/* fake kana with romaji? */

Boolean doBell,showinorder;
Boolean useUsefile;
Boolean switchKanaEnglish;


int englishwidth=7;	/* unused? */
int englishheight=11;	/* unused? */

void SetupGuess();

/*
*UseThisKanji()
*	Returns Boolean value on whether this is a "valid" kanji for us,
*	based on usefile markings,
*	current grade set,
*	and whether it has english/kana translation
*/
Boolean UseThisKanji(TRANSLATION kanji)
{

	/*usefile cancels it? */

/* FIX THIS FOR v5 */
/*	if(useUsefile && (useKanji[kanjinum] == 0)) return False;*/
	
	/* nonexistant kanji? */
	if(kanji == NULL) return False;


	/* check against frequency limits */
	if(kanji->frequency==0) {
		/* No frequency means REALLY LOW frequency,
		 * therefore if there's ANY limit, dont use
		 */
		if(lowfrequency != 0)
			return False;
	} else {
		/* "1" is highest frequency!! */
		if(kanji->frequency < highfrequency) return False;
	}

	if(lowfrequency != 0){
		if(kanji->frequency >lowfrequency)
			return False;
	}

	/* does the appropriate form to display exist? */
	if( switchKanaEnglish || (choicesmode != GUESS_KANA)){
		if(kanji->english == NULL)
			return False;
		if(kanji->english[0] == '\0')
			return False;
	}
	if( switchKanaEnglish || (choicesmode == GUESS_KANA)) {
		/* we're supposed to be showing kana.. are there any? */
		if(kanji->pronunciation == NULL)
			return False;
	}

	/* only thing left is to check grade level */
	switch(kanji->grade_level){
		case 1: case 2:
		case 3: case 4:
		case 5: case 6:
			if(gradelevelflags & (1 <<kanji->grade_level) ){
				return True;
			} else {
				return False;				
			}
		default:
			if(gradelevelflags & (1 <<7) ){
				return True;
			} else {
				return False;
			}
	}
}


/* CountKanji
 *This routine gets called a hell of a lot:
 *	When we change grade level, and
 *	when we change kana/english display.
 *	 (the secnd being because kanjidic does not always have
 *	 english and/or kana listings
 *
 *   This counts the number of usable kanji.
 *   It ALSO has to update the "numberincorrect" counter;
 */
void CountKanji(){ 
	TRANSLATION count;
	numberofkanji=0;
	numberincorrect=0;

	count = translations[lowestkanji];
	while(count != NULL){
		if(UseThisKanji(count)){
			numberofkanji++;
			if(count->incorrect >0)
				numberincorrect++;
		}
		count=count->nextk;
	}
}

/* pickkanji:
 *   picks an acceptably random kanji index.
 *	NOTE THAT THIS DEPENDS ON "numberofkanji" being correct!
 */

TRANSLATION pickkanji(){
	int rand_kanji,count;
	

	rand_kanji = lrand48()%numberofkanji;

	for(count=lowestkanji;count<=highestkanji;count++) {
		if(UseThisKanji(translations[count])) {
		      rand_kanji--;
		      if(rand_kanji <0)
			  return translations[count];
		}
	}
	
	fprintf(stderr,"Internal error: picked kanji out of range\n");
	fprintf(stderr,"random pick: %d\n",rand_kanji);
	fprintf(stderr,"number of kanji: %d\n",numberofkanji);
	exit(0);

}

/* pickincorrect:
 *	pick a kanji we have missed previously.
 *	start at first incorect kanji after the last one picked.
 *	This hopefully ensures that we don't replay the same incorrect
 *	one too often.
 */
TRANSLATION pickincorrect()
{
	TRANSLATION currentpick=lastpicked;
	int count;

	if(numberincorrect==0){
		puts("Internal Error.. pickincorrect called when no incorrect stored");
		return pickkanji();
	}
	count = lowestkanji;
	while(translations[count] != lastpicked)
		count++;

	/* Okay, we are now at current display. Search for first incorrect*/
	do {
		/* search for first USABLE.*/
		do {
			count++;
			if(count > highestkanji)
				count = lowestkanji;
			currentpick=translations[count];

		} while(!UseThisKanji(currentpick));
		if(translations[count] == lastpicked)
		{
			setstatus("Internal error picking repeat");
			return lastpicked;
		}

	} while (currentpick->incorrect == 0);

	setstatus("You missed this one before");
	return currentpick;
}

/* picktruevalue()
 *	Similar to pickkanji().
 *	This calls pickkanji() to generate random kanji when
 *	desired. 
 *	Also tries to go back to missed kanji, ONLY when
 *	"random" order is in effect.
 *
 *	Tries to make sure same kanji isn't called in a row.
 *
 *	"lastpicked" is used by the "Back" command, outside this file.
 *	It is also SET somewhere else.
 */
TRANSLATION picktruevalue(){
	int currentpick;
	TRANSLATION ret_val = lastpicked;

	if(!showinorder){
		/* Should we repeat a kanji they missed earlier? */
		/* First check if they have missed any */
		if(numberincorrect>0){
			if(lrand48()%REPEATFRACTION == 0){
				/* go back */
				ret_val = pickincorrect();
			}
			else do {
				ret_val = pickkanji();
			} while (ret_val == lastpicked);
			
		}
		/* This also catches the case where we repeat one
		 * they missed, and it is the current one showing
		 */
		while (ret_val == lastpicked){
			ret_val = pickkanji();
		}

	} else {
	
		/* This is annoying. We have to search through all
		 * kanji to find the "lastpicked" translation.
		 * We then add one, so to speak.
		 */

		ret_val = lastpicked;

		currentpick =lowestkanji;

		while(lastpicked != translations[currentpick])
		{
			currentpick++;
		}
		

		/* okay, add one */

		do {
			currentpick++;
			if(currentpick >highestkanji)
				currentpick = lowestkanji;
		

		} while(!UseThisKanji(translations[currentpick]));

		ret_val = translations[currentpick];
	}
	return ret_val;
} 


/*guessvalue(int)
 *	passed number by EITHER kanji button or english button,
 *	we don't care.
 *	Set status bar to correct/incorrect. Beeps if incorrect
 *	Also sets "incorrect" counter in the translations[].
 *	
*/
/* note that "-1" on guess means "you lose: ran out of time" */

void guessvalue(int guess){
	TRANSLATION kanjiP;

	kanjiP = values[guess];/* for setting "incorrect" flag */

	if(guess == truevalue){
		setstatus("Correct! Now try THIS one...");
		switch(kanjiP->incorrect){
			case 0:
				break;
			case 1:
				numberincorrect -= 1;
			default:
				kanjiP->incorrect -= 1;
		}
		SetupGuess();
		return;
	} 

	/* YOU GOT IT **WWRRROONNGGG!!!!** */
	/* we count off TWICE;
	 *  once for quiz meaning you missed,
	 *  and once for the incorrect kanji you thought it was
	 */
	Beep();
	setstatus("Incorrect.");
	if(guess != -1) {
		if(kanjiP->incorrect ==0)
			numberincorrect+=1;
		kanjiP->incorrect += REPEATTIMES;
		if(kanjiP->incorrect >MAXREPEAT)
			kanjiP->incorrect = MAXREPEAT;
	}

	kanjiP = values[truevalue];
	if(kanjiP->incorrect ==0)
		numberincorrect+=1;
	kanjiP->incorrect += REPEATTIMES;
	if(kanjiP->incorrect >MAXREPEAT)
		kanjiP->incorrect = MAXREPEAT;
	
}


/* printkanji:
 *	Takes widget, and translation struct.
 *	Sets widget label to be kanji string.
 *	Will set font.
 */
void printkanji(Widget w,TRANSLATION knum){

	XtVaSetValues(w,	XtNencoding,XawTextEncodingChar2b,
				XtNfont,largekfont,
				NULL);

	XtVaSetValues(w,	XtNlabel,knum->kanji,
				NULL);
		      

}

/* printenglish
 *	Given widget, and kanji index,
 *	Sets widget label to appropriate english.
 *	Will change fonts to englishfont.
 */
void printenglish(Widget widget,TRANSLATION Tnum)
{

	XtVaSetValues(widget,
		     XtNencoding,XawTextEncoding8bit,
		     XtNfont,englishfont,
		     XtNlabel,Tnum->english,
		     NULL);

}

/* printkana
 *	Given widget, and kanji index,
 *	Sets widget label to kana reading
 *	Will change font to smallkfont
 */

void printkana(Widget widget,TRANSLATION Tnum){
	if(romajiswitch ==1)
	{
		char stringbuff[100];
		/*translate all kana into romaji */
		/* translate to buffer, then set widget string*/
		kanatoromaji(Tnum->pronunciation, stringbuff);
		XtVaSetValues(widget,
		     XtNencoding,XawTextEncoding8bit,
		     XtNfont,englishfont,
		     NULL);
		XtVaSetValues(widget,
		      XtNlabel,stringbuff,
		      NULL);
		
	} else
	{
	/* This needs to be done separately? */
		XtVaSetValues(widget,
		     XtNencoding,XawTextEncodingChar2b,
		     XtNfont,smallkfont,
		     NULL);
		XtVaSetValues(widget,
		      XtNlabel,Tnum->pronunciation,
		      NULL);
	}
}



/* printquestion()
 *	prints out question button, in appropriate font.
 */

void printquestion(){
	switch(questionmode){
		case GUESS_ENGLISH:
			printenglish(questionWidget,values[truevalue]);
			break;
		case GUESS_KANA:
			printkana(questionWidget,values[truevalue]);
			break;
		case GUESS_KANJI:
			printkanji(questionWidget,values[truevalue]);
			break;
		default:
			fprintf(stderr,"Internal Error in kdrill: printallchoices\n");
			exit(0);

	}
}



/* printallchoices()
 *	updates all "choices" labels...
 *	have to handle english, kana, or kanji!
 */
void printallchoices(){
	int i;

	for(i=0;i<NUMBEROFCHOICES;i++){
		UnreverseButton(choicesWidgets[i]);

		switch(choicesmode){
			case GUESS_ENGLISH:
				printenglish(choicesWidgets[i],values[i]);
				break;
			case GUESS_KANA:
				printkana(choicesWidgets[i],values[i]);
				break;
			case GUESS_KANJI:
				printkanji(choicesWidgets[i],values[i]);
				break;
			default:
				fprintf(stderr,"Internal Error in kdrill: printallchoices\n");
				exit(0);

		}
	}
}




/* SetupGuess
 *		"MAIN LOOP" OF PROGRAM
 ******************************************************
 *
 *	sets up question...
 *	
 *	then returns, presumably falling back to XtAppMainLoop()
 *
 */
void SetupGuess()
{
	Boolean doloop;
	int valuecount;

	lastpicked = values[truevalue];

	/* first determine which of the buttons will be the "true" choice */
	truevalue = lrand48() %NUMBEROFCHOICES;

	/* Now randomly assign characters for each choice button */
	for(valuecount=0;valuecount<NUMBEROFCHOICES;valuecount++){
		if(valuecount == truevalue){
			values[valuecount] = picktruevalue();
		} else {
			values[valuecount] = pickkanji();
		}
	}

	/* now weed out duplicates..
	 * This is messy.
	 *  We compare everything to everything else, and change
	 *   the "current" value if there is a conflict...
	 *    UNLESS current value is the "truevalue".
	 *  We then do a full compare again if there was a conflict
	 */
	do{
		int startcount=0;
		doloop = False;
		do {
			if(startcount == truevalue)
				continue;
			for(valuecount=0;valuecount<NUMBEROFCHOICES;valuecount++){
				if(valuecount == startcount)
					continue;
				if(values[startcount]== values[valuecount] ){
					doloop = True;
					values[startcount] = pickkanji();
				}
			}
		} while(++startcount<NUMBEROFCHOICES);

	} while(doloop== True);

	DescribeCurrent(values[truevalue]);

	printquestion();	/* update labels */
	printallchoices(); /* likewise      */
	printgrades();	/* stupid buttons needs updating manually,
			 * EVERY durn time. arrg */

}


