
/* kanasearch.c
 *	Creates and handles the special kana input window.
 *	Also creates and handles the kanji search window.
 *	Both are only a subwindow of the main search window popup.
 */

#include <stdio.h>

#include <Xos.h>
#include <Xfuncs.h>
#include <Intrinsic.h>
#include <StringDefs.h>

#include <Shell.h>

#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Xaw/Box.h>
#include <Xaw/AsciiText.h>

#include "defs.h"
#include "externs.h"

#include "search.h"
#include "convert.h"
#include "game.h"


Widget kanawidgets[NUM_OF_KW];
Widget kanainput_popup;
Widget romajiinput;

Widget kanjiinput_popup;
static Widget kanjiwidgets[14];
static Widget kanjiquarters[4];

static int max_kana=0;


XChar2b std_translations[NUM_OF_KW][2]=
{
	{{0x24, 0x22}, {0x0, 0x0}},	/* a */
	{{0x24, 0x24}, {0x0, 0x0}},
	{{0x24, 0x26}, {0x0, 0x0}},
	{{0x24, 0x28}, {0x0, 0x0}},
	{{0x24, 0x2a}, {0x0, 0x0}},

	{{0x24, 0x2b}, {0x0, 0x0}},	/* ka */
	{{0x24, 0x2d}, {0x0, 0x0}},
	{{0x24, 0x2f}, {0x0, 0x0}},
	{{0x24, 0x31}, {0x0, 0x0}},
	{{0x24, 0x33}, {0x0, 0x0}},

	{{0x24, 0x35}, {0x0, 0x0}},	/* sa */
	{{0x24, 0x37}, {0x0, 0x0}},
	{{0x24, 0x39}, {0x0, 0x0}},
	{{0x24, 0x3b}, {0x0, 0x0}},
	{{0x24, 0x3d}, {0x0, 0x0}},

	{{0x24, 0x3f}, {0x0, 0x0}},	/* ta */
	{{0x24, 0x41}, {0x0, 0x0}},
	{{0x24, 0x44}, {0x0, 0x0}},
	{{0x24, 0x46}, {0x0, 0x0}},
	{{0x24, 0x48}, {0x0, 0x0}},

/*20*/	{{0x24, 0x4a}, {0x0, 0x0}},	/* na */
	{{0x24, 0x4b}, {0x0, 0x0}},
	{{0x24, 0x4c}, {0x0, 0x0}},
	{{0x24, 0x4d}, {0x0, 0x0}},
	{{0x24, 0x4e}, {0x0, 0x0}},

	{{0x24, 0x4f}, {0x0, 0x0}},	/* ha */
	{{0x24, 0x52}, {0x0, 0x0}},
	{{0x24, 0x55}, {0x0, 0x0}},
	{{0x24, 0x58}, {0x0, 0x0}},
	{{0x24, 0x5b}, {0x0, 0x0}},

	{{0x24, 0x5e}, {0x0, 0x0}},	/* ma */
	{{0x24, 0x5f}, {0x0, 0x0}},
	{{0x24, 0x60}, {0x0, 0x0}},
	{{0x24, 0x61}, {0x0, 0x0}},
	{{0x24, 0x62}, {0x0, 0x0}},

	{{0x24, 0x69}, {0x0, 0x0}},	/* ra */
	{{0x24, 0x6a}, {0x0, 0x0}},
	{{0x24, 0x6b}, {0x0, 0x0}},
	{{0x24, 0x6c}, {0x0, 0x0}},
	{{0x24, 0x6d}, {0x0, 0x0}},

	{{0x24, 0x2c}, {0x0, 0x0}},	/* ga */
	{{0x24, 0x2e}, {0x0, 0x0}},
	{{0x24, 0x30}, {0x0, 0x0}},
	{{0x24, 0x32}, {0x0, 0x0}},
	{{0x24, 0x34}, {0x0, 0x0}},

	{{0x24, 0x36}, {0x0, 0x0}},	/* za */
	{{0x24, 0x38}, {0x0, 0x0}},
	{{0x24, 0x3a}, {0x0, 0x0}},
	{{0x24, 0x3c}, {0x0, 0x0}},
	{{0x24, 0x33}, {0x0, 0x0}},

/*50*/	{{0x24, 0x40}, {0x0, 0x0}},	/* da */
	{{0x24, 0x42}, {0x0, 0x0}},
	{{0x24, 0x45}, {0x0, 0x0}},
	{{0x24, 0x47}, {0x0, 0x0}},
	{{0x24, 0x49}, {0x0, 0x0}},

	{{0x24, 0x50}, {0x0, 0x0}},	/* ba */
	{{0x24, 0x53}, {0x0, 0x0}},
	{{0x24, 0x56}, {0x0, 0x0}},
	{{0x24, 0x59}, {0x0, 0x0}},
	{{0x24, 0x5c}, {0x0, 0x0}},

	{{0x24, 0x51}, {0x0, 0x0}},	/* pa */
	{{0x24, 0x54}, {0x0, 0x0}},
	{{0x24, 0x57}, {0x0, 0x0}},
	{{0x24, 0x5a}, {0x0, 0x0}},
	{{0x24, 0x5d}, {0x0, 0x0}},

	/* and now the wierd stuff */
	
/*65*/	{{0x24, 0x64}, {0x0, 0x0}},	/* ya */
	{{0x24, 0x79}, {0x0, 0x0}},	/* blank */
	{{0x24, 0x66}, {0x0, 0x0}},	/* yu */
	{{0x24, 0x79}, {0x0, 0x0}},	/* blank */
	{{0x24, 0x68}, {0x0, 0x0}},	/* yo */

	{{0x24, 0x63}, {0x0, 0x0}},	/* small ya */
	{{0x24, 0x79}, {0x0, 0x0}},	/* blank */
	{{0x24, 0x65}, {0x0, 0x0}},	/* small yu */
	{{0x24, 0x79}, {0x0, 0x0}},	/* blank */
	{{0x24, 0x67}, {0x0, 0x0}},	/* small yo */

	{{0x24, 0x6f}, {0x0, 0x0}},	/* wa */
	{{0x24, 0x6e}, {0x0, 0x0}},	/* small wa */
	{{0x24, 0x43}, {0x0, 0x0}},	/* small tsu */
	{{0x24, 0x73}, {0x0, 0x0}},	/* N */
	{{0x24, 0x72}, {0x0, 0x0}},	/* 'o' */

	

	{{0x22, 0x2b}, {0x0, 0x0}},	/* <- */
	{{0x22, 0x79}, {0x0, 0x0}},	/* paragraph [accept input]*/
					/* match this in process_kinput */
	{{0x0, 0x0}, {0x0, 0x0}},
	{{0x22, 0x4e}, {0x0, 0x0}}	/* kata/hiragana mode toggle */
};

	XChar2b paragraphglyph[2] = { {0x22, 0x79}, {0x0, 0x0} };

static char * romaji_translations[NUM_OF_KW]=
{
	"A",   "I",   "U",   "E",   "O",
	"KA",  "KI",  "KU",  "KE",  "KO",
	"SA",  "SHI", "SU",  "SE",  "SO",
	"TA",  "CHI", "TSU", "TE",  "TO",
	"NA",  "NI",  "NU",  "NE",  "NO",
	"HA",  "HI",  "FU",  "HE",  "HO",
	"MA",  "MI",  "MU",  "ME",  "MO",
	"RA",  "RI",  "RU",  "RE",  "RO",
	"GA",  "GI",  "GU",  "GE",  "GO",
	"ZA",  "ZI",  "ZU",  "ZE",  "ZO",
	"DA",  "DI",  "DU",  "DE",  "DO",
	"BA",  "BI",  "BU",  "BE",  "BO",
	"PA",  "PI",  "PU",  "PE",  "PO",
	"YA",  "",    "YU",  "",    "YO",
	"ya",  "",    "yu",  "",    "yo",
	"WA",  "wa",  "tsu", "N",   "O"
};


/************************************************************/

/*
 * static char *searchAccel = 
 * " <Key>Return:  do-find()";
 */

static kana_up = -1;
static kanji_up = -1;
		/* declares whether popup is up or not */

/* This gets called after clicking on the "Kana search" button.
 * It pops up the kana input window
 */
void Showinputkana(Widget w,XtPointer client_data, XtPointer call_data)
{
	static Position rel_x,rel_y;
	Position x,y;

#ifdef DEBUG
	puts("Showinputkana.. Boom");
#endif

	if(kana_up == -1){
		/* first time init.. */
		/*rel_x = GetXtNumber("kanainput_popupx","Search_popupx");*/
		/*rel_y = GetXtNumber("kanainput_popupy","Search_popupy");*/
		rel_x = 10;
		rel_y = 10;
		
		kana_up = 0;
	}

	if(kana_up == 0)
	{
		XtTranslateCoords(toplevel,rel_x,rel_y,&x,&y);
		XtVaSetValues(kanainput_popup,
		      XtNx,x,
		      XtNy,y,
		      NULL);
		/*XtVaSetValues(searchwidgets[SEARCH_ENG_W],
		*	      XtNstring," Search String Here ",
		*	      NULL);
		*/
		XtPopup(kanainput_popup,XtGrabNone);
		setstatus("Bringing up kana input window...");
		kana_up = 1;
	} else
	{
		XtPopdown(kanainput_popup);
		kana_up = 0;
	}
}


/* This gets called after clicking on the "Kana search" button.
 * It pops up the kana input window
 */
void Showinputkanji(Widget w,XtPointer client_data, XtPointer call_data)
{
	static Position rel_x,rel_y;
	Position x,y;


	if(kanji_up == -1){
		/* first time init.. */
		/*rel_x = GetXtNumber("kanjiinput_popupx","Search_popupx");*/
		/*rel_y = GetXtNumber("kanjiinput_popupy","Search_popupy");*/
		rel_x = 10;
		rel_y = 10;
		
		kanji_up = 0;
	}

	if(kanji_up == 0)
	{
		XtTranslateCoords(toplevel,rel_x,rel_y,&x,&y);
		XtVaSetValues(kanjiinput_popup,
		      XtNx,x,
		      XtNy,y,
		      NULL);
		XtPopup(kanjiinput_popup,XtGrabNone);
		setstatus("Bringing up kanji input window...");
		kanji_up = 1;
	} else
	{
		XtPopdown(kanjiinput_popup);
		kanji_up = 0;
	}
}




/* printkanatable
*	print out kana table, according to current style
*	(standard order, simple order, hiragana/vs/katakana
*/
void printkanatable()
{

	if(kana_up != 1){
		/* pop up window, if it isnt already */
		SearchCallback(NULL,NULL,NULL);
	}

}




void kanacallback(Widget w, XtPointer data, XtPointer call_data)
{
	XChar2b CHAR;

	CHAR.byte1 = ((int) data & 0xff00) >>8;
	CHAR.byte2 = ((int) data & 0x00ff);

#ifdef DEBUG
	puts("Kana input clicked on.");
#endif

	if(((CHAR.byte1 == 0x21) && (CHAR.byte2 == 0x21))
	   || CHAR.byte1 == 0)
	{
#ifdef DEBUG
		printf("Got blank... skipping...");
		printf("%x %x\n", CHAR.byte1, CHAR.byte2);
#endif
		return;
	}
#ifdef DEBUG
	printf("Got data %x\n", data);
#endif
	process_kinput(CHAR);
}

/*
 * ksearch_toggles() sets the labels for the point-n-click popup window
 * 
 * It has to deal with romaji, hiragana, or kanakana
 *
 * If call_data == 1, just listen to romajiswitch( romaji vs kana),
 *   and change all the labels 
 * If call_data == 2, 
 *    actually set global variable to toggle between hiragana and katakana
 *    and go set all the labels.
 *    (or leave as romaji, if romajiswitch)
 */

void ksearch_toggles(Widget w, XtPointer data, XtPointer call_data)
{
	static int popup_hirakana_mode=1;
	char romajibuff[30];
	int kcount;

	if((int)data == 2)
	{
		/* toggle static variable */
		popup_hirakana_mode = 1 - popup_hirakana_mode;

		
		if(romajiswitch ==1)
		{
			/* nothing left to do. Stick with romaji*/
			return;
		}
	}

	/* if data != 2, assume ==1. */


	/* Now romajiswitch and popup_hirakana_mode are set properly.
	 * Interpret them.
	 */

	if(romajiswitch == 1)
	{
		/* if romaji is set, it doesn't matter what the other is */
		for(kcount=0; kcount<80; kcount++)
		{

			kanatoromaji(std_translations[kcount], romajibuff);

		 XtVaSetValues(kanawidgets[kcount],
			       XtNencoding,XawTextEncoding8bit,
			       XtNfont,englishfont,
			       /*  XtNlabel,romaji_translations[kcount],*/
			       XtNlabel, romajibuff,
			       NULL);

		}
		return;
	}
	if(popup_hirakana_mode == 1)
	{
		/* need to switch to hiragana */
		for(kcount=0; kcount<80; kcount++)
		{
			XtVaSetValues(kanawidgets[kcount],
				 XtNlabel, std_translations[kcount],
				 XtNencoding, XawTextEncodingChar2b,
				 XtNfont, smallkfont,
				 NULL);
		}
	} else
	{
		/* bump all the std_translations to katakana */
		XChar2b kstr[2]={{0x25,0},{0,0}};

		for(kcount=0; kcount<80; kcount++)
		{
			kstr[0].byte2 = std_translations[kcount][0].byte2;

			XtVaSetValues(kanawidgets[kcount],
				 XtNlabel, kstr,
				 XtNencoding, XawTextEncodingChar2b,
				 XtNfont, smallkfont,
				 NULL);
		}
	}
}


/*************************************************************
 *    Widget Creation Below Here                             *
 *************************************************************/

/* Thisis for the kana input window */
void makeinputwidgets(Widget parent)
{

	max_kana=0;

	while((std_translations[max_kana][0].byte1 != 0x00))
	{
		char namestr[10];
		int kvalue;

		sprintf(namestr, "%d", max_kana);
		kanawidgets[max_kana] =
			XtVaCreateWidget(namestr,
				 commandWidgetClass,
				 parent,
				 XtNlabel, std_translations[max_kana],
				 XtNencoding, XawTextEncodingChar2b,
				 XtNfont, smallkfont,
				 NULL);
		if(max_kana>4)
		{
			XtVaSetValues(kanawidgets[max_kana],
				      XtNfromVert, kanawidgets[max_kana - 5],
				      NULL);
		}
		if(max_kana%5 >0)
		{
			XtVaSetValues(kanawidgets[max_kana],
				      XtNfromHoriz, kanawidgets[max_kana - 1],
				      NULL);
		}

		kvalue = (std_translations[max_kana][0].byte1 <<8) +
				std_translations[max_kana][0].byte2;
		XtAddCallback(kanawidgets[max_kana],
			      XtNcallback, kanacallback,
			      (XtPointer) kvalue);
		max_kana++;
	}

	/*std_translations[max_kana] now points to 0x00,0x00*/
	XtManageChildren(kanawidgets, max_kana);

	/* create the kana/hiragana toggle */
	kanawidgets[max_kana+1] =
		XtVaCreateManagedWidget("kanahiratoggle", commandWidgetClass,
					parent,
					XtNlabel, std_translations[max_kana+1],
					XtNencoding, XawTextEncodingChar2b,
					XtNfont, smallkfont,
					XtNfromHoriz, kanawidgets[max_kana-1],
					XtNfromVert, kanawidgets[max_kana-5],
					XtNhorizDistance,40,
					NULL);
					
	XtAddCallback(kanawidgets[max_kana+1],
		      XtNcallback, ksearch_toggles,
		      (XtPointer) 2);
	
	romajiinput = XtVaCreateManagedWidget("romajiinput", labelWidgetClass,
			parent,
			XtNlabel, "",
			XtNwidth, 150,
			XtNfromVert, kanawidgets[max_kana-1],
			XtNencoding, XawTextEncodingChar2b,
			XtNfont, smallkfont,
			NULL);
	/* make this a duplicate of the searchwidgets[SEARCH_KANA_W],
	 * so user can see output of point-n-click on same window.
	 * (or, user can even input romaji on that window!)
	 */
	XtAddEventHandler(romajiinput,
			  KeyPressMask,False,
			  Handle_romajikana,NULL);
	

}
static int quarter_up=-1;
XChar2b quarterchars[11][2] =
{
	{{0x28, 0x35}, {0, 0}},
	{{0x28, 0x2c}, {0, 0}},
	{{0x28, 0x2d}, {0, 0}},
	{{0x21, 0x33}, {0, 0}},
	{{0x28, 0x36}, {0, 0}},
	{{0x25, 0x2d}, {0, 0}},
	{{0x25, 0x6d}, {0, 0}},
	{{0x28, 0x2e}, {0, 0}}, /*angle (needs replacement) */
	{{0x25, 0x4f}, {0, 0}},
	{{0x3e, 0x2e}, {0, 0}}, /*chisai*/
	{{0x21, 0x21}, {0, 0}}, /*fake zero*/
};

/* select a particular quarter for the "four corners" search method */
/* mark our internal counter, plus make that one "selected" */
static void selectquarter(Widget w, XtPointer data, XtPointer call_data)
{
	int num;
	int kcount;

	num = (int)data;
	
	for(kcount=0; kcount<4; kcount++)
	{
		if(num == kcount)
			XtSetSensitive(kanjiquarters[kcount], False);
		else
			XtSetSensitive(kanjiquarters[kcount], True);
	}
	quarter_up = num;
	
}

/* change the active quarter for the "four corners" method, to
 * the symbol just clicked on
 */
void changequarter(Widget w, XtPointer data, XtPointer call_data)
{
	if(quarter_up == -1)
	{
		puts("internal error: changequarter called with no quarter valid");
		return;
	}
	XtVaSetValues(kanjiquarters[quarter_up],
		      XtNlabel, quarterchars[(int)data],
		      NULL);
}

/* we have to go indirectly to "dokanjifind" because
 * we first have to gather the "four corner" information from the
 * widgets, and put it into a single number
 */
void DoKanjiFind(Widget w, XtPointer data, XtPointer call_data)
{
	int kcount, cornercount;
	XChar2b *labelval;
	int searchnumber = 0;

	for(cornercount=0; cornercount<4; cornercount++)
	{
		XtVaGetValues(kanjiquarters[cornercount],
			      XtNlabel, &labelval,
			      NULL);
		
		for(kcount=0; kcount<=10; kcount++)
		{
			if(bcmp(labelval, quarterchars[kcount],2) == 0)
				break;
		}
		if(kcount> 10)
		{
			fprintf(stderr, "ERROR! impossible overrun for DoKanjiFind\n");
			exit(1);
		}
		/* for fake "zero" */
		if(kcount==10)
			kcount=0;

		switch(cornercount)
		{
			case 0:
				searchnumber = kcount * 1000;
				break;
			case 1:
				searchnumber += kcount * 100;
				break;
			case 2:
				searchnumber += kcount * 10;
				break;
			case 3:
				searchnumber += kcount ;
				break;
		}
	}
#ifdef DEBUG
	printf("searching for Q value %d\n", searchnumber);
#endif
	dokanjifind(searchnumber);
}


/* try to make the skip input widgets */
void makeskipinput(Widget parent)
{
	Widget category[4];
	XChar2b cat_string[4][2]=
	{
		{{0x21, 0x43}, {0,0}},
		{{0x21, 0x3d}, {0,0}},
		{{0x22, 0x22}, {0,0}},
		{{0x22, 0x23}, {0,0}},
	};
	
	Widget SKIPnumberinput[3];

	Widget SKIPdirections;
	Widget clear, search;

	int wcount;

	category[0]=
		XtVaCreateWidget("1", commandWidgetClass, parent,
		     XtNencoding, XawTextEncodingChar2b,
		     XtNfont, largekfont,
		     XtNlabel, cat_string[0],
		     NULL);
	category[1]=
		XtVaCreateWidget("2", commandWidgetClass, parent,
		     XtNencoding, XawTextEncodingChar2b,
		     XtNfont, largekfont,
		     XtNlabel, cat_string[0],
		     XtNfromHoriz, category[0],
		     NULL);
	category[2]=
		XtVaCreateWidget("3", commandWidgetClass, parent,
		     XtNencoding, XawTextEncodingChar2b,
		     XtNfont, largekfont,
		     XtNlabel, cat_string[0],
		     XtNfromHoriz, category[1],
		     NULL);
	category[3]=
		XtVaCreateWidget("4", commandWidgetClass, parent,
		     XtNencoding, XawTextEncodingChar2b,
		     XtNfont, largekfont,
		     XtNlabel, cat_string[2],
		     NULL);

	SKIPnumberinput[0] =
		XtVaCreateWidget("5", asciiTextWidgetClass, parent,
		     XtNfromVert, category[0],
		     XtNlabel, "",
		     NULL);
	SKIPnumberinput[1] =
		XtVaCreateWidget("6", asciiTextWidgetClass, parent,
		     XtNfromVert, category[0],
		     XtNfromHoriz, SKIPnumberinput[1],
		     XtNlabel, "",
		     NULL);
	SKIPnumberinput[2] =
		XtVaCreateWidget("7", asciiTextWidgetClass, parent,
		     XtNfromVert, category[0],
		     XtNfromHoriz, SKIPnumberinput[2],
		     XtNlabel, "",
		     NULL);

	XtManageChildren(category, 4);
	XtManageChildren(SKIPnumberinput, 3);

	SKIPdirections = XtVaCreateManagedWidget(
			"directions", labelWidgetClass, parent,
			XtNfromVert, SKIPnumberinput[0],
			NULL);
	clear = XtVaCreateManagedWidget(
			"clear", commandWidgetClass, parent,
			XtNfromVert, SKIPdirections,
			NULL);
	search = XtVaCreateManagedWidget(
			"search", commandWidgetClass, parent,
			XtNfromVert, SKIPdirections,
			NULL);
}


/* make the widgets for the "four quarter" kanji search method */
void makekanjiinput(Widget parent)
{
	int kcount;
	Widget displaything;
	Widget search;

	for (kcount=0; kcount<11; kcount++)
	{
		char namestr[10];
		sprintf(namestr, "%d", kcount);
		kanjiwidgets[kcount] =
			XtVaCreateWidget(namestr,
				commandWidgetClass,
				parent,
				XtNlabel, quarterchars[kcount],
				XtNencoding, XawTextEncodingChar2b,
				XtNfont, smallkfont,
				NULL);
		if((kcount>0) && (kcount <10))
		{
			XtVaSetValues(kanjiwidgets[kcount],
				      XtNfromHoriz,
				      kanjiwidgets[kcount-1],
				      NULL);
		}
		XtAddCallback(kanjiwidgets[kcount],
			      XtNcallback, changequarter,
			      (XtPointer) kcount);
	}

	XtVaSetValues(kanjiwidgets[10],
			      XtNfromVert,
			      kanjiwidgets[0],
			      NULL);

	displaything =
		XtVaCreateManagedWidget("displayfourkanji", formWidgetClass,
				parent,
				XtNfromVert, kanjiwidgets[0],
				XtNfromVert, kanjiwidgets[9],
				XtNfromHoriz, kanjiwidgets[3],
				XtNvertDistance, 20,
				NULL);
	kanjiquarters[0] = XtVaCreateWidget("upleft", commandWidgetClass,
				displaything, XtNlabel, quarterchars[0],
				XtNencoding, XawTextEncodingChar2b,
				XtNfont, smallkfont, NULL);
	kanjiquarters[1] = XtVaCreateWidget("upright", commandWidgetClass,
				displaything, XtNlabel, quarterchars[0],
				XtNencoding, XawTextEncodingChar2b,
				XtNfromHoriz, kanjiquarters[0],
				XtNfont, smallkfont, NULL);
	kanjiquarters[2] = XtVaCreateWidget("downleft", commandWidgetClass,
				displaything, XtNlabel, quarterchars[0],
				XtNencoding, XawTextEncodingChar2b,
				XtNfromVert, kanjiquarters[0],
				XtNfont, smallkfont, NULL);
	kanjiquarters[3] = XtVaCreateWidget("downright", commandWidgetClass,
				displaything, XtNlabel, quarterchars[0],
				XtNencoding, XawTextEncodingChar2b,
				XtNfromVert, kanjiquarters[0],
				XtNfromHoriz, kanjiquarters[2],
				XtNfont, smallkfont, NULL);

	search = XtVaCreateManagedWidget("dosearch", commandWidgetClass,
				parent,
				XtNencoding, XawTextEncodingChar2b,
				XtNfont, smallkfont,
				XtNfromVert, displaything,
				XtNfromVert, kanjiwidgets[9],
				XtNvertDistance, 30,
				XtNfromHoriz, kanjiwidgets[7],
				XtNlabel, paragraphglyph,
				NULL);
				  
	XtManageChildren(kanjiwidgets, 11);
	XtManageChildren(kanjiquarters, 4);
	

	for(kcount=0; kcount<4; kcount++)
	{
		XtAddCallback(kanjiquarters[kcount],
			      XtNcallback, selectquarter,
			      (XtPointer) kcount);
	}
	XtAddCallback(search, XtNcallback, DoKanjiFind, (XtPointer) NULL);

}


/* This is an exported "make widgets" routine */

void MakeKanainputPopup()
{
	Widget kanainputform;
	/*  XtAccelerators Accel; */

	kanainput_popup = XtVaCreatePopupShell("kdrill_kanainput",
		transientShellWidgetClass,
		toplevel,
		NULL);

	kanainputform = XtVaCreateManagedWidget("kanainputform",
					     formWidgetClass,
					     kanainput_popup,
					     NULL);

	makeinputwidgets(kanainputform);

	XtManageChildren(kanawidgets, max_kana);


	/*Accel = XtParseAcceleratorTable(searchAccel);*/
	/*XtOverrideTranslations(kanainputform, Accel);*/


}

/* exported routine */
void MakeKanjiinputPopup()
{
	Widget kanjiinputform;

	kanjiinput_popup = XtVaCreatePopupShell("kdrill_kanjisearch ",
		transientShellWidgetClass,
		toplevel,
		NULL);

	kanjiinputform = XtVaCreateManagedWidget("kanjiinputform",
					     formWidgetClass,
					     kanjiinput_popup,
					     NULL);

	/* make the 10 input things, plus 4 display things */ 
	makekanjiinput(kanjiinputform);
	/* and now set the correct buttons to initially be sensitive */
	selectquarter(NULL, 0, NULL);



}
