
#include <stdio.h>
#include <stdlib.h>

#include <Xlib.h>
#include <Xatom.h>
#include <Xutil.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Composite.h>

#include "defs.h"
#include "externs.h"
#include "init.h"
#include "readfile.h"
#include "game.h"
#include "grades.h"

#include "patchlevel.h"

static char *version = VERSION;

Display *display;
int screen;
Window mainwindow,rootwindow;
GC gc,cleargc;
XtAppContext Context;

XChar2b *kstring;
XChar2b onecharstring;

unsigned long white,black;




/* REAL  OS's don't need this. 
 * But because I'm such a nice guy, and recognise that there
 * are screwey OS's out there...
 */
void clean_up_structs(){
	int i;
	for(i=lowestkanji; i<=highestkanji;i++){
		struct translationstruct *T;
		if(translations[i] == NULL)
			continue;
		T = translations[i];

		if(T->english != NULL)
			free(T->english);
		/* for some reason, 0 is better than NULL */
		if(T->pronunciation != 0) 
			free (T->pronunciation);
#ifdef USE_OKU
		if(T->ON_extra != 0)
			free(T->pronunciation);
#endif
	}
}

/* quitbutton, of course */
void quit(Widget w,XtPointer data,XtPointer calldata)
{
#ifdef DEBUG
	puts("quitting?");
#endif
	XtCloseDisplay(display);
#ifdef OLDLOG
	if(logfile != NULL)
		fclose(logfile);
#endif
	/* I supose we'll be nice an' clean up memory somewhat.. */
	clean_up_structs();
	exit(0);
}


void usage(){
	printf(" kdrill    --  %s\n",version);
	fflush(stdout);
	puts("A program to drill on kanji to english, or vica versa");
	puts("");
	puts("Options:");
	puts("  -usefile usefilename         Changes abridgement file of dictionary");
	puts("  -nousefile                   Do not abridge initially");
	puts("  -kdictfile dictfilename       Changes kanji dictionary file from");
	puts("                               \"kanjidic\" to some other file");
	puts("  -edictfile dictfilename       Changes phrase dictionary file from");
	puts("                               \"edict\" to some other file");
	puts("  -englishfont fontname        Changes english button font");
	puts("  -kanjifont Kanjifontname     Changes LARGE kanji font");
	puts("  -smallkanji Kanjifontname    Changes small kanji font");
	puts("  -noBell                      Turns off beep for incorrect answer");
	puts("  -guessmeaning                Starts off with four kanji to one meaning");
	puts("  -notallT                     Allow non-complete dictionary entries.");
	puts("                                  warning: consult man-page.");
	puts("  -showkana                    Start showing kana meanings instead of english");
	puts("  -romajiswitch                Show kana meanings in romaji instead of kana");
	puts("  -showinorder                 Go through kanji in order of #, NOT randomly");
	puts("  -gradelevel                  Define while grades should be used.");
	puts("                                use any or all of \"123456+\"");
	puts("   -lowfrequency               Lowest frequency kanji you wish to see.");
	puts("   -highfrequency              Highest frequency kanji you wish to see");
	puts("                  (\"1\" is HIGH, \"2000\" is low)");
	puts("   -logfile filename           Set logfile to non-standard name");
	puts("");
	puts("       The above options can also be set as resources,");
	puts("       with the same name as their optionflag");
	puts("");
	exit(0);
}


/* GetXtNumber(), GetXtBoolean(), GetXtString():
 *	Not the "best way" to get resources...
 *	supposed to read them all in at one go.
 *	But I had reasons for reading things in at different times,
 *	and I have stuck to that model
 */

/* GetXtString:
 *	Given the resource name and class, will
 *	 copy the resource string value to
 *	 destinationstring address.
 *	Destination must be MALLOCED ARRAY!!!
 *
 *	Default value of string is "NOT SET".
 *	This is used by initlog() [which is not used any more]
 *	This should actually be encountered. I provide default values for
 *	all resource strings used.
 */
void GetXtString(char *name,char *rec_class, char *destinationstring)
{
	char resourcename[100],resourceclass[100];
	char buffer[100];
	char *returnstring = buffer;
	

	XtResource resourceList ={
		NULL,NULL,
		XtRString,sizeof(char *),0,
		XtRString,"NOT SET"
	};
	resourceList.resource_name = resourcename;
	resourceList.resource_class = resourceclass;

	strcpy(resourcename,name);
	strcpy(resourceclass,rec_class);

	XtGetApplicationResources(toplevel,&returnstring,
				  &resourceList,1,
				  NULL,0);
	strcpy(destinationstring,returnstring);
}

/* GetXtNumber:
 *	Given resource name and and class, will attempt to look up
 *	resource value in database.
 *	Will return default of 0!!!
 */
int GetXtNumber(char *name,char *rec_class)
{
	char resourcevalue[100];

	GetXtString(name,rec_class,resourcevalue);
	return atoi(resourcevalue);
}
/* GetXtBoolean()
 *	see GetXtNumber.
 *
 *	default of False
 */
Boolean GetXtBoolean(char *name,char *rec_class)
{
	Boolean resourcevalue;
	char resourcename[100],resourceclass[100];

	XtResource resourceList ={
		NULL,NULL,
		XtRBoolean,sizeof(Boolean),0,
		XtRBoolean,False,
	};
	resourceList.resource_name = resourcename;
	resourceList.resource_class = resourceclass;

	strcpy(resourcename,name);
	strcpy(resourceclass,rec_class);

	XtGetApplicationResources(toplevel,&resourcevalue,
				  &resourceList,1,
				  NULL,0);
	return resourcevalue;
}

/* debugging routine.
 * Prints out ALL english phrases loaded into memory.
 * Note: This can be many thousands of lines!!!
 */
void dumpenglish()
{
	struct translationstruct *parse;

	parse = translations[lowestkanji];

	while(parse != NULL)
	{
		if(parse->english == NULL)
		{
			printf("NULL english\n");
		} else
		{
			printf("English: %s\n", parse->english);
		}
		parse = parse->nextk;
	}
}


/*
 * Welcome, Welcome, Welcome!
 */
int main(int argc,char *argv[])
{
	puts("kdrill: Starting up... please wait a while.");
	fflush(stdout);

	/* Widgets get made down in initstuffs()... */
	/* also, resources get called */
	initstuffs(&argc,argv);

 /*	ReverseButton(form);*/


	/* check for abridgements of the dictionary... */
	initusefile();
	/* and actually read in structs of kanjidic dictionary */
	readstructs();
	/* now try for 'edict' dictionary as well */
	readedict();

	/*dumpenglish();*/
	
	initlog(); /* old way or new way: same name */

	if( GetXtBoolean("showkana","Showkana"))
		choicesmode = GUESS_KANA;
	if( GetXtBoolean("romajiswitch","Romajiswitch"))
		romajiswitch = 1;
	CountKanji();
	if(numberofkanji<HAVE_AT_LEAST){
		fprintf(stderr,"There are two few kanji readable in the current configuration\n");
		fprintf(stderr,"Please either reconfigure your usefile, raise the grade level,\n");
		fprintf(stderr,"  or check your dictionary file,\n");
		exit(0);
	}

	
	SetupGuess();
	XtAppMainLoop(Context);
	return 0;
}
