
/* options.c
 *   Handles the options window popup
 *   This handles the meat of the optiosn popup stuff
 */

#include <stdio.h>

#include <Xos.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Shell.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Xaw/AsciiText.h>

#include "defs.h"
#include "externs.h"
#include "game.h"
#include "grades.h"
#include "search.h"

Widget orderbutton,usefilebutton;
Widget kanjimode,englishmode,kanamode;


Widget options_popup;
Widget optionsform;
Widget frequencyForm,gradelevelForm;

/* Assume "True" == 1 !! */
char * orderlabel[2] = {
	"Showing randomly",
	"Showing in order",
};
char * romajilabel[2] = {
	"Kana/Romaji     ",
	"Romaji/Kana     ",
};

char * usefilelabel[2] = {
	"No    Usefile",
	"Using Usefile",
};

void ordercallback(Widget w,XtPointer data,XtPointer calldata)
{
	   showinorder = !showinorder;
	   XtVaSetValues(w,XtNlabel,orderlabel[(int) showinorder],NULL);
	   switch(showinorder){
		case 0:
			setstatus("Will now select kanji randomly");
			break;
		case 1:
			setstatus("Will now go through kanji in order of #");
			break;

	   }
	   return;
}
		   
void usefilecallback(Widget w,XtPointer data,XtPointer calldata)
{
	char statbuff[300];
	   switch(useUsefile){
		case 1:
			useUsefile = 0;
			if(usefile != NULL)
				setstatus("Will now ignore usefile");
			break;
		case 0:
			if(usefile == NULL){
				setstatus("No usefile to use");
				break;
			}
			useUsefile = 1;
			sprintf(statbuff,"now using usefile %s",
				usefile);
			setstatus(statbuff);
			break;
	   }
	XtVaSetValues(w,XtNlabel,usefilelabel[(int) useUsefile],NULL);
	CountKanji();
	return;
}

/* Switch between showing true kana, and romaji.
 *  We then have to go and reset all the appropriate button labels. sigh.
 *  (In the MAIN window. Plus possibly other places...)
 */
void romajicallback(Widget w,XtPointer data,XtPointer calldata)
{
	switch(romajiswitch){
		case 1:
			romajiswitch = 0;
			setstatus("Will now print kana");
			break;
		case 0:
			romajiswitch = 1;
			setstatus("Will now print romaji");
			break;
	}
	XtVaSetValues(w,XtNlabel,romajilabel[(int)romajiswitch],NULL);
	printallchoices();
	ksearch_toggles(w, (XtPointer)NULL, (XtPointer)1);
	return;
}
		   
/* This gets called after clicking on the "options" button,
 * or with the "o" keyboard accelerator (but not directly, with
 * the keyboard accelerator)
 */
void OptionsCallback(Widget w,XtPointer client_data, XtPointer call_data)
{
	static up = -1;
	static Position rel_x,rel_y;
	Position x,y;

	if(up == -1){
		/* first time init.. */
		rel_x = GetXtNumber("options_popupx","Options_popupx");
		rel_y = GetXtNumber("options_popupy","Options_popupy");
		up = 0;
	}

	if(up == 0)
	{
		XtTranslateCoords(toplevel,rel_x,rel_y,&x,&y);
		XtVaSetValues(options_popup,
		      XtNx,x,
		      XtNy,y,
		      NULL);
		XtPopup(options_popup,XtGrabNone);
		setstatus("Bringing up options window...");
		up = 1;
	} else
	{
		XtPopdown(options_popup);
		up = 0;
	}
}

static char * freqAccel = 
 " <Key>Return:  update-frequency()";


/* MakeFrequency:
 *  make specialised "dialog box" that takes
 *  two input values, with labels next to each input area, and
 *  one make dialog label
 */
void MakeFrequency(Widget parent){
	Widget mainlabel,highlabel,lowlabel;
	XtAccelerators Accel;
	char highvalue[10] = "";
	char lowvalue[10] = "";

	
	
	if(lowfrequency !=0)
		sprintf(lowvalue,"%d",lowfrequency);
	if(highfrequency !=0)
		sprintf(highvalue,"%d",highfrequency);

	mainlabel = XtVaCreateManagedWidget("freqLabel",labelWidgetClass,parent,
			XtNlabel,"        Frequency Range",
			XtNborderWidth,0,
			NULL);

	highlabel = XtVaCreateManagedWidget(
			"freqhighLabel",labelWidgetClass,parent,
			XtNlabel,"High:",
			XtNfromVert,mainlabel,
			XtNborderWidth,0,
			NULL);
	frequencyHigh = XtVaCreateManagedWidget(
			"freqHigh",asciiTextWidgetClass,parent,
			XtNfromVert,mainlabel,
			XtNfromHoriz,highlabel,
			XtNeditType,XawtextEdit,
			XtNwidth,45,
			XtNstring,highvalue,
			NULL);
	lowlabel = XtVaCreateManagedWidget(
			"freqlowLabel",labelWidgetClass,parent,
			XtNlabel,"Low:",
			XtNfromVert,mainlabel,
			XtNfromHoriz,frequencyHigh,
			XtNborderWidth,0,
			NULL);
	frequencyLow = XtVaCreateManagedWidget(
			"freqLow",asciiTextWidgetClass,parent,
			XtNfromVert,mainlabel,
			XtNfromHoriz,lowlabel,
			XtNeditType,XawtextEdit,
			XtNwidth,50,
			XtNstring,lowvalue,
			NULL);

	Accel = XtParseAcceleratorTable(freqAccel);
	XtOverrideTranslations(frequencyHigh,Accel);
	XtOverrideTranslations(frequencyLow,Accel);
}




/* MakeGradeSelect()
 *	create buttons to select grades 1-6, plus "all" and "+"  buttons
 */
void MakeGradeSelect(Widget parent){
	Widget gradelevelLabel;
	
	int widgetcount;

	gradelevelLabel = XtVaCreateManagedWidget(
			"gradelabel",labelWidgetClass,parent,
			XtNlabel,"        Grade Select",XtNborderWidth,0,
			NULL);

	gradeButtons[1] = XtVaCreateWidget("grade1",commandWidgetClass,parent,
			 XtNlabel,"1",
			 XtNfromVert,gradelevelLabel,NULL);

	gradeButtons[2] = XtVaCreateWidget("grade2",commandWidgetClass,parent,
			 XtNlabel,"2",XtNfromHoriz,gradeButtons[1],
			 XtNfromVert,gradelevelLabel,NULL);
	gradeButtons[3] = XtVaCreateWidget("grade3",commandWidgetClass,parent,
			 XtNlabel,"3",XtNfromHoriz,gradeButtons[2],
			 XtNfromVert,gradelevelLabel,NULL);
	gradeButtons[4] = XtVaCreateWidget("grade4",commandWidgetClass,parent,
			 XtNlabel,"4",XtNfromHoriz,gradeButtons[3],
			 XtNfromVert,gradelevelLabel,NULL);
	gradeButtons[5] = XtVaCreateWidget("grade5",commandWidgetClass,parent,
			 XtNlabel,"5",XtNfromHoriz,gradeButtons[4],
			 XtNfromVert,gradelevelLabel,NULL);
	gradeButtons[6] = XtVaCreateWidget("grade6",commandWidgetClass,parent,
			 XtNlabel,"6",XtNfromHoriz,gradeButtons[5],
			 XtNfromVert,gradelevelLabel,NULL);
	gradeButtons[7] = XtVaCreateWidget("grade+",commandWidgetClass,parent,
			 XtNlabel,"+",XtNfromHoriz,gradeButtons[6],
			 XtNfromVert,gradelevelLabel,NULL);

	gradeButtons[0] = XtVaCreateWidget("allgrades",commandWidgetClass,parent,
			  XtNlabel," All ", XtNfromHoriz,gradeButtons[7],
			  XtNfromVert,gradelevelLabel,NULL);

	XtManageChildren(gradeButtons,8);

	for(widgetcount=0;widgetcount<8;widgetcount++){
		XtAddCallback(gradeButtons[widgetcount],XtNcallback,GradeCallback,(XtPointer) widgetcount);
	}
	/* select ALL.. */
	
}


void changequestion(Widget w,XtPointer data,XtPointer calldata)
{
	int buttonpressed = (int) data;

#ifdef DEBUG
	printf("changing question display\n");
#endif
	questionmode = buttonpressed;
	printquestion();
}

void MakeOptionsPopup()
{
	Widget q[3], romajibutton;
	extern XtAccelerators AllAccel;


	options_popup = XtVaCreatePopupShell("kdrill_options",
		transientShellWidgetClass,
		toplevel,
		NULL);

	optionsform = XtVaCreateManagedWidget("optionsform",
					      formWidgetClass,
					      options_popup,
					      NULL);



	q[0] = XtVaCreateManagedWidget(
			"q0",commandWidgetClass, optionsform,
			XtNlabel,"Show kanji",
			XtNvertDistance,8,
			XtNshapeStyle,XawShapeOval,
			XtNwidth,BUTTONSWIDTH,
			NULL);
	q[1] = XtVaCreateManagedWidget(
			"q1",commandWidgetClass, optionsform,
			XtNlabel,"Show English",
			XtNshapeStyle,XawShapeOval,
			XtNfromVert,q[0],
			XtNwidth,BUTTONSWIDTH,
			NULL);
	q[2] = XtVaCreateManagedWidget(
			"q2",commandWidgetClass, optionsform,
			XtNlabel,"Show meaning",
			XtNshapeStyle,XawShapeOval,
			XtNfromVert,q[1],
			XtNwidth,BUTTONSWIDTH,
			NULL);





	kanjimode = XtVaCreateManagedWidget(
			"kanjimode",commandWidgetClass, optionsform,
			XtNlabel,"Guess kanji",
			XtNvertDistance,8,
			XtNfromHoriz,q[0],
			XtNshapeStyle,XawShapeOval,
			XtNwidth,BUTTONSWIDTH,
			NULL);

	englishmode = XtVaCreateManagedWidget(
			"englishmode",commandWidgetClass, optionsform,
			XtNlabel,"Guess English",
			XtNfromVert,kanjimode,
			XtNfromHoriz,q[0],
			XtNshapeStyle,XawShapeOval,
			XtNwidth,BUTTONSWIDTH,
			NULL);

	kanamode = XtVaCreateManagedWidget(
			"kana",commandWidgetClass,optionsform,
			XtNlabel,"Guess meaning",
			XtNshapeStyle,XawShapeOval,
			XtNfromVert,englishmode,
			XtNfromHoriz,q[0],
			XtNwidth,BUTTONSWIDTH,
			NULL);



	orderbutton = XtVaCreateManagedWidget("order",commandWidgetClass,optionsform,
			XtNlabel,orderlabel[(int) showinorder],
			XtNvertDistance,8,
			XtNfromVert,kanamode,
			XtNwidth,BUTTONSWIDTH,
			NULL);
	usefilebutton = XtVaCreateManagedWidget("usefile",commandWidgetClass,optionsform,
			XtNlabel,usefilelabel[(int) useUsefile],
			XtNvertDistance,8,
			XtNfromHoriz,orderbutton,
			XtNfromVert,kanamode,
			XtNwidth,BUTTONSWIDTH,
			NULL);

	romajibutton = XtVaCreateManagedWidget("romaji",commandWidgetClass,optionsform,
			XtNlabel,romajilabel[(int) romajiswitch],
			XtNfromVert,orderbutton,
			XtNwidth,BUTTONSWIDTH,
			NULL);


	gradelevelForm = XtVaCreateManagedWidget(
			"gradeForm",formWidgetClass,optionsform,
			XtNhorizDistance,GRADEDISTANCE,
			XtNvertDistance,10,
			XtNfromHoriz,usefilebutton,
			XtNfromHoriz,kanamode,
			XtNfromHoriz,englishmode,
			XtNfromHoriz,usefilebutton,
			NULL);

	MakeGradeSelect(gradelevelForm);

	frequencyForm = XtVaCreateManagedWidget(
			"freqForm",formWidgetClass,optionsform,
			XtNhorizDistance,GRADEDISTANCE,
			XtNvertDistance,10,
			XtNfromHoriz,usefilebutton,
			XtNfromHoriz,kanamode,
			XtNfromHoriz,englishmode,
			XtNfromVert,gradelevelForm,
			NULL);

	MakeFrequency(frequencyForm);

	XtAddCallback(q[0],XtNcallback,changequestion,(XtPointer) GUESS_KANJI);
	XtAddCallback(q[1],XtNcallback,changequestion,(XtPointer) GUESS_ENGLISH);
	XtAddCallback(q[2],XtNcallback,changequestion,(XtPointer) GUESS_KANA);

	XtAddCallback(kanjimode,XtNcallback,ChangeMode,(XtPointer) GUESS_KANJI);
	XtAddCallback(englishmode,XtNcallback,ChangeMode,(XtPointer) GUESS_ENGLISH);
	XtAddCallback(kanamode,XtNcallback,ChangeMode,(XtPointer) GUESS_KANA);
	XtAddCallback(orderbutton,XtNcallback,ordercallback,NULL);
	XtAddCallback(usefilebutton,XtNcallback,usefilecallback,NULL);
	XtAddCallback(romajibutton,XtNcallback,romajicallback,NULL);

	XtAugmentTranslations(options_popup,AllAccel);
	XtSetKeyboardFocus(options_popup,toplevel);
}
