#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <time.h>
#include <stdlib.h>
#include <netdb.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <math.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "messages.h"
#include "creation.h"
#include "game.h"

typedef struct {
  char mesg[MESSAGE_BUF];
  int from_who;
} MesgStruct;

#define SABLIER_L 40
#define SABLIER_H 300
#define NB_DAMIERS 3
int Max_Queues;  /* mis a jour par ReceiveQueueValues() */
int QueueWait[MAX_QUEUES], QueueGood[MAX_QUEUES];

Parameters c_params;

double ALPHA=1.0;
double LONG=450;
double DIST=150;
double COS_ALPHA[NB_DAMIERS], SIN_ALPHA[NB_DAMIERS];
#define ECART_ALPHA 0.1
#define LEFT_BORDER 50
int tcase; /* LONG/SIZE_X */

#define _0_KEY	48
#define _1_KEY	49
#define _2_KEY	50
#define _3_KEY	51
#define _4_KEY	52
#define _5_KEY	53
#define _6_KEY	54
#define _7_KEY	55
#define _8_KEY	56
#define _9_KEY	57
#define U_KEY		117
#define V_KEY		118
#define J_KEY		106
#define O_KEY		111
#define P_KEY		112
#define FLECHE_H	U_KEY
#define FLECHE_D	P_KEY
#define FLECHE_B 	J_KEY
#define FLECHE_G	O_KEY
#define A_KEY 		97
#define C_KEY 		99
#define T_KEY 		116
#define F_KEY		102
#define H_KEY 		104
#define M_KEY		109
#define N_KEY		110
#define Q_KEY		113
#define BigQ_KEY	81		
#define R_KEY		114
#define I_KEY		105
#define SPACE_KEY	32
#define BACK_SPACE	65288
#define DEL_KEY	        65535
#define RETURN_KEY 	65293
#define _MAX_ASCII_	128


/* ----------------------- INTERFACE ------------------------ */
Display *DISPLAY;
Window WinPlx, WinPlayers, WinLogin, WinWait, WinMessages;
int WinSizeX, WinSizeY;
GC Sablier_gc, MidLines_gc, Lines_gc, MiniLines_gc, Selection_gc, Black_gc, Draw_gc[MAX_USERS], 
   Caract_gc;
GC Login_gc, Title_gc;
XWindowAttributes XAttr;

/* ----------- messages --------- */
int NB_MESSAGES, MesgX=15, MesgWidth, WIN_MESG_H=200, WIN_MESG_W=400;
MesgStruct *Messages=NULL;
#define MESG_ECART 15

/* ----------- login ------------ */
#define WIN_LOGIN_WIDTH 500
char M_buf[3][255];
int LOGIN_Y[3];
#define MAX_MOTD_LINES 30
static char Motd[MAX_MOTD_LINES][MESSAGE_BUF];
static int nb_motd_lines;
int LargeurCase;

/* ----------- coordonnees des cases ------------- */
typedef struct {
  int x1;
  int y1;
  int x2;
  int y2;
  int x3;
  int y3;
  int x4;
  int y4;
} Point;

Point **Coord[NB_DAMIERS];

/* ---------------------------------------------------------- */

int Old_Forteresses=0, Forteresses=0, Old_Chef=0, Chef=0; /* pour le placement de depart */

OneMovement Movement[NB_MOVES];
int CurrentMove;

int CurrentPlx=0, CurrentView=0, CurrentMode=0;
int cut_nbp, cut_nbx, cut_nby; /* nb de plx, taille en x et en y du tranchage courant */

char *ConnectionClosed="Server seems to have closed connection... Waiting...\n";
char *ConnectionError="Server does not respond any more...\n";

char Names[MAX_USERS][NAME_BUF], Email[MAX_USERS][EMAILENGTH];
int IsAlive[MAX_USERS], Score[MAX_USERS];
int nbplayers;

void d2to3d(int x, int y, int *X, int *Y, double Cos, double Sin)
{
  double s1=(double)y*Sin, c1=(double)y*Cos;
  /* *Y=s1-s1/(1.0+DIST/(c1)); */
  *Y=DIST*s1/(DIST+c1);
  /* *X=x+(LONG/2.0 - (double)x)/(1.0 + DIST/c1);*/
  *X=((double)x*DIST+LONG/2.0*c1)/(c1+DIST);
}

void d3to2di(int X, int Y, int *x, int *y, double Cos, double Sin)
{
  int ax, ay;
  ax=Y*(X-LONG/2.0)/(DIST*Sin/Cos-Y)+X;
  ay=Y*DIST/(DIST*Sin-Y*Cos);
  *x=ax/tcase;
  *y=ay/tcase;
}
  
void Real2View(int p, int x, int y, int *P, int *X, int *Y, int V_Mode)
{
  if (V_Mode==0)  /* mode de vue ("tranchage") normal des plateaux */
    {
      *P=p;
      if (!CurrentView)
	{
	  *X=x;
	  *Y=y;
	  return;
	}
      switch(CurrentView)
	{
	case 1:
	  *X=y;
	  *Y=cut_nby-x-1;
	  break;
	case 2:
	  *X=cut_nbx-x-1;
	  *Y=cut_nby-y-1;
	  break;
	case 3:
	  *X=cut_nbx-y-1;
	  *Y=x;
	  break;
	}
      return;
    }
  else if (V_Mode==1)
    {
      int m_p, m_x, m_y;
      
      m_p=y;
      m_x=x;
      m_y=p;
      Real2View(m_p, m_x, m_y, P, X, Y, 0);
    }
  else if (V_Mode==2)
    {
      int m_p, m_x, m_y;
      
      m_p=x;
      m_x=c_params.SIZE_X-y-1;
      m_y=p;
      Real2View(m_p, m_x, m_y, P, X, Y, 0);
    }
}

void View2Real(int P, int X, int Y, int *p, int *x, int *y, int V_Mode)
{
  if (V_Mode==0)  /* mode de vue normal des plateaux ("tranchage") */
    {
      *p=P;
      if (!CurrentView)
	{
	  *x=X;
	  *y=Y;
	  return;
	}
      switch(CurrentView)
	{
	case 1:
	  *y=X;
	  *x=cut_nby-Y-1;
	  break;
	case 2:
	  *x=cut_nbx-X-1;
	  *y=cut_nby-Y-1;
	  break;
	case 3:
	  *y=cut_nbx-X-1;
	  *x=Y;
	  break;
	}
      return;
    }
  else if (V_Mode==1)
    {
      int m_p, m_x, m_y;
      
      View2Real(P, X, Y, &m_p, &m_x, &m_y, 0);
      *p=m_y;
      *x=m_x;
      *y=m_p;
    }
  else if (V_Mode==2)
    {
      int m_p, m_x, m_y;
      
      View2Real(P, X, Y, &m_p, &m_x, &m_y, 0);
      *p=m_y;
      *x=m_p;
      *y=c_params.SIZE_X-m_x-1;
    }
}


void AfficheLegendeSablier(char *legende)
{
  XClearArea(DISPLAY, WinPlx, WinSizeX+SABLIER_L/2, 100+SABLIER_H, 50, 50, False);
  XDrawString(DISPLAY, WinPlx, MidLines_gc, WinSizeX+SABLIER_L/2, 100+SABLIER_H+20, 
	      legende, strlen(legende));
}


void MiseAJourDuSablier(int Valeur)
{
  int niv;
  XClearArea(DISPLAY, WinPlx, WinSizeX+SABLIER_L/2, 100, SABLIER_L, SABLIER_H, False);
  if (Valeur>SABLIER_H)
    niv=SABLIER_H;
  else
    niv=Valeur;
   XFillRectangle(DISPLAY, WinPlx, Sablier_gc, WinSizeX+SABLIER_L/2, 100+SABLIER_H-niv, 
		  SABLIER_L, niv);
  XFlush(DISPLAY);
}

GC CreeXorGC(Window TheWindow, char *TheColor, int LineWidth)
{
  XGCValues gc_values;
  GC gc;
  XColor ColorExact, ColorScreen;

  XAllocNamedColor(DISPLAY, DefaultColormap(DISPLAY, DefaultScreen(DISPLAY)), TheColor,
                   &ColorScreen, &ColorExact);
  gc_values.foreground = ColorScreen.pixel;
  gc_values.line_width = LineWidth;
  gc_values.function = GXxor;
  gc = XCreateGC(DISPLAY, TheWindow, (GCBackground|GCForeground|GCLineWidth|GCFunction), 
		 &gc_values);
  return gc;
}


GC CreeGC(Window TheWindow, char *TheColor, int LineWidth)
{
  XGCValues gc_values;
  GC gc;
  XColor ColorExact, ColorScreen;
  XFontStruct *xfs;

  xfs = XLoadQueryFont(DISPLAY, "-sony-fixed-medium-*-*-*-16-*-*-*-*-*-*-*");
  XAllocNamedColor(DISPLAY, DefaultColormap(DISPLAY, DefaultScreen(DISPLAY)), TheColor,
                   &ColorScreen, &ColorExact);
  gc_values.foreground = ColorScreen.pixel;
  gc_values.font=xfs->fid;
  gc_values.line_width = LineWidth;
  gc = XCreateGC(DISPLAY, TheWindow, 
		 (GCBackground|GCForeground|GCLineWidth|GCFont), &gc_values);
  return gc;
}

GC CreeTitleGC(Window TheWindow, char *TheColor)
{
  XGCValues gc_values;
  GC gc;
  XColor ColorExact, ColorScreen;
  XFontStruct *xfs;

  xfs = XLoadQueryFont(DISPLAY, "-*-symbol-*-*-*-*-*-450-*-*-*-*-*-*");
  XAllocNamedColor(DISPLAY, DefaultColormap(DISPLAY, DefaultScreen(DISPLAY)), TheColor,
                   &ColorScreen, &ColorExact);
  gc_values.foreground = ColorScreen.pixel;
  gc_values.font=xfs->fid;
  gc = XCreateGC(DISPLAY, TheWindow, 
		 (GCBackground|GCForeground|GCFont), &gc_values);
  return gc;
}

void CreationDesGC(int nbniveaux)
{
  int j, NBCOLORS=10;
  char *Couleurs[]={"red", "goldenrod1", "white", "seagreen3", "blue2", "slate gray", 
		      "MediumOrchid2", "burlywood4", "deep pink", "forest green"};
  /* le noir doit rester en 0 et le blanc en 2 ! */

  for (j=0; j<NBCOLORS; j++)
    Draw_gc[j]=CreeGC(WinPlx, Couleurs[j], 1);

  Lines_gc=CreeGC(WinPlx, "steelblue4", 1);
  MidLines_gc=CreeGC(WinPlx, "wheat4", 1);
  MiniLines_gc=CreeGC(WinPlx, "wheat1", 1);
  Caract_gc=CreeXorGC(WinPlx, "wheat1", 1);
  Selection_gc=CreeGC(WinPlx, "wheat1", 1);
  Sablier_gc=CreeGC(WinPlx, "steelblue4", 1);
  Black_gc=CreeGC(WinPlx, "black", 1);
}


void CalculeCosSin()
{
  COS_ALPHA[0]=cos(ALPHA);
  SIN_ALPHA[0]=sin(ALPHA);
  COS_ALPHA[1]=cos(ALPHA-ECART_ALPHA);
  SIN_ALPHA[1]=sin(ALPHA-ECART_ALPHA);
  COS_ALPHA[2]=cos(ALPHA-2*ECART_ALPHA);
  SIN_ALPHA[2]=sin(ALPHA-2*ECART_ALPHA);
}

void InitCoords()
{
  int p, x, y, i, j;
  double Cos, Sin;
  
  for (i=0; i<NB_DAMIERS; i++)
    {
      Coord[i]=malloc(c_params.SIZE_X*sizeof(Point *));
      for (j=0; j<c_params.SIZE_X; j++)
	Coord[i][j]=malloc(c_params.SIZE_X*sizeof(Point));
    }

  for (p=0; p<NB_DAMIERS; p++)
    {
      Cos=COS_ALPHA[p];
      Sin=SIN_ALPHA[p];
      for (x=0; x<c_params.SIZE_X; x++)
	for (y=0; y<c_params.SIZE_X; y++)
	  {
	    d2to3d(x*tcase, y*tcase, &(Coord[p][x][y].x1), &(Coord[p][x][y].y1), Cos, Sin);
	    d2to3d(x*tcase, (y+1)*tcase, &(Coord[p][x][y].x2), &(Coord[p][x][y].y2), Cos, Sin);
	    d2to3d((x+1)*tcase, (y+1)*tcase, &(Coord[p][x][y].x3), &(Coord[p][x][y].y3), Cos, Sin);
	    d2to3d((x+1)*tcase, y*tcase, &(Coord[p][x][y].x4), &(Coord[p][x][y].y4), Cos, Sin);
	  }
    }
}

void InitCutVars(int Mode)
/* init. les variables definissant les plateaux pour le tranchage courant */
{
  switch(Mode)
    {
    case 0:
      cut_nbp=c_params.SIZE_Z;
      cut_nbx=cut_nby=c_params.SIZE_X;
      tcase=LONG/cut_nbx;  /* mise a jour */
      break;
    case 1:
      switch(CurrentView)
	{
	case 0:
	case 2:
	  cut_nbp=cut_nbx=c_params.SIZE_X;
	  cut_nby=c_params.SIZE_Z;
	  break;
	case 1:
	case 3:
	  cut_nbp=cut_nby=c_params.SIZE_X;
	  cut_nbx=c_params.SIZE_Z;
	  break;
	}
      tcase=LONG/cut_nbx;  /* mise a jour */
      break;
    case 2:
      switch(CurrentView)
	{
	case 0:
	case 2:
	  cut_nbp=cut_nbx=c_params.SIZE_X;
	  cut_nby=c_params.SIZE_Z;
	  break;
	case 1:
	case 3:
	  cut_nbp=cut_nby=c_params.SIZE_X;
	  cut_nbx=c_params.SIZE_Z;
	  break;
	}
      tcase=LONG/cut_nbx;  /* mise a jour */
      break;
    }
  InitCoords(); /* pour prendre en compte le changement de "tcase" */
}

void ReallocMessagesTable()
{
  static int memo=0;

  if (memo==NB_MESSAGES)
    return;
  if (Messages==NULL)
    Messages=malloc(NB_MESSAGES*sizeof(MesgStruct));
  else
    Messages=realloc(Messages, NB_MESSAGES*sizeof(MesgStruct));
  memo=NB_MESSAGES;
}

void InitVariables()
{
  int i;

  tcase=LONG/c_params.SIZE_X;
  WinSizeX=LONG+100;
  WinSizeY=3*LONG/2+20;

  MesgWidth=WIN_MESG_W;
  NB_MESSAGES=WIN_MESG_H/MESG_ECART-1;
  ReallocMessagesTable(NB_MESSAGES);

  CalculeCosSin();
  InitCoords();

  CurrentMode=0; /* tranchage */
  InitCutVars(CurrentMode);

  for (i=0; i<NB_MESSAGES; i++)
    strcpy(Messages[i].mesg, "");

  for (i=0; i<3; i++)
    LOGIN_Y[i]=170+30*i;
}

void CreationDesFenetres(int NbNiveaux)
{
  int i;
  
  WinPlx=XCreateSimpleWindow(DISPLAY, RootWindow(DISPLAY, DefaultScreen(DISPLAY)), 0, 0,
			     WinSizeX+2*SABLIER_L, WinSizeY, 2, 0, 
			     BlackPixel(DISPLAY, DefaultScreen(DISPLAY)));
  XSelectInput(DISPLAY, WinPlx, ButtonPressMask|ButtonReleaseMask|KeyPressMask|ExposureMask);
  XStoreName(DISPLAY, WinPlx, "AntipoliX");
  XMapWindow(DISPLAY, WinPlx);

  WinPlayers=XCreateSimpleWindow(DISPLAY, RootWindow(DISPLAY, DefaultScreen(DISPLAY)), 0, 0, 
				 250, 40+20*nbplayers, 2, 0, 
				 BlackPixel(DISPLAY, DefaultScreen(DISPLAY)));
  XSelectInput(DISPLAY, WinPlayers, ButtonPressMask|ButtonReleaseMask|KeyPressMask|ExposureMask);
  XStoreName(DISPLAY, WinPlayers, "Players");
  XMapWindow(DISPLAY, WinPlayers);

  WinMessages=XCreateSimpleWindow(DISPLAY, RootWindow(DISPLAY, DefaultScreen(DISPLAY)), 0, 0, 
				  WIN_MESG_W, WIN_MESG_H, 2, 0, 
				  BlackPixel(DISPLAY, DefaultScreen(DISPLAY)));
  XSelectInput(DISPLAY, WinMessages, KeyPressMask|ExposureMask);
  XStoreName(DISPLAY, WinMessages, "Messages");
  XMapWindow(DISPLAY, WinMessages);

  XFlush(DISPLAY);
}
				  
void LoginWindowCreation()
{
  if ((DISPLAY = XOpenDisplay(NULL)) == NULL)
    {
      printf("** Can't open display. Ciao !\n");
      exit(-1);
    }

  WinLogin=XCreateSimpleWindow(DISPLAY, RootWindow(DISPLAY, DefaultScreen(DISPLAY)), 0, 0, 
			       WIN_LOGIN_WIDTH, 800, 2, 0, 
			       BlackPixel(DISPLAY, DefaultScreen(DISPLAY)));
  XSelectInput(DISPLAY, WinLogin, ButtonPressMask|ButtonReleaseMask|KeyPressMask|ExposureMask);
  XStoreName(DISPLAY, WinLogin, "AntipoliX");
  XMapWindow(DISPLAY, WinLogin);

  WinWait=XCreateSimpleWindow(DISPLAY, RootWindow(DISPLAY, DefaultScreen(DISPLAY)), 0, 0, 
			      230, 70, 2, 0, 
			      BlackPixel(DISPLAY, DefaultScreen(DISPLAY)));
  XSelectInput(DISPLAY, WinWait, ButtonPressMask|KeyPressMask|ExposureMask);
  XStoreName(DISPLAY, WinWait, "AntipoliX");
}

void DessineInvisible(int p, int x, int y)
{
  Point P=Coord[p-CurrentPlx][x][y];
  static XPoint XP[5];
  int bx, by;
  
  bx=LEFT_BORDER; by=(LONG)*(NB_DAMIERS-p+CurrentPlx)/2;
  
  XP[0].x=bx+P.x1;
  XP[0].y=by-P.y1;
  XP[1].x=bx+P.x2;
  XP[1].y=by-P.y2;
  XP[2].x=bx+P.x3;
  XP[2].y=by-P.y3;
  XP[3].x=bx+P.x4;
  XP[3].y=by-P.y4;
  XFillPolygon(DISPLAY, WinPlx, Lines_gc, XP, 4, Convex, CoordModeOrigin);
}

void DessineChef(int p, int x, int y)
{
  Point P=Coord[p-CurrentPlx][x][y];
  static XPoint XP[5];
  int vx, vy, bx, by;
  
  bx=LEFT_BORDER; by=(LONG)*(NB_DAMIERS-p+CurrentPlx)/2;

  vx=(P.x4-P.x1)/7;
  vy=(P.y2-P.y1)/7;
  XP[0].x=bx+P.x1+7*vx/3;
  XP[0].y=by-P.y1-vy;

  XP[1].x=bx+P.x4-7*vx/3;
  XP[1].y=by-P.y1-vy;

  XP[2].x=bx+(P.x3+P.x2)/2;
  XP[2].y=by-P.y2+vy;

  XP[3].x=XP[0].x;
  XP[3].y=XP[0].y;
  XDrawLines(DISPLAY, WinPlx, Caract_gc, XP, 4, CoordModeOrigin);
}

void DessineTeleport(int p, int x, int y)
{
  Point P=Coord[p-CurrentPlx][x][y];
  static XPoint XP[5];
  int vx, vy, bx, by;
  
  bx=LEFT_BORDER; by=(LONG)*(NB_DAMIERS-p+CurrentPlx)/2;
  vx=(P.x3-P.x2)/3;
  vy=(P.y2-P.y1)/3;
  XP[0].x=bx+P.x2+2;
  XP[0].y=by-P.y2+2;
  XP[1].x=bx+P.x2+2+vx;
  XP[1].y=by-P.y2+2;
  XP[2].x=bx+P.x1+2*(P.x2-P.x1)/3+2;
  XP[2].y=by-P.y3+2+vy;
  XFillPolygon(DISPLAY, WinPlx, MiniLines_gc, XP, 3, Convex, CoordModeOrigin);
}

void DessineCaract(int p, int x, int y, int caract)
{  
  switch(caract)
    {
    case INVISIBLE:
      DessineInvisible(p, x, y);
      break;
    case TELEPORT:
      DessineTeleport(p, x, y);
      break;
    case CHEF:
      DessineChef(p, x, y);
      break;
    case NORMAL:
      break;
    }
}

void DessineCase(int P, int X, int Y, GC *gc)
/* Recoit les coordonnees REELLES de la case */
{
  int x1, y1, x2, y2, x3, y3, x4, y4, bx, by, p, pview, xview, yview;
  double Cos, Sin;
  Point PP;

  Real2View(P, X, Y, &pview, &xview, &yview, CurrentMode);
  p=pview-CurrentPlx;
  if (p>=0 && p<NB_DAMIERS)  /* verification qu'on est dans le champ de vision */
    PP=Coord[p][xview][yview];
  else
    return;  /* on est dans le cas de l'AfficheMovement d'un mouvement hors-champ */
  bx=50; by=(LONG)*(NB_DAMIERS-p)/2;

  XDrawLine(DISPLAY, WinPlx, *gc, bx+PP.x1, by-PP.y1, bx+PP.x2, by-PP.y2);
  XDrawLine(DISPLAY, WinPlx, *gc, bx+PP.x2, by-PP.y2, bx+PP.x3, by-PP.y3);
  XDrawLine(DISPLAY, WinPlx, *gc, bx+PP.x3, by-PP.y3, bx+PP.x4, by-PP.y4);
  XDrawLine(DISPLAY, WinPlx, *gc, bx+PP.x4, by-PP.y4, bx+PP.x1, by-PP.y1);
}

void DessineArmee(int p, int x, int y, int couleur, int caract)
{
  Point P=Coord[p-CurrentPlx][x][y];
  static XPoint XP[5];
  int vx, vy, bx, by;
  
  bx=LEFT_BORDER; by=(LONG)*(NB_DAMIERS-p+CurrentPlx)/2;
  if (caract==INVISIBLE)
    DessineCaract(p, x, y, caract);
  vx=(P.x4-P.x1)/7;
  vy=(P.y2-P.y1)/7;
  XP[0].x=bx+P.x1+vx;
  XP[0].y=by-P.y1-vy;
  XP[1].x=bx+P.x1+3*vx;
  XP[1].y=by-P.y1-vy;
  XP[2].x=bx+P.x3-2;
  XP[2].y=by-P.y3+vy;
  XFillPolygon(DISPLAY, WinPlx, Draw_gc[couleur], XP, 3, Convex, CoordModeOrigin);
  XP[0].x=bx+P.x4-vx;
  XP[0].y=by-P.y1-vy;
  XP[1].x=bx+P.x4-3*vx;
  XP[1].y=by-P.y1-vy;
  XP[2].x=bx+P.x2+2;
  XP[2].y=by-P.y2+vy;
  XFillPolygon(DISPLAY, WinPlx, Draw_gc[couleur], XP, 3, Convex, CoordModeOrigin);
  if (caract!=INVISIBLE)
    DessineCaract(p, x, y, caract);
}

void DessineHovercraft(int p, int x, int y, int couleur, int caract)
{
  Point P=Coord[p-CurrentPlx][x][y];
  static XPoint XP[5];
  int vx, vy, bx, by;
  
  bx=LEFT_BORDER; by=(LONG)*(NB_DAMIERS-p+CurrentPlx)/2;

  if (caract==INVISIBLE)
    DessineCaract(p, x, y, caract);
  vx=(P.x4-P.x1)/7;
  vy=(P.y2-P.y1)/7;
  XP[0].x=bx+P.x1+vx;
  XP[0].y=by-P.y1-vy;
  XP[1].x=bx+P.x1+2*vx;
  XP[1].y=by-P.y1-vy;
  XP[2].x=bx+(P.x3+P.x2)/2;
  XP[2].y=by-P.y3+vy;
  XFillPolygon(DISPLAY, WinPlx, Draw_gc[couleur], XP, 3, Convex, CoordModeOrigin);
  XP[0].x=bx+P.x4-vx;
  XP[0].y=by-P.y1-vy;
  XP[1].x=bx+P.x4-2*vx;
  XP[1].y=by-P.y1-vy;
  XP[2].x=bx+(P.x3+P.x2)/2;
  XP[2].y=by-P.y2+vy;
  XFillPolygon(DISPLAY, WinPlx, Draw_gc[couleur], XP, 3, Convex, CoordModeOrigin);
  XDrawLine(DISPLAY, WinPlx, Draw_gc[couleur], bx+P.x1+2*vx, by-P.y1-vy, bx+P.x4-2*vx, by-P.y1-vy);
  if (caract!=INVISIBLE)
    DessineCaract(p, x, y, caract);
}

void DessineForteresse(int p, int x, int y, int couleur, int caract)
{
  Point P=Coord[p-CurrentPlx][x][y];
  static XPoint XP[5];
  int vx, vy, bx, by;
  GC gc;
  
  bx=LEFT_BORDER; by=(LONG)*(NB_DAMIERS-p+CurrentPlx)/2;
  
  if (couleur==CASE_OCCUPEE)
    gc=Caract_gc;
  else
    {
      gc=Draw_gc[couleur];
      if (caract==INVISIBLE)
	DessineCaract(p, x, y, caract);
    }
  vx=(P.x4-P.x1)/7;
  vy=(P.y2-P.y1)/7;
  XP[0].x=bx+P.x1+vx;
  XP[0].y=by-P.y1-vy;
  XP[1].x=bx+P.x4-vx;
  XP[1].y=by-P.y1-vy;
  XP[2].x=bx+P.x2+4*(P.x3-P.x2)/5;
  XP[2].y=by-P.y2+vy;
  XP[3].x=bx+P.x2+(P.x3-P.x2)/5;
  XP[3].y=by-P.y2+vy;
  XFillPolygon(DISPLAY, WinPlx, gc, XP, 4, Convex, CoordModeOrigin);
  if (caract!=INVISIBLE)
    DessineCaract(p, x, y, caract);
}

void EffaceCase(int real_p, int real_x, int real_y, int p, int x, int y)
/* recoit les coordonnees REELLES (real_p, ...) et RELATIVES (p, x, y) de la case */
{
  Point P=Coord[p-CurrentPlx][x][y];
  static XPoint XP[5];
  int bx, by;
  
  bx=LEFT_BORDER; by=(LONG)*(NB_DAMIERS-p+CurrentPlx)/2;

  XP[0].x=bx+P.x1;
  XP[0].y=by-P.y1;
  XP[1].x=bx+P.x2;
  XP[1].y=by-P.y2;
  XP[2].x=bx+P.x3;
  XP[2].y=by-P.y3;
  XP[3].x=bx+P.x4;
  XP[3].y=by-P.y4;
  XFillPolygon(DISPLAY, WinPlx, Black_gc, XP, 4, Convex, CoordModeOrigin);
  DessineCase(real_p, real_x, real_y, &Lines_gc);
}

void DessinePiece(int couleur, int type, int caract, int p, int x, int y)
/* Recoit les coordonnees REELLES de la piece */
{
  static int P, X, Y;
  Real2View(p, x, y, &P, &X, &Y, CurrentMode);
  EffaceCase(p, x, y, P, X, Y);
  switch(type)
    {
    case CASE_VIDE:
      break;
    case ARMEE:
      DessineArmee(P, X, Y, couleur, caract);
      break;
    case HOVERCRAFT:
      DessineHovercraft(P, X, Y, couleur, caract);
      break;
    case FORTERESSE:
      DessineForteresse(P, X, Y, couleur, caract);
      break;
    }
}

void FastDessinePiece(int couleur, int type, int caract, int p, int x, int y)
/* Recoit les coordonnees REELLES de la piece */
{
  static int P, X, Y;
  Real2View(p, x, y, &P, &X, &Y, CurrentMode);
  if (couleur==CASE_OCCUPEE)
    {
      DessineForteresse(P, X, Y, CASE_OCCUPEE, NORMAL);
      return;
    }
  switch(type)
    {
    case CASE_VIDE:
      break;
    case ARMEE:
      DessineArmee(P, X, Y, couleur, caract);
      break;
    case HOVERCRAFT:
      DessineHovercraft(P, X, Y, couleur, caract);
      break;
    case FORTERESSE:
      DessineForteresse(P, X, Y, couleur, caract);
      break;
    }
}



void DessineMidLines(int RelatPlx)
/* recoit le numero de plateau a l'ecran (0 - NB_DAMIERS) */
{
  double Cos, Sin;
  int bx, by, i, X1, Y1, X2, Y2;

  Cos=COS_ALPHA[RelatPlx];
  Sin=SIN_ALPHA[RelatPlx];
  bx=LEFT_BORDER; by=(LONG)*(NB_DAMIERS-RelatPlx)/2;
  i=cut_nbx/2;
  d2to3d(i*tcase, 0, &X1, &Y1, Cos, Sin);
  d2to3d(i*tcase, cut_nby*tcase, &X2, &Y2, Cos, Sin);
  XDrawLine(DISPLAY, WinPlx, MidLines_gc, bx+X1, by-Y1, bx+X2, by-Y2);
  i=cut_nby/2;
  d2to3d(0, i*tcase, &X1, &Y1, Cos, Sin);
  d2to3d(cut_nbx*tcase, i*tcase, &X2, &Y2, Cos, Sin);
  XDrawLine(DISPLAY, WinPlx, MidLines_gc, bx+X1, by-Y1, bx+X2, by-Y2);
}


void CreationDesDamiers(Univers *U)
{
  int i, j, bx, by, X1, Y1, X2, Y2;
  double Cos, Sin;
  GC gc;

  XClearArea(DISPLAY, WinPlx, 0, 0, WinSizeX, WinSizeY, False);
  for (j=0; j<NB_DAMIERS && j<cut_nbp; j++)
    {
      Cos=COS_ALPHA[NB_DAMIERS-j-1];
      Sin=SIN_ALPHA[NB_DAMIERS-j-1];
      bx=LEFT_BORDER; by=(LONG)*(j+1)/2;
      for (i=0; i<cut_nby+1; i++)
	{
	  if (i==cut_nby/2)
	    gc=MidLines_gc;
	  else
	    gc=Lines_gc;
	  d2to3d(0, i*tcase, &X1, &Y1, Cos, Sin);
	  d2to3d(cut_nbx*tcase, i*tcase, &X2, &Y2, Cos, Sin);
	  XDrawLine(DISPLAY, WinPlx, gc, bx+X1, by-Y1, bx+X2, by-Y2);
	}
      
      for (i=0; i<cut_nbx+1; i++)
	{
	  if (i==cut_nbx/2)
	    gc=MidLines_gc;
	  else
	    gc=Lines_gc;
	  d2to3d(i*tcase, 0, &X1, &Y1, Cos, Sin);
	  d2to3d(i*tcase, cut_nby*tcase, &X2, &Y2, Cos, Sin);
	  XDrawLine(DISPLAY, WinPlx, gc, bx+X1, by-Y1, bx+X2, by-Y2);
	}
      DessineMidLines(NB_DAMIERS-j-1);
    }
}


void CreationDesMiniPlx(Univers *U)
{
  int j;
  GC gc;
  
  XClearArea(DISPLAY, WinPlx, WinSizeX+SABLIER_L/2, 100+SABLIER_H+50, 
	     SABLIER_L, 150, False);
  for (j=0; j<cut_nbp; j++)
    {
      if (j>=CurrentPlx && j<CurrentPlx+NB_DAMIERS)
	gc=MiniLines_gc;
      else
	gc=Lines_gc;
      XDrawLine(DISPLAY, WinPlx, gc, WinSizeX+SABLIER_L/2, 300+SABLIER_H-15*j, 
		WinSizeX+3*SABLIER_L/2, 300+SABLIER_H-15*j);
    }
}


void EffaceMessages()
{
  /* XClearArea(DISPLAY, WinPlx, MesgX, 0MesgY[0]-MESG_ECART, MesgWidth, 
	     (NB_MESSAGES+1)*MESG_ECART, False); */
  XClearWindow(DISPLAY, WinMessages);
}


void LibereMessageLine()
{
  int i;
  for (i=0; i<NB_MESSAGES-1; i++) {
    strcpy(Messages[i].mesg, Messages[i+1].mesg);
    Messages[i].from_who=Messages[i+1].from_who; }
}

void AfficheX(char *chaine, int who)
{
  static int i;
  static GC gc;
  
  if (chaine!=NULL)  /* enregistrement du message */
    {
      LibereMessageLine();
      strcpy(Messages[NB_MESSAGES-1].mesg, chaine);
      Messages[NB_MESSAGES-1].from_who=who;
    }
  EffaceMessages();
  for (i=0; i<NB_MESSAGES; i++)
    {
      if (Messages[i].from_who==-1)
	gc=MiniLines_gc;
      else
	gc=Draw_gc[Messages[i].from_who];
      XDrawString(DISPLAY, WinMessages, gc, MesgX, i*MESG_ECART+20, 
		  Messages[i].mesg, strlen(Messages[i].mesg));
    }
}

void Affiche(char *chaine)
{
  fprintf(stdout, chaine);
}

void AffMessage(int FromWho, char *Message)
{
  char aff[MESSAGE_BUF];
  
  if (FromWho==-1)
    sprintf(aff, "- From Server : %s", Message);
  else if (FromWho>10) { /* 100, 200, 300, ... */ 
    FromWho=FromWho/100-1;
    sprintf(aff, "(%d)%s -> All : %s", FromWho, Names[FromWho], Message); }
  else
    sprintf(aff, "(%d)%s -> You : %s", FromWho, Names[FromWho], Message);
  
  AfficheX(aff, FromWho);
}

/* -------------------------  interface X pour LOGIN ----------------------------- */

void DessineWaitWindow(int nbplayers, int nbinqueue)
{
  static char buf[100];

  XClearWindow(DISPLAY, WinWait);
  sprintf(buf, "Game starts at %d players", nbplayers);
  XDrawString(DISPLAY, WinWait, Login_gc, 20, 20, buf, strlen(buf));
  sprintf(buf, "%d players are waiting", nbinqueue);
  XDrawString(DISPLAY, WinWait, Login_gc, 20, 40, buf, strlen(buf));
  XDrawLine(DISPLAY, WinWait, Login_gc, 0, 45, 300, 45);
  sprintf(buf, "Hit Q to quit");
  XDrawString(DISPLAY, WinWait, Login_gc, 60, 60, buf, strlen(buf));
}


void EffaceLigneLogin(int x, int y)
{
  XClearArea(DISPLAY, WinLogin, x, y-MESG_ECART, WIN_LOGIN_WIDTH, MESG_ECART+3, False);
}

void AfficheTitre()
{
  char s1[]="AntipoliX", s2[]="AntipoliX - v2.1";
  XDrawString(DISPLAY, WinLogin, Title_gc, 130, 80, s1, strlen(s1));
  XDrawString(DISPLAY, WinLogin, Login_gc, 190, 105, s2, strlen(s2));
}

void AfficheMotd()
{
  int i;

  XDrawLine(DISPLAY, WinLogin, Login_gc, 0, 400, WIN_LOGIN_WIDTH, 400);
  for (i=0; i<nb_motd_lines; i++)
    XDrawString(DISPLAY, WinLogin, Login_gc, 30, 420+17*i, Motd[i], strlen(Motd[i]));

}

void AfficheQueues()
{
  int i;
  char QV[10];

  LargeurCase=WIN_LOGIN_WIDTH/(Max_Queues+1);
  XDrawLine(DISPLAY, WinLogin, Login_gc, 0, 350, WIN_LOGIN_WIDTH, 350);
  for (i=1; i<Max_Queues+1; i++)
    XDrawLine(DISPLAY, WinLogin, Login_gc, i*LargeurCase, 350, i*LargeurCase, 400);
  for (i=0; i<Max_Queues; i++)
    {
      sprintf(QV, "%d / %d", QueueWait[i], QueueGood[i]);
      XDrawString(DISPLAY, WinLogin, Login_gc, i*LargeurCase+20, 380, QV, strlen(QV));
    }
  sprintf(QV, "QUIT");
  XDrawString(DISPLAY, WinLogin, Login_gc, Max_Queues*LargeurCase+20, 380, QV, strlen(QV));
}

void AfficheLoginInfo(char *info, int delai)
{
  XDrawString(DISPLAY, WinLogin, Login_gc, 50, 300, info, strlen(info));
  XFlush(DISPLAY);
  sleep(delai);
  EffaceLigneLogin(50, 300);
}

void AfficheQuitLogin()
{
  char buf[100];
  sprintf(buf, "Click here to leave");
  XDrawLine(DISPLAY, WinLogin, Login_gc, 0, 350, 500, 350);
  XDrawString(DISPLAY, WinLogin, Login_gc, 100, 380, buf, strlen(buf));
}

#define HIDE_MODE 0  /* pour le password */
#define SHOW_MODE 1

void GetALoginString(int LineN, char *buf, char *buff, int x, int y, GC *gc, int Mode)
{
  int l0=strlen(buf), l=0, keyascii, i;
  static XEvent Event;
  
  XDrawString(DISPLAY, WinLogin, *gc, x, y, buf, strlen(buf));
  while (1)
    {
      if (XCheckMaskEvent(DISPLAY, KeyPressMask|ButtonPressMask|ExposureMask, &Event))
	if (Event.type==ButtonPress && Event.xkey.y>350)
	  exit(0);
	else if (Event.type==Expose)
	  {
	    AfficheTitre();
	    AfficheMotd();
	    for (i=0; i<LineN-1; i++)
	      {
		EffaceLigneLogin(50, LOGIN_Y[i]);
		XDrawString(DISPLAY, WinLogin, *gc, 50, LOGIN_Y[i], M_buf[i], strlen(M_buf[i]));
	      }
	    EffaceLigneLogin(x, y);
	    XDrawString(DISPLAY, WinLogin, *gc, x, y, buf, l0+(Mode&1)*l);
	  }
	else if (Event.type==KeyPress)
	  switch(keyascii=XLookupKeysym(&(Event.xkey), (Event.xkey.state & ShiftMask)))
	    {
	    case RETURN_KEY:
	      {
		strcpy(buff, buf);
		strcpy(buf, buf+l0);
		return;
	      }
	    case BACK_SPACE:
	    case DEL_KEY:
	      if (l>0)
		l--;
	      buf[l0+l]='\0';
	      if (Mode!=HIDE_MODE)
		{
		  EffaceLigneLogin(x, y);
		  XDrawString(DISPLAY, WinLogin, *gc, x, y, buf, strlen(buf));
		}
	      break;
	    default:
	      if (keyascii<_MAX_ASCII_ && keyascii>0)
		{
		  buf[l0+l]=keyascii;
		  l++;
		  buf[l0+l]='\0';
		  if (Mode!=HIDE_MODE)
		    {
		      EffaceLigneLogin(x, y);
		      XDrawString(DISPLAY, WinLogin, *gc, x, y, buf, strlen(buf));
		    }
		}
	    }
    }
}

int ChooseQueue(int *nb_wanted)
{
  XEvent Event;
  int x, y, i, key_code;

  AfficheQueues();
  while (1)
    {
      if (XCheckMaskEvent(DISPLAY, KeyPressMask|ButtonPressMask|ExposureMask, &Event))
	switch(Event.type)
	  {
	  case Expose:
	    AfficheTitre();
	    AfficheMotd();
	    for (i=0; i<2; i++)
	      {
		EffaceLigneLogin(50, LOGIN_Y[i]);
		XDrawString(DISPLAY, WinLogin, Login_gc, 50, LOGIN_Y[i], M_buf[i], strlen(M_buf[i]));
	      }
	    AfficheQueues();
	    break;
	  case ButtonPress:
	    x=Event.xbutton.x/LargeurCase;
	    y=Event.xbutton.y;
	    if (y>350 && y<400)
	      {
		if (x>=Max_Queues)
		  exit(0);
		else if (QueueGood[x]>0)
		  return x;
	      }
	    break;
	  case KeyPress:
	    x=Event.xkey.x/LargeurCase;
	    y=Event.xkey.y;
	    if (y>350 && y<400 && x<Max_Queues)
	      {
		key_code=XLookupKeysym(&(Event.xkey), (Event.xkey.state & ShiftMask))-_0_KEY;
		key_code=(key_code==0?10:key_code);      /* 0 <=> 10 */
		if (key_code>1 && key_code<11)
		  {
		    *nb_wanted=key_code;
		    return x;
		  }
	      }
	    break;
	  }
    }
}

void EnterPlayerName(char *PlayerName)
{
  char buf[255];
  int M1x=50, M1y=LOGIN_Y[0];
  
  EffaceLigneLogin(M1x, M1y);
  EffaceLigneLogin(M1x, LOGIN_Y[1]);  /* au cas ou ce serait une deuxieme tentative */
  sprintf(buf, "Enter your name (%d Car. Max) : ", NAME_BUF);
  XDrawString(DISPLAY, WinLogin, Login_gc, M1x, M1y, buf, strlen(buf));
  GetALoginString(1, buf, M_buf[0], M1x, M1y, &Login_gc, SHOW_MODE);

  strncpy(PlayerName, buf, NAME_BUF);
  PlayerName[NAME_BUF-1]='\0';
}

void EnterPassword(char *Password)
{
  int M1x=50, M1y=LOGIN_Y[1];
  char buf[255];

  EffaceLigneLogin(M1x, M1y);
  sprintf(buf, "Enter your password : ");
  XDrawString(DISPLAY, WinLogin, Login_gc, M1x, M1y, buf, strlen(buf));
  GetALoginString(2, buf, M_buf[1], M1x, M1y, &Login_gc, HIDE_MODE);
  
  strncpy(Password, buf, PASSLENGTH);
  Password[PASSLENGTH-1]='\0';
}

void EnterEmail(char *Email)
{
  char buf[255];
  int M1x=50, M1y=LOGIN_Y[2];

  EffaceLigneLogin(M1x, M1y);
  sprintf(buf, "Enter your email : ");
  XDrawString(DISPLAY, WinLogin, Login_gc, M1x, M1y, buf, strlen(buf));
  GetALoginString(3, buf, M_buf[2], M1x, M1y, &Login_gc, SHOW_MODE);
  
  strncpy(Email, buf, EMAILENGTH);
  Email[EMAILENGTH-1]='\0';
}

int GetTimer(int sockfd)
{
  char buf[SABLIER_BUF];
  int sablier;
  
  Read(sockfd, buf, SABLIER_BUF);
  GetInt(buf, &sablier);
  
  return sablier;
}

void DrawUniverse(Univers *U)
{
  int p, i, j, real_p, real_x, real_y;

  CreationDesDamiers(U);
  CreationDesMiniPlx(U);

  for (p=CurrentPlx; p<CurrentPlx+NB_DAMIERS; p++)
    for (i=0; i<cut_nbx; i++)
      for (j=0; j<cut_nby; j++)
	/* on boucle sur les cases RELATIVES => on sait que l'on reste
	   dans le domaine de ce qui peut etre affiche' a l'ecran */
	{
	  View2Real(p, i, j, &real_p, &real_x, &real_y, CurrentMode);
	  if (U->P[real_p].Case[real_x][real_y].Couleur>CASE_VIDE)
	  FastDessinePiece(U->P[real_p].Case[real_x][real_y].Couleur, 
			   U->P[real_p].Case[real_x][real_y].Type, 
			   U->P[real_p].Case[real_x][real_y].Caract, real_p, real_x, real_y);
	}
}

int WhichCase(int x, int y, int *MemoP, int *MemoX, int *MemoY)
/* Recoit les coordonnees graphiques de la souris.
   Renvoie les coordonnees exactes de la case cliquee (independantes de View). */
{
  int p=0, Espace=LONG/2, Y=y, x2d, y2d, P, X2d, Y2d;

  while (Y-Espace>0 && p<NB_DAMIERS)
    {
      Y-=Espace;
      p++;
    }
  
  p=NB_DAMIERS-p-1;
  d3to2di(x-LEFT_BORDER, Espace-Y, &x2d, &y2d, COS_ALPHA[p], SIN_ALPHA[p]);
  
  if (x2d>=0 && x2d<cut_nbx && y2d>=0 && y2d<cut_nby)
    {
      View2Real(p+CurrentPlx, x2d, y2d, &P, &X2d, &Y2d, CurrentMode);
      *MemoP=P;
      *MemoX=X2d;
      *MemoY=Y2d;
      return 1;
    }
  return 0;
}


void SelectCase(int p, int x, int y)
/* recoit les coordonnees reelles de la case */
{
  DessineCase(p, x, y, &Selection_gc);
}


void AfficheMovement(Univers *U, int n)
{
  int i, j;
  
  for (i=0; i<Movement[n].nbcases; i++)
    SelectCase(Movement[n].cases[i].p, Movement[n].cases[i].x, Movement[n].cases[i].y);
}


void DeselectCase(Univers *U, int p, int cx, int cy)
/* recoit les coordonnees reelles de la case */
{
  int mid_x=cut_nbx/2, mid_y=cut_nby/2, rx, ry, rp;
  DessinePiece(U->P[p].Case[cx][cy].Couleur, U->P[p].Case[cx][cy].Type, 
	       U->P[p].Case[cx][cy].Caract, p, cx, cy);
  DessineCase(p, cx, cy, &Lines_gc);
  Real2View(p, cx, cy, &rp, &rx, &ry, CurrentMode);
  if (rx==mid_x || rx==mid_x-1 || ry==mid_y || ry==mid_y-1)
    DessineMidLines(rp-CurrentPlx);
  AfficheMovement(U, CurrentMove);
}


int AddPiece(int Type, int Caract, int p, int x, int y, Univers *U)
/* recoit les coordonnees reelles de la case */
{
  int VChef=0, VFort=0;
  
  if (Caract==CHEF)
    {
      if (Chef==0 && Type!=CASE_VIDE)
	VChef=1;
      else if (Type!=CASE_VIDE)
	{
	  AfficheX("You can place only one chief...", -1);
	  return 0;
	}
    }
  else
    if (U->P[p].Case[x][y].Caract==CHEF)
      VChef=(-1);
  
  if (Type==FORTERESSE)
    if (U->P[p].Case[x][y].Type==FORTERESSE)
      VFort=0;
    else if (Forteresses < U->NbPlateaux)
      VFort=1;
    else
      {
	char m[100];
	sprintf(m, "You can't place more than %d fortresses", U->NbPlateaux);
	AfficheX(m, -1);
	return 0;
      }
  else
    if (U->P[p].Case[x][y].Type==FORTERESSE)
      VFort=(-1);

  Old_Chef=Chef;
  Old_Forteresses=Forteresses;
  Chef+=VChef;
  Forteresses+=VFort;
  
  return 1;
}

void DisplayPlayers()
{
  static char buf[100];
  int cpt=0, i;

  XClearWindow(DISPLAY, WinPlayers);
  strcpy(buf, "Still alive :");
  XDrawString(DISPLAY, WinPlayers, MiniLines_gc, 10, 15, buf, strlen(buf));
  for (i=0; i<nbplayers; i++)
    if (IsAlive[i])
      {
	sprintf(buf, "(%d) %s [%s] : %d", i, Names[i], Email[i], Score[i]);
	XDrawString(DISPLAY, WinPlayers, Draw_gc[i], 10, cpt*20+40, buf, strlen(buf));
	cpt++;
      }
}


void DisplayUniverseParameters(Parameters *p)
{
  printf("\nServer parameters :\n");
  printf("-------------------\n");
  printf("\nSIZE : %dx%dx%d\n\n", p->SIZE_Z, p->SIZE_X, p->SIZE_X);
  printf("Types:                Cost       Att      Def        Moves\n");
  printf("a - Armie               %d         %d        %d           %d\n", 
	 p->COST_ARMIE, p->ATT_ARMIE, p->DEF_ARMIE, p->MOV_ARMIE);
  printf("h - Hovercraft          %d         %d        %d           %d\n", 
	 p->COST_HOVERCRAFT, p->ATT_HOVERCRAFT, p->DEF_HOVERCRAFT, p->MOV_HOVERCRAFT);
  printf("f - Fortress           %d         -        %d           -\n", 
	 p->COST_FORTRESS, p->DEF_FORTRESS);

  printf("\nCaracteristics:\n");
  printf("n - Normal\n");
  printf("i - Invisible           %d\n", p->COST_INVISIBILITY);
  printf("t - Teleporter         %d                              %d\n", 
	 p->COST_TELEPORT, p->TELEPORT_FIELD);
  printf("c - Chief (unique)\n\n");
}


void ChooseStartPositions(Univers *U, int number, int Pecule)
{
  int CONTINUE=1, MemoP, MemoX, MemoY, IsSelected=0, IsOK, MemoExpose=0, MoveAngle=0;
  XEvent Event;
  Window w;
  int NextType, NextCaract;

  MiseAJourDuSablier(Pecule);
  while (CONTINUE)
    {
      if (!XCheckMaskEvent(DISPLAY, KeyPressMask|ButtonPressMask|
			  ButtonReleaseMask|ExposureMask, &Event))
	MemoExpose=0;
      else if ((w=Event.xany.window)==WinPlayers)
	{
	  if (Event.type==Expose)
	    DisplayPlayers(); 
	}
      else if (w==WinMessages)
	{
	  if (Event.type==Expose)
	    {
	      XGetWindowAttributes(DISPLAY, WinMessages, &XAttr);
	      NB_MESSAGES=XAttr.height/MESG_ECART-1;
	      ReallocMessagesTable(NB_MESSAGES);
	      AfficheX(NULL, -1);
	    }
	}
      else if (w==WinPlx)
	{
	  switch(Event.type)
	    {
	    case Expose:
	      if (!MemoExpose)
		{
		  MemoExpose=1;
		  DrawUniverse(U);
		  MiseAJourDuSablier(Pecule);
		  AfficheLegendeSablier("Credits");
		  AfficheX(NULL, -1);
		}
	      break;
	    case ButtonPress:
	      if (MoveAngle)
		{
		  MoveAngle=0;
		  InitCoords();
		}
	      if (WhichCase(Event.xbutton.x, Event.xbutton.y, &MemoP, &MemoX, &MemoY))
		{
		  if (U->P[MemoP].Case[MemoX][MemoY].Couleur!=-1)
		    {
		      IsSelected=1;
		      SelectCase(MemoP, MemoX, MemoY);
		      NextType=U->P[MemoP].Case[MemoX][MemoY].Type;
		      NextCaract=U->P[MemoP].Case[MemoX][MemoY].Caract;
		    }
		}
	      break;
	    case ButtonRelease:
	      if (IsSelected)
		{
		  IsSelected=0;
		  IsOK=AddPiece(NextType, NextCaract, MemoP, MemoX, MemoY, U);
		  if (IsOK)
		    {
		      if (!Place(U, MemoP, MemoX, MemoY, number, NextType, NextCaract, 
				 &Pecule, &c_params))
			{
			  Chef=Old_Chef;
			  Forteresses=Old_Forteresses;
			}
		      MiseAJourDuSablier(Pecule);
		    }
		  DeselectCase(U, MemoP, MemoX, MemoY);
		}
	      break;
	    case KeyPress:
	      switch(XLookupKeysym(&(Event.xkey), (Event.xkey.state & ShiftMask)))
		{
		case FLECHE_H:
		  if (Event.xkey.state & ControlMask)
		    {
		      if (ALPHA>0.1)  
			{
			  ALPHA-=0.05;
			  MoveAngle=1;
			  CalculeCosSin();
			  InitCoords();
			  DrawUniverse(U);
			}
		    }
		  else
		    if (CurrentPlx+NB_DAMIERS<cut_nbp)
		      {
			CurrentPlx++;
			DrawUniverse(U);
		      }
		  break;
		case FLECHE_B:
		  if (Event.xkey.state & ControlMask)
		    {
		      if (ALPHA<1.5)
			{
			  ALPHA+=0.05;
			  MoveAngle=1;
			  CalculeCosSin();
			  InitCoords();
			  DrawUniverse(U);
			}
		    }
		  else
		    if (CurrentPlx>0)
		      {
			CurrentPlx--;
			DrawUniverse(U);
		      }
		  break;
		case FLECHE_G:
		  CurrentView--;
		  if (CurrentView<0)
		    CurrentView=3;
		  InitCutVars(CurrentMode);
		  DrawUniverse(U);
		  break;
		case FLECHE_D:
		  CurrentView++;
		  if (CurrentView>3)
		    CurrentView=0;
		  InitCutVars(CurrentMode);
		  DrawUniverse(U);
		  break;
		case V_KEY:
		  CurrentPlx=0;
		  CurrentMode++;
		  if (CurrentMode>2)
		    CurrentMode=0;
		  InitCutVars(CurrentMode);
		  DrawUniverse(U);
		  break;
		case A_KEY:
		  if (IsSelected)
		    {
		      NextType=ARMEE;
		      DessinePiece(number, NextType, NextCaract, MemoP, MemoX, MemoY);
		      SelectCase(MemoP, MemoX, MemoY);
		    }
		  break;
		case H_KEY:
		  if (IsSelected)
		    {
		      NextType=HOVERCRAFT;
		      DessinePiece(number, NextType, NextCaract, MemoP, MemoX, MemoY);
		      SelectCase(MemoP, MemoX, MemoY);
		    }
		  break;
		case F_KEY:
		  if (IsSelected)
		    {
		      NextType=FORTERESSE;
		      DessinePiece(number, NextType, NextCaract, MemoP, MemoX, MemoY);
		      SelectCase(MemoP, MemoX, MemoY);
		    }
		  break;
		case I_KEY:
		  if (IsSelected)
		    {
		      NextCaract=INVISIBLE;
		      if (NextType>CASE_VIDE)
			{
			  DessinePiece(number, NextType, NextCaract, MemoP, MemoX, MemoY);
			  SelectCase(MemoP, MemoX, MemoY);
			}
		    }
		  break;
		case T_KEY:
		  if (IsSelected)
		    {
		      NextCaract=TELEPORT;
		      if (NextType>CASE_VIDE)
			{
			  DessinePiece(number, NextType, NextCaract, MemoP, MemoX, MemoY);
			  SelectCase(MemoP, MemoX, MemoY);
			}
		    }
		  break;
		case C_KEY:
		  if (IsSelected)
		    {
		      NextCaract=CHEF;
		      if (NextType>CASE_VIDE)
			{
			  DessinePiece(number, NextType, NextCaract, MemoP, MemoX, MemoY);
			  SelectCase(MemoP, MemoX, MemoY);
			}
		    }
		  break;
		case N_KEY:
		  if (IsSelected)
		    {
		      NextCaract=NORMAL;
		      if (NextType>CASE_VIDE)
			{
			  DessinePiece(number, NextType, NextCaract, MemoP, MemoX, MemoY);
			  SelectCase(MemoP, MemoX, MemoY);
			}
		    }
		  break;
		case SPACE_KEY:
		  if (IsSelected)
		    {
		      NextType=CASE_VIDE;
		      NextCaract=NORMAL;
		      DessinePiece(number, NextType, NextCaract, MemoP, MemoX, MemoY);
		      SelectCase(MemoP, MemoX, MemoY);
		    }
		  break;
		case RETURN_KEY:
		  if (Chef==0)
		    AfficheX("You have to place your chief...", -1);
		  else
		    CONTINUE=0; /* les pieces sont placees : on envoie la position au serveur... */
		  break;
		default:
		  break;
		}
	      break;
	    default:
	      MemoExpose=0;
	      break;
	    }
	}
    }
}
      
void InitMoves()
{
  int i;
  for (i=0; i<NB_MOVES; i++)
    {
      Movement[i].nbcases=0;
      Movement[i].cases=malloc(sizeof(Case));
    }
}


void AddThisCase(int Move, int p, int x, int y)
{
  Movement[Move].nbcases++;
  Movement[Move].cases=realloc(Movement[Move].cases, Movement[Move].nbcases * sizeof(Case));
  Movement[Move].cases[Movement[Move].nbcases-1].p=p;
  Movement[Move].cases[Movement[Move].nbcases-1].x=x;
  Movement[Move].cases[Movement[Move].nbcases-1].y=y;
}
  
void DelThisCase(int Move, int n)
{
  int i;
  for (i=0; i<Movement[Move].nbcases-1; i++)
    if (i<n)
      continue;
    else
      {
	Movement[Move].cases[i].p=Movement[Move].cases[i+1].p;
	Movement[Move].cases[i].x=Movement[Move].cases[i+1].x;
	Movement[Move].cases[i].y=Movement[Move].cases[i+1].y;
      }
  Movement[Move].nbcases--;
  Movement[Move].cases=realloc(Movement[Move].cases, Movement[Move].nbcases * sizeof(Case));
}


void ManageThisCase(Univers *U, int p, int x, int y, int Move, int joueur)
{
  int i, myarmies=0, ennemies=0, vides=0, IsOK=0;
  for (i=0; i<Movement[Move].nbcases && !EqualCase(Movement[Move].cases[i], p, x, y); i++)
    {
      Case c=Movement[Move].cases[i];
      int r=IsWhom(U, c.p, c.x, c.y, joueur);
      if (r==CASE_VIDE)
	vides++;
      else if (r==MYARMIE)
	myarmies++;
      else if (r==ENNEMY)
	ennemies++;
      else
	StopError(5678);
    }
  if (i<Movement[Move].nbcases) /* on a clique sur une case deja selectionnee */
    {
      DelThisCase(Move, i);
      DeselectCase(U, p, x, y);
    }
  else /* la case n'a pas encore ete selectionnee */
    {
      switch(IsWhom(U, p, x, y, joueur))
	{
	case CASE_VIDE:
	  if (myarmies==1 && ennemies==0 && vides==0)
	    IsOK=1;
	  break;
	case MYARMIE:
	  if (!(vides==1 && myarmies==1))
	    IsOK=1;
	  break;
	case ENNEMY:
	  if (ennemies==0 && vides==0)
	    IsOK=1;
	  break;
	}
      if (IsOK && IsUnique(Movement, 0, 0, p, x, y))
	{
	  AddThisCase(Move, p, x, y);
	  SelectCase(p, x, y);
	}
    }
}


int AnalyseMessage(int FromWho, char *Message)
{
  int i, j;
  
  if (FromWho==-1) /* Message du serveur */
    {
      GetInt(Message, &i);
      GetInt(Message+szi, &j);
      if (i==KILLED || i==ABANDON || i==TIMEDEATH || i==DATAERROR)
	{
	  IsAlive[j]=0;
	  return 1;
	}
    }
  return 0;
}

void BeginTheGameClient(int sockfd)
{
  char buf[QUEUE_BUF], Message[MESSAGE_BUF];
  int i, mesg, Sablier, Who, IsMyTurn, Pecule, MemoExpose=0, MoveAngle=0, position;
  int NBPLX, NbCarEntree=0, MessageSendMode=0, DecalagePrompt, FirstStopMessage=1;
  Univers U;
  XEvent Event;
  Window w;
  int MemoP, MemoX, MemoY, MovesCptr=1, keyascii;
  
  Read(sockfd, buf, SABLIER_BUF);
  GetInt(buf, &Sablier); 	   /* on recoit la valeur de depart du sablier */

  for (i=0; i<nbplayers; i++) {    /* on recoit les NOMS des protagonistes */
    Read(sockfd, Names[i], NAME_BUF);
    IsAlive[i]=1; }
  
  for (i=0; i<nbplayers; i++)      /* on recoit les EMAILS des protagonistes */
    Read(sockfd, Email[i], EMAILENGTH);

  for (i=0; i<nbplayers; i++) {    /* on recoit les SCORES des protagonistes */
    Read(sockfd, buf, ENTIER_BUF);
    GetInt(buf, &Score[i]); }

  Affiche("\nWait please...\n");

  /* Attente du message "CHOOSE" ------------------------------ */
  Read(sockfd, buf, QUEUE_BUF);
  GetInt(buf, &Pecule);         /* on recoit la valeur du pecule au passage... */
  GetInt(buf+szi, &position); 	/* ...et celle de la position du joueur */

  NBPLX=c_params.SIZE_Z;
  XUnmapWindow(DISPLAY, WinLogin);
  CreationDesFenetres(NBPLX);
  CreationDesGC(NBPLX);

  CreateUniverse(&U, NBPLX, c_params.SIZE_X);  /* pour malloquer .... */
  
  sleep(2);  /* bidouille... pour pas planter le lancement des fenetres X */

  if (GetEntete(sockfd)!=UNIVERS)  /* on lit l'entete... meme si on sait ce qui arrive ! */
    StopError(4);

  GetUniverse(sockfd, &U);
  DrawUniverse(&U);
  DisplayPlayers();

  AfficheLegendeSablier("Credits");
  sprintf(Message, "Place your pieces, please... you have %d minutes", c_params.TIME_TO_PLACE);
  AfficheX(Message, -1);
  sprintf(Message, "Initial Credits : %d", Pecule);
  AfficheX(Message, -1);
  
  ChooseStartPositions(&U, position, Pecule);
  SendUniverse(sockfd, &U);
  AfficheX("Start position send", -1);
  AfficheLegendeSablier(" Time ");

  /* ---------------------------------------------------------
     ------------------ Begining of GAME ---------------------
     --------------------------------------------------------- */

  /* On attend plusieurs types de donnees :
     - Des messages d'autres joueurs
     - Des mises a jour du sablier
     - Des Univers
     _ Des invitations a jouer */

  IsMyTurn=0;
  while(1)
    {
      if (WaitForThisSocket(sockfd, 0) && FirstStopMessage)
	{
	  switch(GetEntete(sockfd))
	    {
	    case MESSAGE:
	      GetMessage(sockfd, &Who, Message);
	      if (!AnalyseMessage(Who, Message))
		AffMessage(Who, Message);
	      break;
	    case SABLIER:
	      Sablier=GetTimer(sockfd);
	      MiseAJourDuSablier(Sablier);
	      break;
	    case UNIVERS:
	      GetUniverse(sockfd, &U);
	      DrawUniverse(&U);
	      break;
	    case MY_TURN:
	      printf("\7");fflush(stdout);
	      MovesCptr++;
	      IsMyTurn=1;
	      InitMoves();
	      CurrentMove=0;
	      AfficheMovement(&U, CurrentMove); 
	      break;
	    default:  /* en particulier "DEBLOCK" */
	      if (FirstStopMessage) {
		AfficheX("Connection closed by server", -1);
		FirstStopMessage=0; }
	      break;
	    }
	}

      if (XCheckMaskEvent(DISPLAY, KeyPressMask|ButtonPressMask|ExposureMask, &Event)) {
	if ((w=Event.xany.window)==WinPlayers)
	  {
	    MemoExpose=0;
	    if (Event.type==Expose)
	      DisplayPlayers(); 
	  }
	else if (w==WinMessages)
	  {
	    MemoExpose=0;
	    if (Event.type==Expose)
	      {
		XGetWindowAttributes(DISPLAY, WinMessages, &XAttr);
		NB_MESSAGES=XAttr.height/MESG_ECART-1;
		ReallocMessagesTable(NB_MESSAGES);
		AfficheX(NULL, -1);
	      }
	  }
	else if (w==WinPlx)
	  {
	    switch(Event.type)
	      {
	      case Expose:
		if (!MemoExpose)
		  {
		    MemoExpose=1;
		    DrawUniverse(&U);
		    AfficheMovement(&U, CurrentMove);
		    MiseAJourDuSablier(Sablier);
		    AfficheLegendeSablier(" Time ");
		    AfficheX(NULL, -1);
		  }
		break;
	      case ButtonPress:
		WhichCase(Event.xbutton.x, Event.xbutton.y, &MemoP, &MemoX, &MemoY);
		if (MemoP>=0)
		  ManageThisCase(&U, MemoP, MemoX, MemoY, CurrentMove, position);
		break;
	      case KeyPress:
		keyascii=XLookupKeysym(&(Event.xkey), (Event.xkey.state & ShiftMask));
		if (MessageSendMode)
		  {
		    if (keyascii==RETURN_KEY)
		      {
			MessageSendMode=0;
			strcpy(Message, Messages[NB_MESSAGES-1].mesg+DecalagePrompt);
			Message[strlen(Message)-1]='\0';
			strcpy(Messages[NB_MESSAGES-1].mesg+DecalagePrompt-1, Message);
			SendMessage(sockfd, Message, Who);
			AfficheX(NULL, -1);
		      }
		    else
		      {
			if (keyascii==BACK_SPACE || keyascii==DEL_KEY) {
			  if (NbCarEntree>0)
			    NbCarEntree--; }
			else if (keyascii<_MAX_ASCII_ && keyascii>0)
			  {
			    Messages[NB_MESSAGES-1].mesg[DecalagePrompt+NbCarEntree]=keyascii;
			    NbCarEntree++;
			  }
			Messages[NB_MESSAGES-1].mesg[DecalagePrompt+NbCarEntree]='>';
			Messages[NB_MESSAGES-1].mesg[DecalagePrompt+NbCarEntree+1]='\0';
			AfficheX(NULL, -1);
		      }
		  }
		else 
		  switch(keyascii)
		    {
		    case FLECHE_H:
		      if (Event.xkey.state & ControlMask)
			{
			  if (ALPHA>0.1)  
			    {
			      ALPHA-=0.05;
			      MoveAngle=1;
			      CalculeCosSin();
			      InitCoords();
			      DrawUniverse(&U);
			      AfficheMovement(&U, CurrentMove);
			    }
			}
		      else
			if (CurrentPlx+NB_DAMIERS<cut_nbp)
			  {
			    CurrentPlx++;
			    DrawUniverse(&U);
			    AfficheMovement(&U, CurrentMove);
			  }
		      break;
		    case FLECHE_B:
		      if (Event.xkey.state & ControlMask)
			{
			  if (ALPHA<1.5)
			    {
			      ALPHA+=0.05;
			      MoveAngle=1;
			      CalculeCosSin();
			      InitCoords();
			      DrawUniverse(&U);
			      AfficheMovement(&U, CurrentMove);
			    }
			}
		      else
			if (CurrentPlx>0)
			  {
			    CurrentPlx--;
			    DrawUniverse(&U);
			    AfficheMovement(&U, CurrentMove);
			  }
		      break;
		    case FLECHE_G:
		      CurrentView--;
		      if (CurrentView<0)
			CurrentView=3;
		      InitCutVars(CurrentMode);
		      DrawUniverse(&U);
		      AfficheMovement(&U, CurrentMove);
		      break;
		    case FLECHE_D:
		      CurrentView++;
		      if (CurrentView>3)
			CurrentView=0;
		      InitCutVars(CurrentMode);
		      DrawUniverse(&U);
		      AfficheMovement(&U, CurrentMove);
		      break;
		    case V_KEY:
		      CurrentPlx=0;
		      CurrentMode++;
		      if (CurrentMode>2)
			CurrentMode=0;
		      InitCutVars(CurrentMode);
		      DrawUniverse(&U);
		      AfficheMovement(&U, CurrentMove);      
		      break;
		    case M_KEY:
		    case A_KEY:
		    case _0_KEY:
		    case _1_KEY:
		    case _2_KEY:
		    case _3_KEY:
		    case _4_KEY:
		    case _5_KEY:
		    case _6_KEY:
		    case _7_KEY:
		    case _8_KEY:
		    case _9_KEY:
		      MessageSendMode=1;
		      NbCarEntree=0;
		      LibereMessageLine();
		      if (keyascii==M_KEY) {
			Who=(-1);
			sprintf(Messages[NB_MESSAGES-1].mesg, "%d -> (server) <>", position); }
		      else if (keyascii==A_KEY) {
			Who=(-2);
			sprintf(Messages[NB_MESSAGES-1].mesg, "%d -> (all) <>", position); }
		      else {
			  Who=keyascii-_0_KEY;
			  sprintf(Messages[NB_MESSAGES-1].mesg, "%d -> %d <>", position, Who); }
		      Messages[NB_MESSAGES-1].from_who=(-1);
		      DecalagePrompt=strlen(Messages[NB_MESSAGES-1].mesg)-1;
		      AfficheX(NULL, -1);
		      break;
		    case R_KEY: /* reset du movement en cours */
		      Movement[CurrentMove].nbcases=0;
		      DrawUniverse(&U);
		      break;
		    case RETURN_KEY:
		      if (IsMyTurn)
			{
			  IsMyTurn=0;
			  SendMovement(sockfd, Movement);
			  sprintf(Message, "Movement #%d send", MovesCptr-1);
			  AfficheX(Message, -1);
			}
		      break;
		    } /* ---- fin du "case KeyPress:" ----- */
		break;
	      default:
		MemoExpose=0;
	      }
	  }
      }
      else
	MemoExpose=0;
    }
}


void SendName(int sockfd, char *PlayerName)
{
  int i, j;
  char buf[szi], Password[PASSLENGTH], Verif[PASSLENGTH];
  
  while (1)
    {
      EnterPlayerName(PlayerName);
      write(sockfd, PlayerName, NAME_BUF); /* envoi du NOM du joueur */
      if (!strncmp(PlayerName, "God", 4))
	exit(0);
      CliRead(sockfd, buf, szi, TIMEOUT2, ConnectionClosed);
      GetInt(buf, &i);
      if (i==1234) /* le nom existe bien */
	{
	  EnterPassword(Password);
	  write(sockfd, Password, PASSLENGTH);
	  CliRead(sockfd, buf, szi, TIMEOUT2, ConnectionClosed);
	  GetInt(buf, &j);
	  if (j==5678)  /* password OK */
	    return;
	  AfficheLoginInfo("Bad password...", 1);
	}
      else if (i==2345)  /* le nom n'existe pas */
	{
	  AfficheLoginInfo("This is a new character...", 1);
	  EnterPassword(Password);
	  AfficheLoginInfo("Verification : enter your password again", 1);
	  EnterPassword(Verif);
	  if (!strncmp(Password, Verif, PASSLENGTH))
	    {
	      PutInt(buf, 8765);  /* ok, password entre' */
	      write(sockfd, buf, szi);
	      write(sockfd, Password, PASSLENGTH);
	      return;
	    }
	  else
	    {
	      AfficheLoginInfo("Passwords do not match !", 1);
	      PutInt(buf, 4321);  /* probleme de password... on recommence... */
	      write(sockfd, buf, szi);
	    }
	}
      else
	StopError(1345);
    }
}


void ReceiveMotd(int sockfd)
{
  char buf[ENTIER_BUF];
  int i;

  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &nb_motd_lines);

  for (i=0; i<nb_motd_lines; i++)
    Read(sockfd, Motd[i], MESSAGE_BUF);
}

void ReceiveQueueValues(int sockfd)
{
  char buf[ENTIER_BUF];
  int i;
  
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &Max_Queues);
  
  for (i=0; i<Max_Queues; i++)
    {
      Read(sockfd, buf, ENTIER_BUF);
      GetInt(buf, &QueueWait[i]);
      Read(sockfd, buf, ENTIER_BUF);
      GetInt(buf, &QueueGood[i]);
    }
}

void ReceiveUniverseParameters(int sockfd, Parameters *p)
{
  char buf[ENTIER_BUF];

  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->TIME_TO_PLACE));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->TIME_TO_PLAY));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->CREDITS_100));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->SIZE_X));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->SIZE_Z));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->COST_FORTRESS));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->COST_ARMIE));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->COST_HOVERCRAFT));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->COST_INVISIBILITY));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->COST_TELEPORT));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->DEF_FORTRESS));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->DEF_ARMIE));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->DEF_HOVERCRAFT));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->ATT_ARMIE));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->ATT_HOVERCRAFT));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->MOV_ARMIE));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->MOV_HOVERCRAFT));
  Read(sockfd, buf, ENTIER_BUF);
  GetInt(buf, &(p->TELEPORT_FIELD));
}


void main(int argc, char *argv[])
{
  struct hostent *Host;
  struct sockaddr_in servaddr;
  int sockfd, PORTN, NbInQueue, wanted_queue, nb_wanted;
  char buf[QUEUE_BUF], PlayerName[NAME_BUF], Email[EMAILENGTH];

  if (argc!=3 && argc!=4)
    {
      fprintf(stderr, "Usage : client <host> <port>\n");
      exit(0);
    }
  
  if ((Host=gethostbyname(argv[1]))==NULL)
    {
      fprintf(stderr, "** unknown host %s\n", argv[1]);
      exit(0);
    }

  PORTN=atoi(argv[2]);

  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      fprintf(stderr, "** socket error **\n");
      exit(0);
    }
  
  fprintf(stdout, "Calling %s on port %d.\n", argv[1], PORTN);
  bzero(&servaddr, sizeof(servaddr));
  bcopy(*(Host->h_addr_list), (char *)&servaddr.sin_addr.s_addr, Host->h_length);
  servaddr.sin_port = PORTN;
  servaddr.sin_family=AF_INET;

  if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr))<0)
    {
      fprintf(stderr, "** Unable to connect to server\n");
      exit(0);
    }
  fprintf(stdout, "Got connection with AntipoliX.\nWait please...");
  
  ReceiveUniverseParameters(sockfd, &c_params);
  ReceiveMotd(sockfd);
  ReceiveQueueValues(sockfd);
  DisplayUniverseParameters(&c_params);

  InitVariables();
  LoginWindowCreation();
  Login_gc=CreeGC(WinLogin, "wheat1", 1);
  Title_gc=CreeTitleGC(WinLogin, "wheat3");
  AfficheTitre();
  AfficheMotd();

  SendName(sockfd, PlayerName);
  EnterEmail(Email);
  write(sockfd, Email, EMAILENGTH);

  wanted_queue=ChooseQueue(&nb_wanted);
  PutInt(buf, wanted_queue);
  write(sockfd, buf, ENTIER_BUF); /* ENVOI du desir du client */
  PutInt(buf, nb_wanted);
  write(sockfd, buf, ENTIER_BUF);

  CliRead(sockfd, buf, QUEUE_BUF, TIMEOUT2, ConnectionError);
  GetInt(buf, &nbplayers);

  if (nbplayers>=0)
    {
      XEvent Event;
      XUnmapWindow(DISPLAY, WinLogin);
      
      GetInt(buf+szi, &NbInQueue);
      if (NbInQueue!=nbplayers)
	XMapWindow(DISPLAY, WinWait);
      Login_gc=CreeGC(WinWait, "wheat1", 1);
      DessineWaitWindow(nbplayers, NbInQueue);
      XFlush(DISPLAY);
      while (NbInQueue<nbplayers)
	{
	  if (XCheckMaskEvent(DISPLAY, KeyPressMask|ButtonPressMask|ExposureMask, &Event))
	    {
	      if (Event.type==Expose)
		{
		  DessineWaitWindow(nbplayers, NbInQueue);
		  XFlush(DISPLAY);
		}
	      else if (Event.type==KeyPress && 
		       XLookupKeysym(&(Event.xkey), (Event.xkey.state & ShiftMask))==BigQ_KEY)
		exit(0);
	    }
	  if (WaitForThisSocket(sockfd, 0))
	    {
	      Read(sockfd, buf, ENTIER_BUF);
	      GetInt(buf, &NbInQueue);
	      DessineWaitWindow(nbplayers, NbInQueue);
	      XFlush(DISPLAY);
	    }
	  if (NbInQueue==nbplayers)
	    XUnmapWindow(DISPLAY, WinWait);
	}
    }
  else
    {
      fprintf(stderr, "No space left for this game. Try later.\n");
      exit(0);
    }

  XFlush(DISPLAY);
  BeginTheGameClient(sockfd);
  
}
