/*
 * Copyright 1993 Torstein Hansen
 */


/* 
 * FibwP.h - Private definitions for Fibw - the Fabulously Impresssive
 *           Backgammon board Widget
 */

#ifndef _FibwP_h
#define _FibwP_h

#include <Xm/XmP.h>   
#if XmVersion > 1001
#include <Xm/PrimitiveP.h>
#endif

/*
 * Include public header file for this widget.
 */
#include "Fibw.h"
#include "config.h"

#define MAXROLLS 4

typedef struct {
	int x1,x2,y1,y2;
}PosRec;

typedef struct {
	int may_I_have_another_drink_please;	/* dummy variable */
			/* What did you think it was... */
} FibwClassPart;

/* Full class record declaration */
typedef struct _FibwClassRec {
    CoreClassPart         core_class;
    XmPrimitiveClassPart  primitive_class;
    FibwClassPart         fibw_class;
} FibwClassRec;

extern FibwClassRec fibwClassRec;
  
/* New fields for the Fibw widget record */
typedef struct {
    /* resources */
    Dimension   pixmap_width;
    Dimension   pixmap_height;
    XColor      table;		/* The 'table' on which the board sits */
    XColor      base;		/* The bottom of the board */
    XColor      frame;		/* The frame around the board */
    XColor      wpoint;		/* 'white' point color */
    XColor      bpoint;		/* 'black' point color */
    XColor      wpiece;		/* 'white' piece color */
    XColor      bpiece;		/* 'black' piece color */
    XColor      dblcube;
    XColor      dbltext;
    XColor      foreground;	/* Replaces wtext */
    XColor      background;	/* Replaces btext */
    Font	font;
    Boolean	numbers;	/* Flag if numbers visible */
    Boolean	onFrame;	/* Flag if names/score are on frame of board */
    Boolean	debug;		/* Flag if debugging */
    int		logStyle;	/* What we should write to logfile */
    XtCallbackList callback;	/* application installed callback function(s) */

    /* private state */
    XFontStruct *pFont;		/* pointer to struct of standard text font */
    int		textheight;	/* Height of the standard text font */
    FIBS_Rec	fibs_rec;	/* Info coming from FIBS */
    int		board_y_offset,	/* Various coord.s of different board parts.. */
		board_x_offset,
		piece_size, 
		frame_size, 
		home_offset, 
		playfield_offset;    

    int		depth;		/* depth of screen, is it monochrome? */
    PosRec	pos_rec[28];	/* stores coordinates of points so we can */
				/* find where we're putting pieces easily */
    char	lastboard[STRING_LENGTH];	/* Copy of board line */

    int		playerfirst,	/* Players dice in first roll */
		opponentfirst;	/* same for the opponent */
    Dice	dice[MAXROLLS];	/* Current dice */
    int		first_roll;	/* boolean value, is it the first roll? */
    int		moving;		/* Are we moving a piece now? */
    int		oldboard[28];	/* board layout before current move */
    int		pieces_moved;	/* How many pieces have we moved so far? */
    int		moves_left;	/* How many moves may we move?  */
    int		move_off;	/* May I move 'off'? */
    int		bear_off;	/* May I bear off now? */
    char	invited_name[80];	/* person who just invited you */

    XPoint	current_piece_pos;	/* Where is the moving piece now, */
    XPoint	last_piece_pos;	/* and where did I move it from? */
    int		moved_from_pos;	/* Picked up here (check it's legal) */ 
    int		popupmenu;	/* What popup menu is in effect? */
    Pixmap	board_pixmap;	/* pixmap of backgammon board */
    Pixmap	back_pixmap;	/* pixmap of board without all the extras..  */
    Pixmap	dice_pixmap;	/* pixmap of the 12 different dice */
    Pixmap	cube_pixmap;	/* pixmap of double cube without number */
    Pixmap	small_pixmap;	/* Save background while moving a piece... */
    GC		draw_gc;	/* graphics context for the widget */
} FibwPart;

/*
 * Full instance record declaration
 */
typedef struct _FibwRec {
    CorePart		core;
    XmPrimitivePart	primitive;
    FibwPart		fibw;
} FibwRec;

extern void Redisplay();
#endif /* _FibwP_h */
