#ifndef MOUSEH
#define MOUSEH

typedef struct {
    int	 reason;	/* 1 if legal move, 0 if not */
    int	 dice_used;	/* number of eyes on the dice used to move */
    int	 blot_hit;	/* 1 if blot is hit, 0 if not */
} Move;

#ifdef _NO_PROTO
extern void checkBearOff();
extern int  pickupPiece();
extern void dropPiece();
extern void movePiece();
extern void clickPiece();
extern void undoLastMove();
extern int  legal_move();
extern void pipCount();
#else
extern void checkBearOff(FibwWidget);
extern int  pickupPiece(Widget, XButtonEvent *);
extern void dropPiece(Widget, XButtonEvent *);
extern void movePiece(Widget, XButtonEvent *);
extern void clickPiece(Widget, XButtonEvent *);
extern void undoLastMove(FibwWidget);
extern int  legal_move(FibwWidget, int, int *, Move *);
extern void pipCount(FibwWidget);
#endif

#define ms_blocked        0
#define ms_cant_bear_off  1
#define ms_no_such_dice   2
#define ms_bear_off       3
#define ms_normal_move    4

#endif /* MOUSEH */
