.TH XFIBS 6 "22 August 1995"
.SH NAME
xfibs \- graphical interface to FIBS (First Internet Backgammon Server)
.SH SYNOPSIS
.B xfibs 
[
.BI \- toolkitoption ...
]
.SH DESCRIPTION
.PP 
.I XFibs
is a Motif-based interface to \fIFIBS\fP. \fIFIBS\fP allows you to play
backgammon against other people (and an increasing number of computer programs).
Unfortunately, \fIFIBS\fP is text-based and moves must be typed in numeric
notation. \fIXFibs\fP graphical interface provides a mouse-driven board, which
minimises text input. Below is an explanation of the various feautures of
\fIXFibs\fP, and what you may do to further customize it according to your own
desires. At the very end you'll also find the backgammon rules.
.SH GETTING STARTED
If you haven't installed the program yet, look into the README file that accompanied the source code for instructions. 
.SH HOW TO PLAY
For backgammon rules, see further down.
.PP
XFibs draws two windows, one to display a backgammon board which is fully
resizable and scalable; and another for the text information. \fIFIBS\fP is
a vibrant and lively place, often with lots of banter going on as well as
matches starting and finishing. With \fIXFibs\fP you'll only really use the
text window occasionally because you can forget all about how the board is
numbered, in \fIXFibs\fP you move your pieces with the mouse.
.PP
The right button brings forward a popup-menu with several choices like
"roll dice", "double" etc.,
selecting "roll dice" when it's your turn will cause two dice to appear.
.PP
The left button allows you to click on a piece and drag it to where you want to put it. You can then release the left button to drop the piece. If the move is
valid, \fIXFibs\fP will draw the piece at the new location. (You can now
pick-up a piece and move both dice in one action: i.e. 24-13 with 6-5, pick
up from 24, drop on 13. The left-hand die is the default first die of a move,
the the right-hand die. If the left-hand die can't move, \fIXFibs\fP will try
the reverse combination. So If you have a roll in both combinations are legal,
but only one hits an opponent, you may need to drag-and-drop to guarantee a hit
or a miss).
.PP
Alternatively, you can double-click on the middle button over a piece
to have \fIXFibs\fP move it (again the left-hand die is the default first die
of a move).
.PP
If you decide that you didn't want to move a piece, you can take it back
(either by drag-and-drop or by popup).
.PP
Once you are happy with a move, it 
has to be sent to \fIFIBS\fP. This is done by clicking your right mouse button
again. This popup menu changes according to what is going on. Now it says
"accept move", "undo move" etc. Between games in a match it says "join"
"leave". Try it out!
.PP
If you get a text description of the board in the output window, you have to 
issue a '\fIset boardstyle 3\fP' to \fIFIBS\fP. You may then save your setup my 
typing '\fIsave\fP' or include this command after a '\fIon\fP_\fIlogin\fP' command in 
your \fIstartup\fP file. (see below)
.PP
All in all, just fool around with it, it isn't that hard to figure out...
(At least I hope it isn't)
.SH LOCAL COMMANDS
\fILocal commands\fP are commands to \fIXFibs\fP, ie. they are not sent to 
\fIFIBS\fP. You may enter these either in the input window, (the window at the
bottom of the screen) or in your \fI.xfibsrc\fP-file. To indicate to 
\fIXFibs\fP that you are issuing a \fIlocal command\fP prepend it with 
either '\\' or '/'. 
.PP
To issue a \fIlocal command\fP in your \fIstartup\fP-file, drop the '\\' or the '/'.
.TP 5
.B gag \fP[\fIuser\fP]
To get rid of obcessive shouters, you may '\fIgag\fP' them. 
By issuing '\fI\\gag user\fP', you won't here shouts mande by user \fIuser\fP.
.br
Issuing '\fI\\gag\fP' by itself lists the gagged users.
.br
The second form isn't recognized in the \fIstartup\fP file
.TP 5
.B nogag \fIuser\fP
Removes "gagging" (Is that a word??) of user '\fIuser\fP'
.br
This command can't be used in the \fIstartup\fP file
.TP 5
.B hilite \fP[\fIword\fP]
Highlights every line coming from \fIFIBS\fP with "word" in it. May be used to
lead your attention to chosen events, like when people you have saved games 
with log in, when someone talks to you, etc.
.br
Issuing '\fI\\Hilite\fP' by itself, lists highlighted words. This form isn't recognized in the \fIstartup\fP-file.
.TP 5
.B nohilite \fIword\fP
Removes highlighting of specified word
This command can't be used in the \fIstartup\fP file.
.TP 5
.B \fP[\fBno\fP]\fBcolor\fP/[\fBno\fP]\fBcolour
Tells \fIXFibs\fP to use color or not. May be useful if your X-terminal has 
limited number of colors, and some other application has already grabbed most of them. You know when to use it when this happens...
.TP 5
.B \fP[\fBno\fP]\fBscroll
Determine whether you want the input window to scroll or not. Personally,
I never got used to the scrolling one...
.TP 5
.B \fP[\fBno\fP]\fBblanks
Indicates whether there should be a blank line between responses from the server
in the output window. Turn it off for those that have smaller output windows.
The default is to have no blank lines.
.TP 5
.B \fP[\fBno\fP]\fBecho
Indicates whether the commands given to fibs via the input window or the mouse
should be echoed into the output screen. The default is for no echoing to be
done.
.TP 5
.B \fP[\fBno\fP]\fBnumbers
Indicates whether the piece positions (1-24) should be drawn around the border
of the board. When drawing numbers the width of the board border remains the
same even if you reduce the board size. When not drawing numbers the border
width stays proportional to the board size. The default is to draw the numbers.
.TP 5
.B undo
Allows the last piece moved to be returned to it's previous position. Handy
when your mouse breaks :-)
.br
This command can't be used in the \fIstartup\fP file
.TP 5
.B log \fImode\fP \fP[\fI+\fP]\fB
Used to specify exactly what gets written to the logfile. \fImode\fPs are:
.RS
.TP
.B input \fB
What FIBS sends us
.TP
.B all \fB
As input + all boards in ascii
.TP
.B play \fB
Everything FIBS says "You", your opponent or the player you're watching do.
.TP
.B boards \fB
All boards in ascii
.TP
.B none \fB
Nothing (allows for just dumping occasional boards in ascii - see \fIdump\fP).
.RE
.TP 5
.B logfile \fP[\fIfilename\fP]\fB
Used in order to create a logfile on disk containing a copy of all of the output
that goes to the output window (including echoed input). Boards are sent to the
log file in ascii format. Recording begins when you issue the command.
If the \fIfilename\fP is not specified, then a file with the default name of
"xfibs.logfile" is used. Otherwise the supplied filename is used. If the file
already exists, the recording will be appended to the end of the file.
.TP 5
.B nologfile
This will close the currently open logfile and stop recording of the output
into it.
.TP 5
.B \fP[\fBno\fP]\fBlogpath \fP[\fIpath\fP]\fB
This specifies the directory to use for the logfile. Must be be terminated by a
file separator, e.g.  /users/mike/bg/games/ . If no parameter is given, the
current logpath is displayed. \fInologpath\fB clears the logpath.
.TP 5
.B dump
This dumps an ascii representation of the current board (as received from
\fIFIBS\fP) to the logfile. The logfile must be already open. 
.br
This command can't be used in the \fIstartup\fP file
.TP 5
.B pip
Display a pip count for the numerically challenged (and lighten the load on
\fIFIBS\fP if you really can't work it out).
.br
This command can't be used in the \fIstartup\fP file
.TP 5
.B \fP[\fBno\fP]\fBframe
Display player names on the frame around the backgammon board. This enables
you to resize the window to be barely larger than the playing area. It looks
a little odd on small window sizes, since the frame cannot stay in
proportion to the rest of the board. The default is not to have names on the
frame - they appear at the side of the board instead..
.TP 5
.B \fP[\fBno\fP]\fBside
Display player names at the side of the backgammon board. This gives the
clearest display, with the match score always close to the cube and each
home side of the board clearly marked. If noside is used, the names are
drawn on the frame. The default is to have names on the side.

.SH STARTUP FILE
As \fIXFibs\fP starts up, it tries to read the file \fI.xfibsrc\fP located in
your home-directory. If it doesn't find this file, \fIXFibs\fP starts up with 
a default setup.
.PP
.B What goes into this file?
.br
There are several things that you may wish to put in there. You may define your
own menu system, specify user-name and password (on \fIFIBS\fP that is), 
list local commands you want to issue at every session, specify 
automatic login and specify commands to send to \fIFIBS\fP after logging in. (Phew!)
.PP
.B You wouldn't mind telling me how, would you?
.br
No, I won't... Below are a quick explanation of the format of this file. Together with the source code for \fIXFibs\fP there where a file '\fIxfibsrc\fP' which may give you some more ideas.
.TP 5
.B Host \fIhostname\fP
Specify the hostname or ip-number of the \fIFIBS\fP-host. At present this is 
fraggel65.mdstud.chalmers.se (129.16.235.165)
.TP
.B Port \fIportnumber\fP
Specify the port-number to which \fIXFibs\fP should connect. At present this is 
4321
.TP
.B User \fIYour-name-goes-here\fP
Specify your user name on \fIFIBS\fP. When both the user name and password
(see below) are specified, you are utomaticcaly logged into \fIFIBS\fP when you connect.
.TP
.B Password \fIYour-password-goes-here\fP
Specify your password on \fIFIBS\fP. DON'T USE THE SAME PASSWORD ON FIBS AS YOU DO ON ANY OTHER SYSTEM!
.TP
.B Menu \fIMenuName \fP[\fIShortcutKey\fP]
Define a menu with \fIMenuName\fP as it's name. The ShortcutKey is optional.
.TP
.B Item \fIItemname \fP[\fIShortcutKey\fP] \fIcommand\fP
Define a menu item with the name \fIItemname\fP. When chosen \fIcommand\fP is
issued. The command may be either a \fIlocal comand\fP or a command 
to \fIFIBS\fP. 
.br
If you want to use several word in either the name or the
command, put those words inside double-quotes. 
.br
Ellipses "..." at the end of a command makes the command to be put into the
input buffer for you to finish it, like "toggle..." puts "toggle" into 
input buffer.
.TP
.B Separator
Creates a separator between menu items. Just to make things look good :)
.PP
Have a look at the \fIxfibsrc\fP-file that came with the source for examples of use of these commands. You may have a maximum of 400 menu items. (That should
be more than enough!)
.TP
.B Commands specific to the startup-file
In addition to the commands mentioned earlier, there are a few commands that
are recognized solely in the \fIstartup\fP file.
.TP
.B autologin
Makes \fIXFibs\fP try to connect to the \fIFIBS\fP-server as soon as the program is started.
.TP
.B on_login
Every line after this one is sent directly to \fIFIBS\fP after successfully logging in.
.TP
.B autologin
Makes \fIXFibs\fP try to connect to the \fIFIBS\fP-server as soon as the program is started.
.TP
.B columns \fInumber\fP
Specify a number of columns for the text windows.
.TP
.B fibslines \fInumber\fP
Specify a number of lines for the \fIFIBS\fP text window.
.TP
.B typelines \fInumber\fP
Specify a number of lines for the user input window.
.SH SPECIFYING APPLICATION RESOURCES
In addition to the standard X-windows resources, the following may be
specified in an app-defaults file or in your .Xdefaults file:
.TP
.B *bgboard.font: \fIfontname\fP
Font to use in the graphics area
.TP
.B *outtext*fontList: \fIfontname\fP
Font to use in the FIBS output window
.TP
.B *intext*fontList: \fIfontname\fP
Font to use in the user input window
.TP
.B *bgboard.table: \fIcolorname\fP
Color to use for the table, behind the backgammon board
.TP
.B *bgboard.frame: \fIcolorname\fP
Color to use for the framework of the backgammon-board
.TP
.B *bgboard.base: \fIcolorname\fP
Color to use for the "inside" of the backgammon board
.TP
.B *bgboard.wpoint: \fIcolorname\fP
Color to use for the "white" points
.TP
.B *bgboard.bpoint: \fIcolorname\fP
Color to use for the "black" points
.TP
.B *bgboard.wpiece: \fIcolorname\fP
Color to use for the "white" pieces
.TP
.B *bgboard.bpiece: \fIcolorname\fP
Color to use for the "black" pieces
.TP
.B *bgboard.dblcube: \fIcolorname\fP
Color of the double-cube
.TP
.B *bgboard.dbltext: \fIcolorname\fP
Color of the double-cube text
.TP
.B *bgboard.foreground:
Color of the "white" text in the graphics window
.TP
.B *bgboard.background:
Color of the "black" text in the graphics window
.TP
.B *bgboard.numbers:
Boolean flag if numbers visible
.TP
.B *bgboard.onFrame:
Boolean flag if user names are displayed on the frame of the board
.TP
.B *outtext*columns:
Number of columns displayed in the FIBS output window
.TP
.B *outtext*rows:
Number of rows displayed in the FIBS output window
.TP
.B *intext*columns:
Number of columns displayed in the user input window
.TP
.B *intext*rows:
Number of rows displayed in the user input window
.SH RULES
.PP
The following is an excerpt from the rec.games.backgammon FAQ 
[Frequent answered Questions]
.TP 5
.B Rule 1
What the board looks like
.PP
Backgammon is a two player game. It's played with 2 dice and 15 pieces
for each player on a board with 24 positions and a field called the bar.
Before the game starts the pieces are placed on the board like this:

            +-24-23-22-21-20-19-------18-17-16-15-14-13-+
            |  X              O |   |     O           X |
            |  X              O |   |     O           X |
            |                 O |   |     O           X |
            |                 O |   |                 X |
            |                 O |   |                 X |
            |                   |BAR|                   |v
            |                 X |   |                 O |
            |                 X |   |                 O |
            |                 X |   |     X           O |
            |  O              X |   |     X           O |
            |  O              X |   |     X           O |
            +--1--2--3--4--5--6--------7--8--9-10-11-12-+

.TP 5
.B Rule 2 
The direction you move piece
.PP
(refer to the board shown in rule 1 for the numbers of the positions)
One of the players (O) moves her or his pieces from position 1 to position
24, the other one (X) from position 24 to position 1. For the board shown
in rule 1 you would move the X pieces from 24 to 1. The last six positions
for each player (1-6 for O and 19-24 for X) are called the player's home
board. You always move the pieces to your side of the board, but note that
the home board is on the left of the board from X's point of view and on
the right from O's point of view. The server always shows a 'v' on one side
of the board indicating the direction of your moves.
.TP 5
.B Rule 3
The goal of the game
.PP
When you have moved all of your pieces into your home board you can bear
them off (remove them from the board according to the numbers on the dice).
The winner of a game is the first player who succeeds in bearing of all
own pieces from the board.
.TP 5
.B Rule 4
Rolling the dice
.PP
At the beginning of a game each player rolls with a single die. If both
players roll the same number they have to roll again. The player who
finally rolls the higher number makes the first move using the two numbers
just rolled. After the opening roll both players roll alternating using
two dice.
.TP 5
.B Rule 5
Moving pieces
.PP
After rolling the dice you have to move pieces. Moving pieces means either:
.TP 2
- 
moving one or more pieces on the board. You move the number of positions
according to the number of the dice. E.g: if one of the dice shows the
number 4 you can move one of your pieces 4 positions in your direction.
If you move one piece with both numbers on the dice this is considered
being two separate moves.
.TP
- 
entering one or more pieces from the bar into your opponent's home board
according to the numbers on the dice. E.g.: if one of the dice shows the
number 4 you can enter one piece from the bar to position 4 or 21
(depending on where your opponent's home board is).
.TP
- 
bearing off pieces from the the board if none of your pieces is on the
bar or outside your home board. (see rule 7 for details)
.TP 5
.B Rule 6
Moving pieces
.PP
.TP 3
a.
If you roll a double the number on the dice is used four  times to move a piece.
.TP
b.
You have to use both (all) numbers on the dice if possible. You can use
any of the numbers first. If you can use either of the numbers but not
both, you have to use the higher one for moving one piece.
.TP
c.
It's not allowed to move a piece to a position occupied by two or
more pieces of your opponent.
.TP
d.
If you move a piece to a position occupied by a single piece (blot)
of your opponent, this piece is removed from the board and placed on
the bar. This piece can later be re-entered into your home board according
to rule 5.
.TP
e.
If one of your pieces is on the bar, you are not allowed to move
pieces on the board before the piece on the bar has been re-entered.
.TP 5
.B Rule7
Bearing off pieces
.PP
When you are allowed to bear off pieces (rule 5) you can bear off a piece
from a position matching the number on a die (e.g. 5 or 20 if you have
rolled a 5) or a piece from the highest occupied position smaller than
the number on the die. If you roll a number matching an unoccupied
position you are not allowed to bear off pieces from smaller positions if
there are any pieces on higher positions. You have to move one of the
pieces on the higher positions in this case. You are not forced to bear
off pieces if it is also possible to move pieces inside your home board and
rule 6 is not violated.
.TP 5
.B Rule8
Winning
.PP
The value of a game is the number of points the winner gains at the end of
the game. This value is initially 1.
.br
The player who bears off all her or his pieces first is the winner of the
game and wins the value of that game. If you win and your opponent couldn't
bear off any piece the value of the game is doubled (this is called
winning a 'gammon').
.br
You win a 'backgammon' if your opponent couldn't bear off any piece and one
or more of her or his pieces are still on the bar or inside your home
board. In this case the value of the game is multiplied by 3.
.TP 5
.B Rule 9
Doubling
.PP
Any player may offer to double the value of a game. After the first double
the right to offer the next one alternates between the two players. The
player who has accepted the last double is the one who is allowed to offer
the next one. You may offer a double when it's your turn to roll but you
haven't rolled yet. An offered double can be accepted or rejected (declined).
If a double is declined the game is over and the player who has offered the
double wins the value of the game before the double was offered.
If a player wins a gammon or a backgammon the value of the game as deter-
mined by previous doubling is multiplied by 2 or 3 (see rule 8).
.SH CAVEATS
If you get an error message complaining about font-loading, try starting 
.I xfibs
as
.I xfibs -font fixed

.br
If the colors comes up weird, maybe due to another application grabbing all the
available colors, type 
.I /nocolor
in the input window. That should do the trick.
.br
If the board comes up as text in the output window, issue a '\fIset boardstyle
3\fP' to \fIFIBS\fP. You may also put that line into your \fIstartup\fP file after a \fIon\fP_\fIlogin\fP command.
.SH BUGS
Small creepy thingies which tend to live under rocks. There are probably a few
lurking around inside this program too - see the TO_DO file that accompanied
the source code.
.SH AUTHOR
Torstein Hansen
.TP 5
.B torstein@itekiris.kjemi.unit.no
.PP
.PP
Minor patches made by David Eggert (Snoopy) 
.TP 5
.B eggertd@figment.csee.usf.edu
.PP
.PP
Changes since version 0.7 made by Mike Quinn (mikeq) 
.br
.TP 5
.B mike@abekrd.co.uk
(liable to change - type 'whois mikeq' on \fIFIBS\fP to find my current
address).
.SH SEE ALSO
Your psyciatrist
.br
The rec.games.backammon FAQ
.br
The FIBS Help files
.SH COPYRIGHT
copyright (c) 1993 by Torstein Hansen, 1995 by Mike Quinn
.PP
Permission to use, copy, modify, erase etc. etc. are hereby granted.
If you use the code in any other product, I'd like to know about it, though.
.SH DISCLAIMER
I take no responsibility of corrupted hard drives, lost productivity, lost wages, dandruff, bad weather, high taxes, plagues, or any other misfortune you may encounter due to use of this program.
.PP
Due to small parts inside, this program should not be used by children under 3 years old. 
