.\" X-BASED TRIANGLES
.\"
.\" xtriangles.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 99	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH TRIANGLES 6 "20 June 1999" "V5.5"
.SH NAME
xtriangles \- Triangles X widget
.SH SYNOPSIS
.B /usr/games/xtriangles
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-tile {color}] [-size {int}]
[-base {int}] [-username {string}]
.SH DESCRIPTION
This is basically no harder than the 15 puzzle.   The 15 puzzle was
originally made around 1879 (the 14-15 puzzle of Sam Loyd was made soon
after).   T. R. Dawson in Original Puzzles has a similar puzzle with 4
diamond- and 6 triangular-shaped pieces.
.SH FEATURES
Click "\fBmouse-left\fP" button to move a tile.  Clicks on spaces or
clicks tiles that are not in line with the two spaces will not move the
tiles.  Notice one can move more than one tile at a time by clicking on
the tile farthest from the spaces but in line with the spaces.
.LP
Click "\fBmouse-right\fP" button, or press "\fBR\fP" or "\fBr\fP" keys,
to randomize the puzzle.  One must double click on "\fBmouse-right\fP" if
the puzzle is being worked on.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of tiles.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of tiles.
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (unimplemented).
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad, "R" keys, or arrow keys to move without the mouse.
.br
Key pad is defined for Triangles as:
.br
7   9  Upper Left, Upper Right
.br
  ^ 
.br
4< >6  Left, Right
.br
  v
.br
1   3  Bottom Left, Bottom Right
.LP
The title is in the following format (non-motif version):
.RS
xtriangles: <size> @ (<Number of moves>/{<Record number of moves>
<username>|"NEVER noaccess"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the triangles window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the triangles window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the triangles window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the tiles in the triangles
window (resource name "\fIborderColor\fP").
.TP 8
.B \-tile \fIcolor\fP
This option specifies the tile color of the triangles window (resource name
"\fItileColor\fP").
.TP 8
.B \-size <\fIint\fP>
This option allows you to change the number of triangles in a row (resource
name "\fIsizeA\fP").
.TP 8
.B \-base \fIint\fP
This option specifies the base used (default is base 10) (resource name
"\fIbase\fP").
.TP 8
.B \-username \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
.RS
size: 1-16 <number of tiles in a row of the same orientation as the puzzle>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <array of tile positions where 0 is the empty space for
the UP triangle and -1 is the empty space for the DOWN triangle>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <direction>
.RE
Direction is represented as 0 upper right, 1 right, 2 lower right,
3 lower left, 4 left, and 5 upper left.
.sp
Caution: the program may crash on corrupted input.
.SH REFERENCES
Sliding Piece Puzzles (Recreations in Mathematics Series) by L. E. Horden,
Oxford University Press 1986, pp 1, 148, 149.
.sp
Puzzles Old & New (How to Make and Solve Them) by Jerry Slocum & Jack
Botermans, University of Washington Press, Seattle, 1987, pp 126, 127.
.SH SEE ALSO
.LP
X(1),  xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xmlink(6), xpanex(6), xcubes(6), xhexagons(6), xabacus(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-99, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ftp.x.org/contrib/games\fP

