/* Copyright (C) 1994 Groupe BULL. See file COPYRIGHT for details */
/*
 *
 * $Id: kt_krl.c,v 1.2 1994/12/15 13:39:17 beust Exp $
 */

#include <stdio.h>
#include <assert.h>
#include "kt_lib.h"
#include "kt_typesP.h"
#include "database.h"

/*
**---------------------------------------------------------------------------
** kt_KRLDeclare
*/
Kt_KRL
kt_KRLNew(Kt_Context context, char *krlName)
{
   Kt_serverConnection serverConn = context -> serverConn;   
   Kt_KRL result;

   if (NULL != serverConn) {
      NEW(result, Kt_KRLRec);
      /*
      ** Don't change the order of these assignments
      */
      serverConn -> lastDeclaredKRLName = kt_strdup(krlName);       /* @@ leak */
      serverConn -> lastDeclaredKRLId = serverConn -> krlUniqueId;
      kt_sendPacket(context, serverConn, Ktp_KRL_DECLARE);
      
      result -> krlId = serverConn -> krlUniqueId++;
      result -> krlName = kt_strdup(krlName);
   }
   else {
      fprintf(stderr, "*** kt_KRDeclare : not connected to any server\n");
      result = 0;
   }
   return result;
}


/*
 **---------------------------------------------------------------------------
 ** kt_KRObserve
 */
CARD32
kt_KRObserve(Kt_Context context, char *krs,  
	      Kt_CallbackServerMsg callback, void *userData)
{
   CARD32 result = context -> serial++;

   Kt_serverConnection serverConn = context -> serverConn;
   Kt_interestedInCallback ic;

   if (NULL != serverConn) {
      /*
      ** Record this observation
      */
      NEW(ic, Kt_interestedInCallbackRec);
      ic -> callback = callback;
      ic -> userData = userData;
      ic -> krs = kt_strdup(krs);
      ic -> krSpecId = result;
      ic -> isObserve = True;
      DB_AddEntry(context -> interestedInCallbacks, ic);
      
      /*
      ** Tell the server about it
      */
      serverConn -> lastInterestedInKRSpec = kt_strdup(krs);   /* @@ leak */
      serverConn -> lastKRSpecId = result;
      serverConn -> lastCallback = callback;
      serverConn -> lastUserData = userData;
      kt_sendPacket(context, serverConn, Ktp_KR_OBSERVE);
   }
   else {
      fprintf(stderr, "*** kt_KRObserve : not connected to any server\n");
      result = 0;
   }

   return result;
}

/*
 **---------------------------------------------------------------------------
 ** kt_KRUnObserve
 */
static Bool
findId(Kt_interestedInCallback ic, CARD32 id)
{
   if (True == ic -> isObserve && id == ic -> krSpecId) return True;
   else return False;
}

Kt_Status
kt_KRUnObserve(Kt_Context context, CARD32 krId)
{
   Kt_Status result = KT_OK;
   Kt_serverConnection serverConn = context -> serverConn;
   Kt_interestedInCallback ic;

   if (NULL != serverConn) {
      DataBase db = context -> interestedInCallbacks;

      /*
      ** Remove the observed krId from our internal table
      */
      NEW(ic, Kt_interestedInCallbackRec);
      ic = DB_LocateEntry(db,
			  (void *) ((unsigned long) findId),
			  (void *) ((unsigned long) krId));
                                /* alpha kludge */
      if (NULL != ic) {
	 DB_RemoveEntry(db, ic);
      }
      else {
	 fprintf(stderr, "*** kt_KRUnObserve: %d, no such krid\n", krId);
	 result = KT_ERR;
      }
      
      /*
      ** Tell the server about it
      */
      serverConn -> lastKRSpecId = krId;
      kt_sendPacket(context, serverConn, Ktp_KR_UNOBSERVE);
   }
   else {
      fprintf(stderr, "*** kt_KRUnObserve : not connected to any server\n");
      result = KT_ERR;
   }

   return result;
}

/*
 **---------------------------------------------------------------------------
 ** kt_KRHandle
 */
CARD32
kt_KRHandle(Kt_Context context, char *krs,
	    Kt_CallbackHandlerMsg callback, void *userData)
{
   CARD32 result = context -> serial++;
   Kt_handler handler;

   Kt_serverConnection serverConn = context -> serverConn;
   Kt_interestedInCallback ic;

   if (NULL != serverConn) {
      /*
      ** Tell the server about it.
      */
      serverConn -> lastInterestedInKRSpec = kt_strdup(krs);   /* @@ leak */
      serverConn -> lastKRSpecId = result;
      serverConn -> lastCallback = callback;
      serverConn -> lastUserData = userData;
      kt_sendPacket(context, serverConn, Ktp_KR_HANDLE);

      /*
      ** Record it
      */
      NEW(ic, Kt_interestedInCallbackRec);
      ic -> callback = callback;
      ic -> userData = userData;
      ic -> krs = kt_strdup(krs);
      ic -> krSpecId = result;
      ic -> isObserve = False;
      DB_AddEntry(context -> interestedInCallbacks, ic);

      /*
      ** Put it in our personal database, but use the special value NULL
      ** for directIdentity, meaning "myself"
      */
      handler = kt_addHandlerDetailed(serverConn -> lastInterestedInKRSpec,
				      result, context -> directIdentity,
				      callback, userData);

      /*
      ** Check if this KRS matches any awaiting requests (e.g. if
      ** this client just declared itself a handler for a request
      ** it issued some time ago
      */
      kt_checkOutPendingRequests(handler);
   }
   else {
      fprintf(stderr, "*** kt_KRHandle : not connected to any server\n");
      result = 0;
   }
   return result;
}

/*
 **---------------------------------------------------------------------------
 ** kt_KRLFree
 */
void
kt_KRLFree(Kt_KRL krl)
{
   if (NULL != krl) {
      SAFE_FREE(krl -> krlName);
      SAFE_FREE(krl);
   }
}

