/* Copyright (C) 1994 Groupe BULL. See file COPYRIGHT for details */
/*
 *
 * $Id: kt_libP.h,v 1.1 1994/10/07 16:34:43 beust Exp beust $
 * Declarations for kt_lib.c
 * This is a _private_ file, not to be included for normal use
 */

#ifndef __KT_LIBP_H__
#define __KT_LIBP_H__

#include <stddef.h>     /* for size_t */

/*
** Protocol constants, ICE related
*/
#define PVENDOR "Bull"
#define PNAME "ktalk"
#define PRELEASE "1"

#define PDIRECT_NAME "ktalk-direct"
#define PDIRECT_RELEASE "1"


#ifndef NEW
#define NEW(v,t) v = (t *) malloc(sizeof(*v))
#endif

#define ICE_HEADER\
    CARD8 majorOpcode;\
    CARD8 minorOpcode;\
    CARD8 data[2];\
    CARD32 length B32

#define ICE_HEADER_SIZE (sizeof(iceMsg))

/*
 ** Protocol
 ** Ktp = KT protocol id
 ** Ktm = KT message
 ** For each packet, three symbols are defined :
 **    Ktp_<PACKET>             the packet opcode
 **    Ktm_<PACKET>             the packet structure
 **    K_SIZEOF_<PACKET>        a function to calculate the size
 **                             This macro must be given all the arguments
 **                             that will be included in the packet in order
 **                             to compute its size
 */

/* Messages received by the server [1, 127] */

#define Ktp_NEW_CLIENT 1
#define K_SIZEOF_NEW_CLIENT(_il,_id) (sizeof(CARD32) + strlen(_id))
typedef struct _Ktm_NewClient {
   ICE_HEADER;
   CARD32 identityLength;
   char *identity;
} Ktm_NewClientRec, *Ktm_NewClient;

#define Ktp_KRL_DECLARE 2
#define K_SIZEOF_KRL_DECLARE(_id,_l,_name) (sizeof(CARD32) + sizeof(CARD32) + strlen(_name))
typedef struct _Ktm_KRLDeclare {
   ICE_HEADER;
   CARD32 id;            /* id of sender */
   CARD32 krlId;         /* id of this krl as chosen by the toolkit */
   CARD32 nameLength;
   char *name;           /* name of the KRL declared */
} Ktm_KRLDeclareRec, *Ktm_KRLDeclare;

/*
** Missing packet 3
*/

#define Ktp_MESSAGE_SENT 4
#define KK_SIZEOF_MESSAGE_SENT()
typedef struct _Ktm_MessageSent {
   ICE_HEADER;
   CARD32 dest;    /* the krlid where this message is being sent */
   void *bytes;
} Ktm_MessageSentRec, *Ktm_MessageSent;


#define Ktp_KR_OBSERVE 5
#define K_SIZEOF_KR_OBSERVE(_id,_kid,_l,_spec) (sizeof(CARD32) * 3 + strlen(_spec))
typedef struct _Ktm_KRObserve {
   ICE_HEADER;
   CARD32 id;
   CARD32 krSpecId;
   CARD32 krSpecLength;
   char *krSpec;
} Ktm_KRObserveRec, *Ktm_KRObserve;

#define Ktp_KR_HANDLE 6
#define K_SIZEOF_KR_HANDLE(_spec,_name) (sizeof(CARD32) * 4 + strlen(_spec) + strlen(_name))
typedef struct _Ktm_KrHandle {
   ICE_HEADER;
   CARD32 id;
   CARD32 krSpecId;
   CARD32 krSpecLength;
   CARD32 nameLength;
   char *krSpec;
   char *name;
} Ktm_KRHandleRec, *Ktm_KRHandle;

/* Messages sent by the server [129, 199] */

#define Ktp_NEW_CLIENT_REPLY 129
#define K_SIZEOF_NEW_CLIENT_REPLY(_id) (sizeof(CARD32))
typedef struct _Ktm_NewClientReply {
   ICE_HEADER;
   CARD32 uniqueId;
} Ktm_NewClientReplyRec, *Ktm_NewClientReply;

#define Ktp_MESSAGE_FORWARDED 130
#define KK_SIZEOF_MESSAGE_FORWARDED()
typedef struct _Ktm_MessageForwarded {
   ICE_HEADER;
   CARD32 dest;
   CARD32 krSpecId;
   void *bytes;
} Ktm_MessageForwardedRec, *Ktm_MessageForwarded;

#define Ktp_NEW_HANDLER 131
#define K_SIZEOF_NEW_HANDLER(_krs,_ice) (strlen(_krs) + strlen(_ice) + 3 * sizeof(CARD32))
typedef struct _Ktm_NewHandler {
   ICE_HEADER;
   CARD32 krSpecId;
   CARD32 krSpecLength;
   CARD32 iceCoordLength;
   char *krSpec;
   char *iceCoord;
} Ktm_NewHandlerRec, *Ktm_NewHandler;

#define Ktp_DELETE_HANDLER 132
#define K_SIZEOF_DELETE_HANDLER(_ic) (sizeof(CARD32) + strlen(_ic))
typedef struct _Ktm_DeleteHandler {
   ICE_HEADER;
   CARD32 iceCoordLength;
   char *iceCoord;
} Ktm_DeleteHandlerRec, *Ktm_DeleteHandler;

/* Messages exchanged between peers [200, 255] */

#define Ktp_PEER_TO_PEER 201
#define KK_SIZEOF_PEER_TO_PEER(_bytes)
typedef struct _Ktm_PeerToPeer {
   ICE_HEADER;
   CARD32 dest;      /* unused here, see Ktm_Message */
   CARD32 krlId;
   void *bytes;
} Ktm_PeerToPeerRec, *Ktm_PeerToPeer;

#define Ktp_REQUEST 202
#define K_SIZEOF_REQUEST(_krl, _ice, _msg) (strlen(_krl->krlName) + strlen(_ice) + 4*sizeof(CARD32) + _msg->size)
typedef struct _Ktm_Request {
   ICE_HEADER;
   CARD32 dest;      /* unused here, see Ktm_Message */
   CARD32 krlId;
   CARD32 krlLength;
   CARD32 iceCoordLength;
   char *krl;
   char *iceCoord;
   void *bytes;
} Ktm_RequestRec, *Ktm_Request;

#define Ktp_REPLY_TO_REQUEST 203
#define KK_SIZEOF_REPLY_TO_REQUEST()
typedef struct _Ktm_ReplyToRequest {
   ICE_HEADER;
   CARD32 dest;      /* unused here, see Ktm_Message */
   CARD32 krlId;
   void *bytes;
} Ktm_ReplyToRequestRec, *Ktm_ReplyToRequest;


#endif /* __KT_LIBP_H__ */
