/* Copyright (C) 1994 Groupe BULL. See file COPYRIGHT for details */
/*
 *
 * $Id: kt_protocolP.h,v 1.3 1994/12/15 13:37:44 beust Exp $
 * Declarations for packets in the Koalatalk protocol
 * This is a _private_ file, not to be included for normal use
 */

#ifndef __KT_PROTOCOLP_H__
#define __KT_PROTOCOLP_H__

#include <stddef.h>     /* for size_t */

/*
** Protocol constants
*/

#define PVENDOR "Bull"
#define PNAME "ktalk"
#define PRELEASE "1"

#define PDIRECT_NAME "ktalk-direct"
#define PDIRECT_RELEASE "1"

#ifndef NEW
#define NEW(v,t) v = (t *) malloc(sizeof(*v))
#endif

/*
** This is used as a dummy value for fields that are not relevant
** in certain packets. Since it might be evaluated as a length, the
** value *has* to be zero
*/
#define KT_NOT_RELEVANT 0

#define ICE_HEADER\
    CARD8 majorOpcode;\
    CARD8 minorOpcode;\
    CARD8 data[2];\
    CARD32 length B32

#define ICE_HEADER_SIZE (sizeof(iceMsg))

/*
** Protocol
** Ktp = KT protocol id
** Ktm = KT message
** For each packet, three symbols are defined :
**    Ktp_<PACKET>             the packet opcode
**    Ktm_<PACKET>             the packet structure
**    K_SIZEOF_<PACKET>        a function to calculate the size
** The value returned should
**                             This macro must be given all the arguments
**                             that will be included in the packet in order
**                             to compute its size
*/

/* Where is inheritance when you need it? */
#define KT_HEADER ICE_HEADER;\
                  CARD32 krlId;\
                  CARD32 opLength


/* Messages received by the server [1, 127] */

#define Ktp_NEW_CLIENT 1
typedef struct _Ktm_NewClient {
   KT_HEADER;
   CARD32 identityLength;
   CARD32 krsLength;
   char *identity;
   char *krs;
} Ktm_NewClientRec, *Ktm_NewClient;

#define Ktp_KRL_DECLARE 2
typedef struct _Ktm_KRLDeclare {
   KT_HEADER;
   CARD32 id;            /* id of sender */
   CARD32 nameLength;
   char *name;           /* name of the KRL declared */
} Ktm_KRLDeclareRec, *Ktm_KRLDeclare;

/*
** Missing packet 3
*/

/*
** Messages exchanged between clients have the bytes field
** at the end. Since declaring bytes[0] is not sure to be
** portable, I have to use 1 and correct the value with the
** following macro
*/

#define K_VARIABLE_FIELD(p) (p)
/*
#define MESSAGE_HEADER                 ICE_HEADER;\
#define K_SIZEOF_MSG_HEADER(_oop)  (2 * sizeof(CARD32) + strlen(_oop))
*/

#define Ktp_MESSAGE_SENT 4
typedef struct _Ktm_MessageSent {
   KT_HEADER;
   char *bytes[1];
} Ktm_MessageSentRec, *Ktm_MessageSent;


#define Ktp_KR_OBSERVE 5
typedef struct _Ktm_KRObserve {
   KT_HEADER;
   CARD32 krSpecId;
   CARD32 krSpecLength;
   char *krSpec;
} Ktm_KRObserveRec, *Ktm_KRObserve;

#define Ktp_KR_HANDLE 6
typedef struct _Ktm_KrHandle {
   KT_HEADER;
   CARD32 krSpecId;
   CARD32 krSpecLength;
   CARD32 nameLength;
   char *krSpec;
   char *name;
} Ktm_KRHandleRec, *Ktm_KRHandle;

#define Ktp_KR_UNOBSERVE 7
typedef struct _Ktm_KrUnObserve {
   KT_HEADER;
   CARD32 krSpecId;
} Ktm_KRUnObserveRec, *Ktm_KRUnObserve;

#define Ktp_KR_UNHANDLE 8
#define KK_SIZEOF_KR_UNHANDLE(_id) (sizeof(CARD32))
typedef struct _Ktm_KrUnHandle {
   KT_HEADER;
   CARD32 id;
} Ktm_KRUnHandleRec, *Ktm_KRUnHandle;

#define Ktp_LAUNCH 9
typedef struct _Ktm_Launch {
   KT_HEADER;
   CARD32 krlLength;
   char *krl;
} Ktm_LaunchRec, *Ktm_Launch;

#define Ktp_MESSAGE_SEND_ON_EXIT 10
typedef struct _Ktm_MessageSendOnExit {
   KT_HEADER;
   char *bytes[1];
} Ktm_MessageSendOnExitRec, *Ktm_MessageSendOnExit;

/* Messages sent by the server [129, 199] */

#define Ktp_NEW_CLIENT_REPLY 129
typedef struct _Ktm_NewClientReply {
   KT_HEADER;
   CARD32 uniqueId;
} Ktm_NewClientReplyRec, *Ktm_NewClientReply;

#define Ktp_MESSAGE_FORWARDED 130
typedef struct _Ktm_MessageForwarded {
   KT_HEADER;
   CARD32 krSpecId;
   CARD32 senderCoordLength;
   char *bytes[1];
} Ktm_MessageForwardedRec, *Ktm_MessageForwarded;

#define Ktp_NEW_HANDLER 131
typedef struct _Ktm_NewHandler {
   KT_HEADER;
   CARD32 krSpecId;
   CARD32 krSpecLength;
   CARD32 iceCoordLength;
   char *krSpec;
   char *iceCoord;
} Ktm_NewHandlerRec, *Ktm_NewHandler;

#define Ktp_DELETE_HANDLER 132
typedef struct _Ktm_DeleteHandler {
   KT_HEADER;
   CARD32 iceCoordLength;
   char *iceCoord;
} Ktm_DeleteHandlerRec, *Ktm_DeleteHandler;

#define Ktp_CLIENT_EXITED 133
typedef struct _Ktm_ClientExited {
   KT_HEADER;
   char *bytes[1];
} Ktm_ClientExitedRec, *Ktm_ClientExited;

/* Messages exchanged between peers [200, 255] */

#define Ktp_PEER_TO_PEER 201
typedef struct _Ktm_PeerToPeer {
   KT_HEADER;
   CARD32 iceCoordLength;
   char *bytes[1];
} Ktm_PeerToPeerRec, *Ktm_PeerToPeer;

#define Ktp_REQUEST 202
typedef struct _Ktm_Request {
   KT_HEADER;
   CARD32 requestId;
   CARD32 krlLength;
   CARD32 iceCoordLength;
   char *krl;
   char *iceCoord;
   char *bytes[1];
} Ktm_RequestRec, *Ktm_Request;

#define Ktp_REPLY_TO_REQUEST 203
typedef struct _Ktm_ReplyToRequest {
   KT_HEADER;
   CARD32 requestId;
   CARD32 iceCoordLength;
   char *iceCoord;
   char *bytes[1];
} Ktm_ReplyToRequestRec, *Ktm_ReplyToRequest;


#endif /* __KT_PROTOCOLP_H__ */
